/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl.lwjgl;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.nio.ByteBuffer;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.expr.ExprEditor;
import javassist.expr.NewExpr;
import javax.imageio.ImageIO;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.LegacyFixAgent;
import uk.betacraft.legacyfix.LegacyFixLauncher;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchHelper;

public class LWJGLFramePatch
extends Patch {
    public LWJGLFramePatch() {
        super("lwjgl-frame", "Patches LWJGL Frame for title and resolution", true);
    }

    public void apply(final Instrumentation inst) throws Exception {
        try {
            Icons.loadIcons((String)LegacyFixAgent.getSettings().get("lf.icon"));
        }
        catch (Exception e) {
            LFLogger.error(this, (Throwable)e);
        }
        CtClass displayClass = pool.get("org.lwjgl.opengl.Display");
        if (displayClass.isFrozen()) {
            displayClass.defrost();
        }
        CtMethod setTitleMethod = displayClass.getDeclaredMethod("setTitle", new CtClass[]{PatchHelper.stringClass});
        setTitleMethod.insertBefore("Class legacyfix = ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.legacyfix.LegacyFixLauncher\");$1 = (String) legacyfix.getMethod(\"getFrameName\", null).invoke(null, null);org.lwjgl.opengl.Display.setResizable(true);java.lang.reflect.Field f16 = java.lang.ClassLoader.getSystemClassLoader()   .loadClass(\"uk.betacraft.legacyfix.patch.impl.lwjgl.LWJGLFramePatch$Icons\").getDeclaredField(\"pixels16\");f16.setAccessible(true);java.nio.ByteBuffer pix16 = f16.get(null);java.lang.reflect.Field f32 = java.lang.ClassLoader.getSystemClassLoader()   .loadClass(\"uk.betacraft.legacyfix.patch.impl.lwjgl.LWJGLFramePatch$Icons\").getDeclaredField(\"pixels32\");f32.setAccessible(true);java.nio.ByteBuffer pix32 = f32.get(null);org.lwjgl.opengl.Display.setIcon(new java.nio.ByteBuffer[] {pix16, pix32});");
        CtClass displayModeClass = pool.get("org.lwjgl.opengl.DisplayMode");
        CtConstructor displayModeConstructor = displayModeClass.getDeclaredConstructor(new CtClass[]{PatchHelper.intClass, PatchHelper.intClass});
        displayModeConstructor.insertBefore("Class legacyfix = ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.legacyfix.LegacyFixLauncher\");$1 = ((Integer) legacyfix.getMethod(\"getWidth\", null).invoke(null, null)).intValue();$2 = ((Integer) legacyfix.getMethod(\"getHeight\", null).invoke(null, null)).intValue();");
        this.redefineClass(inst, displayModeClass);
        CtClass minecraftMainClass = pool.getOrNull(LegacyFixLauncher.getValue("mainClass", "net.minecraft.client.main.Main"));
        if (minecraftMainClass == null) {
            return;
        }
        CtMethod mainMethod = minecraftMainClass.getDeclaredMethod("main");
        mainMethod.instrument(new ExprEditor(){

            public void edit(NewExpr m) {
                try {
                    CtConstructor minecraftConstructor = m.getConstructor();
                    CtClass[] parameterTypes = minecraftConstructor.getParameterTypes();
                    boolean isMinecraft = false;
                    for (CtClass proxyClass : parameterTypes) {
                        if (!"java.net.Proxy".equals(proxyClass.getName())) continue;
                        isMinecraft = true;
                    }
                    if (!isMinecraft) {
                        return;
                    }
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        CtClass intClass = parameterTypes[i];
                        if (!"int".equals(intClass.getName())) continue;
                        minecraftConstructor.insertBefore("Class legacyfix = ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.legacyfix.LegacyFixLauncher\");$" + (i + 1) + " = ((Integer) legacyfix.getMethod(\"getWidth\", null).invoke(null, null)).intValue();$" + (i + 2) + " = ((Integer) legacyfix.getMethod(\"getHeight\", null).invoke(null, null)).intValue();");
                        CtClass minecraftClass = minecraftConstructor.getDeclaringClass();
                        inst.redefineClasses(new ClassDefinition(Class.forName(minecraftClass.getName()), minecraftClass.toBytecode()));
                        break;
                    }
                }
                catch (Throwable t) {
                    LFLogger.error("lwjgl-frame", t);
                }
            }
        });
    }

    public static class Icons {
        static ByteBuffer pixels16 = null;
        static ByteBuffer pixels32 = null;

        public static void loadIcons(String iconPath) throws IOException {
            if (iconPath != null) {
                File iconFile = new File(iconPath);
                if (iconFile.exists() && iconFile.isFile()) {
                    pixels32 = Icons.getIconForLWJGL(new FileInputStream(iconFile), 32);
                    pixels16 = Icons.getIconForLWJGL(new FileInputStream(iconFile), 16);
                } else {
                    LFLogger.error("No icon found at given path: " + iconPath);
                    pixels16 = Icons.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 16);
                    pixels32 = Icons.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 32);
                }
            } else {
                pixels16 = Icons.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 16);
                pixels32 = Icons.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 32);
            }
        }

        private static ByteBuffer getIconForLWJGL(InputStream stream, int resolution) throws IOException {
            Image read = ImageIO.read(stream).getScaledInstance(resolution, resolution, 4);
            BufferedImage bufImg = new BufferedImage(resolution, resolution, 2);
            Graphics g = bufImg.getGraphics();
            g.drawImage(read, 0, 0, null);
            g.dispose();
            int[] rgb = bufImg.getRGB(0, 0, resolution, resolution, null, 0, resolution);
            ByteBuffer allocate = ByteBuffer.allocate(4 * rgb.length);
            for (int n : rgb) {
                allocate.putInt(n << 8 | n >> 24 & 0xFF);
            }
            allocate.flip();
            return allocate;
        }
    }
}

