/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import sun.net.www.protocol.http.Handler;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.protocol.impl.BetaAntiPiracyHandler;
import uk.betacraft.legacyfix.protocol.impl.HandlerBase;
import uk.betacraft.legacyfix.protocol.impl.IndevAntiPiracyHandler;
import uk.betacraft.legacyfix.protocol.impl.JoinServerHandler;
import uk.betacraft.legacyfix.protocol.impl.LevelHandlerBase;
import uk.betacraft.legacyfix.protocol.impl.LevelListHandler;
import uk.betacraft.legacyfix.protocol.impl.LevelLoadHandler;
import uk.betacraft.legacyfix.protocol.impl.LevelSaveHandler;
import uk.betacraft.legacyfix.protocol.impl.McoHandler;
import uk.betacraft.legacyfix.protocol.impl.Minecraft1_6AvailableHandler;
import uk.betacraft.legacyfix.protocol.impl.ProfileHandler;
import uk.betacraft.legacyfix.protocol.impl.ResourceIndexHandler;
import uk.betacraft.legacyfix.protocol.impl.SkinHandler;
import uk.betacraft.legacyfix.protocol.impl.SkinTextureHandler;
import uk.betacraft.legacyfix.protocol.impl.SnoopHandler;

public class URLHandlers {
    private static final List<Class<? extends HandlerBase>> handlers = Arrays.asList(SkinHandler.class, ResourceIndexHandler.class, JoinServerHandler.class, IndevAntiPiracyHandler.class, LevelListHandler.class, LevelSaveHandler.class, LevelLoadHandler.class, Minecraft1_6AvailableHandler.class, SnoopHandler.class, SkinTextureHandler.class, BetaAntiPiracyHandler.class, McoHandler.class, ProfileHandler.class);

    public static URLConnection matchHandler(URL url) {
        for (Class<? extends HandlerBase> handler : handlers) {
            try {
                Method regexPatternsMethod = handler.getMethod("regexPatterns", new Class[0]);
                List patterns = (List)regexPatternsMethod.invoke(null, new Object[0]);
                for (Pattern pattern : patterns) {
                    if (!url.toString().matches(pattern.pattern())) continue;
                    if (LevelHandlerBase.ONLINE_LEVEL_SERVER != null && handler.getSuperclass().equals(LevelHandlerBase.class)) {
                        String query = url.getQuery() != null ? "?" + url.getQuery() : "";
                        Handler protocolHandler = LevelHandlerBase.ONLINE_LEVEL_SERVER.startsWith("http:") ? new Handler() : new sun.net.www.protocol.https.Handler();
                        String protocol = LevelHandlerBase.ONLINE_LEVEL_SERVER.startsWith("http") ? "" : "https://";
                        return new URL(null, protocol + LevelHandlerBase.ONLINE_LEVEL_SERVER + "/proxy" + url.getPath() + query, protocolHandler).openConnection();
                    }
                    return handler.getConstructor(URL.class, Pattern.class).newInstance(url, pattern);
                }
            }
            catch (Throwable t) {
                LFLogger.error("URLHandlers", t);
            }
        }
        return null;
    }
}

