/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.util;

import java.lang.management.ManagementFactory;
import java.util.Iterator;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmUtils {
    private static final int jvmVersion = JvmUtils.fetchJvmVersion();

    public static String getJvmArguments() {
        String name = System.getProperty("java.vm.name");
        return (JvmUtils.contains(name, "Server") ? "-server " : (JvmUtils.contains(name, "Client") ? "-client " : "")) + JvmUtils.join(" ", ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    static boolean contains(String s, String b) {
        return s != null && s.contains(b);
    }

    static String join(String glue, Iterable<String> strings) {
        if (strings == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<String> i = strings.iterator();
        if (i.hasNext()) {
            buf.append(i.next());
            while (i.hasNext()) {
                buf.append(glue).append(i.next());
            }
        }
        return buf.toString();
    }

    private static int fetchJvmVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2, 3);
        } else {
            int dot = javaVersion.indexOf(".");
            if (dot != -1) {
                javaVersion = javaVersion.substring(0, dot);
            }
        }
        javaVersion = javaVersion.replaceAll("[^0-9](?:.+)?", "");
        try {
            return Integer.parseInt(javaVersion);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getJvmVersion() {
        return jvmVersion;
    }

    public static boolean canThisDoModernTLS() {
        String buildStr;
        int build;
        String[] javaVersion;
        if (JvmUtils.getJvmVersion() == 7 && System.getProperty("java.vendor", "").toLowerCase().contains("azul") && (javaVersion = System.getProperty("java.version", "").split("_")).length == 2 && (build = Integer.parseInt(buildStr = javaVersion[1].replaceAll("[^0-9](?:.+)?", ""))) >= 352) {
            return true;
        }
        if (JvmUtils.getJvmVersion() == 8 && (javaVersion = System.getProperty("java.version", "").split("_")).length == 2 && (build = Integer.parseInt(buildStr = javaVersion[1].replaceAll("[^0-9](?:.+)?", ""))) < 401) {
            return false;
        }
        return JvmUtils.getJvmVersion() >= 8;
    }

    public static void printTLSWarning() {
        String recommendation2;
        String recommendation1;
        String recommendation3 = " https://github.com/betacraftuk/legacyfix/blob/develop/docs/Modern%20TLS%20on%20old%20Java.md";
        String osName = OSUtils.getOSName();
        if (osName.equals("windows xp")) {
            recommendation1 = " Please make your instance use up-to-date Azul Java 7u352.";
            recommendation2 = " Alternatively, please read instructions on how to install a TLS library to your instance to resolve this issue:";
        } else if (OSUtils.isVeryOldWindows()) {
            recommendation1 = "";
            recommendation2 = " Please read instructions on how to install a TLS library to your instance to resolve this issue:";
        } else {
            recommendation1 = " Please make your instance use up-to-date Java 8 (u401 or newer).";
            recommendation2 = " Alternatively, please read instructions on how to install a TLS library to your instance to resolve this issue:";
        }
        LFLogger.error("TLS connectivity", "------------------------ WARNING ------------------------", " You are running outdated Java.", " This might result in LegacyFix not being able to function properly (e.g. no sound, no skins, no auth fix).", recommendation1, recommendation2, recommendation3, "------------------------ WARNING ------------------------");
    }
}

