/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.util;

public class OSUtils {
    public static Platform getPlatform() {
        return new Platform(OSUtils.getOS(), OSUtils.getArch());
    }

    public static OS getOS() {
        String os_name = OSUtils.getOSName();
        if (os_name.contains("windows")) {
            return OS.WINDOWS;
        }
        if (os_name.contains("linux")) {
            return OS.LINUX;
        }
        if (os_name.contains("mac")) {
            return OS.MACOS;
        }
        return OS.OTHER;
    }

    public static Arch getArch() {
        String os_arch = System.getProperty("os.arch").toLowerCase();
        if (os_arch.equals("amd64")) {
            return Arch.X86_64;
        }
        if (os_arch.equals("x86")) {
            return Arch.X86_32;
        }
        if (os_arch.equals("aarch64")) {
            return Arch.AARCH64;
        }
        return Arch.OTHER;
    }

    public static String getOSName() {
        return System.getProperty("os.name", "").toLowerCase();
    }

    public static boolean isVeryOldWindows() {
        String osName = OSUtils.getOSName();
        return osName.equals("windows 95") || osName.equals("windows 98") || osName.equals("windows me") || osName.startsWith("windows 9x") || osName.equals("windows nt") || osName.equals("windows 2000");
    }

    public static class Platform {
        private final OS os;
        private final Arch arch;

        public Platform(OS os, Arch arch) {
            this.os = os;
            this.arch = arch;
        }

        public OS getOS() {
            return this.os;
        }

        public Arch getArch() {
            return this.arch;
        }

        public boolean is(OS os, Arch arch) {
            return this.os == os && this.arch == arch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arch {
        X86_64,
        X86_32,
        AARCH64,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        WINDOWS,
        LINUX,
        MACOS,
        OTHER;

    }
}

