/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class ContentsFilteredItemHandler
implements ITrackedContentsItemHandler {
    private final Supplier<ITrackedContentsItemHandler> itemHandlerGetter;
    private final Supplier<ISlotTracker> slotTrackerGetter;
    private final Supplier<MemorySettingsCategory> memorySettingsGetter;

    public ContentsFilteredItemHandler(Supplier<ITrackedContentsItemHandler> itemHandlerGetter, Supplier<ISlotTracker> slotTrackerGetter, Supplier<MemorySettingsCategory> memorySettingsGetter) {
        this.itemHandlerGetter = itemHandlerGetter;
        this.slotTrackerGetter = slotTrackerGetter;
        this.memorySettingsGetter = memorySettingsGetter;
    }

    public int getSlotCount() {
        return this.itemHandlerGetter.get().getSlotCount();
    }

    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        return this.itemHandlerGetter.get().getStackInSlot(slot);
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.itemHandlerGetter.get().getSlot(slot);
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        if (this.matchesContents(resource.toStack((int)maxAmount))) {
            return this.itemHandlerGetter.get().insertSlot(slot, resource, maxAmount, ctx);
        }
        return 0L;
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.itemHandlerGetter.get().extractSlot(slot, resource, maxAmount, ctx);
    }

    public int getSlotLimit(int slot) {
        return this.itemHandlerGetter.get().getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemVariant resource, int count) {
        return this.matchesContents(resource.toStack(count)) && this.itemHandlerGetter.get().isItemValid(slot, resource, count);
    }

    private boolean matchesContents(class_1799 stack) {
        return this.slotTrackerGetter.get().getItems().contains(stack.method_7909()) || this.memorySettingsGetter.get().matchesFilter(stack);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        if (this.matchesContents(resource.toStack((int)maxAmount))) {
            return this.itemHandlerGetter.get().insert((Object)resource, maxAmount, ctx);
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.itemHandlerGetter.get().extract((Object)resource, maxAmount, ctx);
    }

    public Set<ItemStackKey> getTrackedStacks() {
        return this.itemHandlerGetter.get().getTrackedStacks();
    }

    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.itemHandlerGetter.get().registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
    }

    public void unregisterStackKeyListeners() {
        this.itemHandlerGetter.get().unregisterStackKeyListeners();
    }

    public boolean hasEmptySlots() {
        return this.itemHandlerGetter.get().hasEmptySlots();
    }

    public int getInternalSlotLimit(int slot) {
        return this.itemHandlerGetter.get().getInternalSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull class_1799 stack) {
        this.itemHandlerGetter.get().setStackInSlot(slot, stack);
    }
}

