/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_5561;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ShulkerBoxBlockEntity
extends StorageBlockEntity {
    public static final String STORAGE_TYPE = "shulker_box";
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    public final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 state) {
            ShulkerBoxBlockEntity.this.animationStatus = AnimationStatus.OPENING;
            ShulkerBoxBlockEntity.this.playSound(state, class_3417.field_14825);
            ShulkerBoxBlockEntity.doNeighborUpdates(ShulkerBoxBlockEntity.this.method_10997(), ShulkerBoxBlockEntity.this.field_11867, ShulkerBoxBlockEntity.this.method_11010());
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            ShulkerBoxBlockEntity.this.animationStatus = AnimationStatus.CLOSING;
            ShulkerBoxBlockEntity.this.playSound(state, class_3417.field_14751);
            ShulkerBoxBlockEntity.doNeighborUpdates(ShulkerBoxBlockEntity.this.method_10997(), ShulkerBoxBlockEntity.this.field_11867, ShulkerBoxBlockEntity.this.method_11010());
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int previousOpenCount, int openCount) {
        }

        protected boolean method_31679(class_1657 player) {
            return false;
        }
    };

    public ShulkerBoxBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE);
    }

    public static void tick(@Nullable class_1937 level, class_2338 pos, class_2680 state, ShulkerBoxBlockEntity blockEntity) {
        blockEntity.updateAnimation(level, pos, state);
    }

    private void updateAnimation(@Nullable class_1937 level, class_2338 pos, class_2680 state) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    if (level != null) {
                        ShulkerBoxBlockEntity.doNeighborUpdates(level, pos, state);
                    }
                }
                if (level == null) break;
                this.moveCollidedEntities(level, pos, state);
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                if (level == null) break;
                ShulkerBoxBlockEntity.doNeighborUpdates(level, pos, state);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    @Override
    protected boolean isAllowedInStorage(class_1799 stack) {
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        return !(block instanceof ShulkerBoxBlock) && !(block instanceof class_2480) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.method_7909());
    }

    private static void doNeighborUpdates(class_1937 level, class_2338 pos, class_2680 state) {
        state.method_30101((class_1936)level, pos, 3);
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public class_238 getBoundingBox(class_2680 state) {
        return class_1606.method_33346((class_2350)((class_2350)state.method_11654(ShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 direction;
        class_238 aabb;
        List list;
        if (state.method_26204() instanceof ShulkerBoxBlock && !(list = level.method_8335(null, aabb = class_1606.method_33347((class_2350)(direction = (class_2350)state.method_11654(ShulkerBoxBlock.FACING)), (float)this.progressOld, (float)this.progress).method_996(pos))).isEmpty()) {
            for (class_1297 entity : list) {
                if (entity.method_5657() == class_3619.field_15975) continue;
                entity.method_5784(class_1313.field_6306, new class_243((aabb.method_17939() + 0.01) * (double)direction.method_10148(), (aabb.method_17940() + 0.01) * (double)direction.method_10164(), (aabb.method_17941() + 0.01) * (double)direction.method_10165()));
            }
        }
    }

    @Override
    protected class_5561 getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    public float getProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public void setAnimationStatus(AnimationStatus animationStatus) {
        this.animationStatus = animationStatus;
    }

    @Override
    public boolean shouldDropContents() {
        return false;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

