/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class ChestItemRenderer {
    private static final LoadingCache<class_1747, ChestBlockEntity> chestBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<class_1747, ChestBlockEntity>(){

        public ChestBlockEntity load(class_1747 blockItem) {
            return new ChestBlockEntity(class_2338.field_10980, (class_2680)blockItem.method_7711().method_9564().method_11657((class_2769)ChestBlock.FACING, (Comparable)class_2350.field_11035));
        }
    });
    private static final LoadingCache<DoubleChestBlockEntityKey, ChestBlockEntity> doubleChestBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<DoubleChestBlockEntityKey, ChestBlockEntity>(){

        public ChestBlockEntity load(DoubleChestBlockEntityKey key) {
            return new ChestBlockEntity(class_2338.field_10980, (class_2680)((class_2680)key.blockItem().method_7711().method_9564().method_11657((class_2769)ChestBlock.FACING, (Comparable)class_2350.field_11035)).method_11657(ChestBlock.TYPE, (Comparable)key.chestType()));
        }
    });

    public static void render(class_1799 stack, class_811 displayContext, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (ChestBlockItem.isDoubleChest(stack)) {
            ChestBlockEntity leftChestBlockEntity = (ChestBlockEntity)doubleChestBlockEntities.getUnchecked((Object)new DoubleChestBlockEntityKey(blockItem, class_2745.field_12574));
            poseStack.method_22903();
            poseStack.method_22905(0.8f, 0.8f, 0.8f);
            poseStack.method_22904(0.72, 0.0, 0.0);
            ChestItemRenderer.renderBlockEntity(stack, poseStack, buffer, packedLight, packedOverlay, leftChestBlockEntity);
            ChestBlockEntity rightChestBlockEntity = (ChestBlockEntity)doubleChestBlockEntities.getUnchecked((Object)new DoubleChestBlockEntityKey(blockItem, class_2745.field_12571));
            poseStack.method_22904(-1.0, 0.0, 0.0);
            ChestItemRenderer.renderBlockEntity(stack, poseStack, buffer, packedLight, packedOverlay, rightChestBlockEntity);
            poseStack.method_22909();
            return;
        }
        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)chestBlockEntities.getUnchecked((Object)blockItem);
        ChestItemRenderer.renderBlockEntity(stack, poseStack, buffer, packedLight, packedOverlay, chestBlockEntity);
    }

    private static void renderBlockEntity(class_1799 stack, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, ChestBlockEntity chestBlockEntity) {
        class_827 blockentityrenderer;
        Optional<class_4719> woodType;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
            chestBlockEntity.getStorageWrapper().setColors(tintableBlockItem.getMainColor(stack).orElse(-1), tintableBlockItem.getAccentColor(stack).orElse(-1));
        }
        if ((woodType = WoodStorageBlockItem.getWoodType(stack)).isPresent() || !chestBlockEntity.getStorageWrapper().hasAccentColor() || !chestBlockEntity.getStorageWrapper().hasMainColor()) {
            chestBlockEntity.setWoodType(woodType.orElse(class_4719.field_21679));
        }
        chestBlockEntity.setPacked(WoodStorageBlockItem.isPacked(stack));
        if (StorageBlockItem.showsTier(stack) != chestBlockEntity.shouldShowTier()) {
            chestBlockEntity.toggleTierVisiblity();
        }
        if ((blockentityrenderer = class_310.method_1551().method_31975().method_3550((class_2586)chestBlockEntity)) != null) {
            blockentityrenderer.method_3569((class_2586)chestBlockEntity, 0.0f, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    private record DoubleChestBlockEntityKey(class_1747 blockItem, class_2745 chestType) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleChestBlockEntityKey that = (DoubleChestBlockEntityKey)o;
            return Objects.equal((Object)this.blockItem, (Object)that.blockItem) && this.chestType == that.chestType;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.blockItem, this.chestType});
        }
    }
}

