/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.details.DetailHelpers;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1803;
import net.minecraft.class_1833;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2682;
import net.minecraft.class_5250;
import org.jspecify.annotations.Nullable;

public class ItemDetails {
    public static void fillBasic(Map<? super String, Object> data, class_1799 stack) {
        data.put("name", DetailHelpers.getId(RegistryWrappers.ITEMS, stack.method_7909()));
        data.put("count", stack.method_7947());
        String hash = NBTUtil.getNBTHash(stack.method_7969());
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    public static void fill(Map<? super String, Object> data, class_1799 stack) {
        List<Map<String, Object>> effects;
        int hideFlags;
        List<Map<String, Object>> enchants;
        List<String> lore;
        class_2487 displayTag;
        data.put("displayName", stack.method_7964().getString());
        data.put("maxCount", stack.method_7914());
        if (stack.method_7963()) {
            data.put("damage", stack.method_7919());
            data.put("maxDamage", stack.method_7936());
        }
        if (stack.method_7909().method_31567(stack)) {
            data.put("durability", (double)stack.method_7909().method_31569(stack) / 13.0);
        }
        data.put("tags", DetailHelpers.getTags(stack.method_40133()));
        data.put("itemGroups", List.of());
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("display", 10) && (displayTag = tag.method_10562("display")).method_10573("Lore", 9) && !(lore = displayTag.method_10554("Lore", 8).stream().map(ItemDetails::parseTextComponent).filter(Objects::nonNull).map(class_2561::getString).toList()).isEmpty()) {
            data.put("lore", lore);
        }
        if (!(enchants = ItemDetails.getAllEnchants(stack, hideFlags = tag != null ? tag.method_10550("HideFlags") : 0)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if (!(effects = ItemDetails.getAllEffects(stack)).isEmpty()) {
            data.put("potionEffects", effects);
        }
        if (tag != null && tag.method_10577("Unbreakable") && (hideFlags & 4) == 0) {
            data.put("unbreakable", true);
        }
        DetailHelpers.fillMapColour(data, (class_1922)class_2682.field_12294, class_2338.field_10980, class_2248.method_9503((class_1792)stack.method_7909()).method_9564());
    }

    private static @Nullable class_2561 parseTextComponent(class_2520 x) {
        try {
            return class_2561.class_2562.method_10877((String)x.method_10714());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    private static List<Map<String, Object>> getAllEnchants(class_1799 stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.method_7909() instanceof class_1772 && (hideFlags & 0x20) == 0) {
            ItemDetails.addEnchantments(class_1772.method_7806((class_1799)stack), enchants);
        }
        if (stack.method_7942() && (hideFlags & 1) == 0) {
            ItemDetails.addEnchantments(stack.method_7921(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(class_2499 rawEnchants, ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : class_1890.method_22445((class_2499)rawEnchants).entrySet()) {
            class_1887 enchantment = (class_1887)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DetailHelpers.getId(RegistryWrappers.ENCHANTMENTS, enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.method_8179(level.intValue()).getString());
            enchants.add(enchant);
        }
    }

    private static List<Map<String, Object>> getAllEffects(class_1799 stack) {
        return class_1844.method_8067((class_1799)stack).stream().map(p -> {
            HashMap<String, Object> potion = new HashMap<String, Object>(4);
            potion.put("name", DetailHelpers.getId(RegistryWrappers.MOB_EFFECTS, p.method_5579()));
            class_5250 displayName = class_2561.method_43471((String)p.method_5586());
            if (p.method_5578() > 0) {
                displayName = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{displayName, class_2561.method_43471((String)("potion.potency." + p.method_5578()))});
            }
            potion.put("displayName", displayName.getString());
            if (p.method_5578() > 0) {
                potion.put("potency", p.method_5578() + 1);
            }
            if (p.method_48559()) {
                potion.put("duration", Double.POSITIVE_INFINITY);
            } else if (p.method_5584() > 1) {
                potion.put("duration", (double)p.method_5584() / 20.0 * ItemDetails.getPotionDurationMultiplier(stack));
            }
            return potion;
        }).toList();
    }

    private static double getPotionDurationMultiplier(class_1799 stack) {
        if (stack.method_7909() instanceof class_1803) {
            return 0.25;
        }
        if (stack.method_7909() instanceof class_1833) {
            return 0.125;
        }
        return 1.0;
    }
}

