/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5552;
import net.minecraft.class_6862;
import org.jspecify.annotations.Nullable;

public class TurtleTool
extends AbstractTurtleUpgrade {
    private static final TurtleCommandResult UNBREAKABLE = TurtleCommandResult.failure("Cannot break unbreakable block");
    private static final TurtleCommandResult INEFFECTIVE = TurtleCommandResult.failure("Cannot break block with this tool");
    private static final String TAG_ITEM_TAG = "Tag";
    final class_1799 item;
    final float damageMulitiplier;
    final boolean allowEnchantments;
    final TurtleToolDurability consumeDurability;
    final @Nullable class_6862<class_2248> breakable;

    public TurtleTool(class_2960 id, String adjective, class_1792 craftItem, class_1799 toolItem, float damageMulitiplier, boolean allowEnchantments, TurtleToolDurability consumeDurability, @Nullable class_6862<class_2248> breakable) {
        super(id, TurtleUpgradeType.TOOL, adjective, new class_1799((class_1935)craftItem));
        this.item = toolItem;
        this.damageMulitiplier = damageMulitiplier;
        this.allowEnchantments = allowEnchantments;
        this.consumeDurability = consumeDurability;
        this.breakable = breakable;
    }

    @Override
    public boolean isItemSuitable(class_1799 stack) {
        if (this.consumeDurability == TurtleToolDurability.NEVER && stack.method_7986()) {
            return false;
        }
        return this.allowEnchantments || !TurtleTool.isEnchanted(stack);
    }

    private static boolean isEnchanted(class_1799 stack) {
        return !stack.method_7960() && TurtleTool.isEnchanted(stack.method_7969());
    }

    private static boolean isEnchanted(@Nullable class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return false;
        }
        return tag.method_10573("Enchantments", 9) && !tag.method_10554("Enchantments", 10).isEmpty() || tag.method_10573("AttributeModifiers", 9) && !tag.method_10554("AttributeModifiers", 10).isEmpty();
    }

    @Override
    public class_2487 getUpgradeData(class_1799 stack) {
        class_2487 upgradeData = super.getUpgradeData(stack);
        class_2487 itemTag = stack.method_7969();
        if (itemTag != null) {
            upgradeData.method_10566(TAG_ITEM_TAG, (class_2520)itemTag);
        }
        return upgradeData;
    }

    @Override
    public class_1799 getUpgradeItem(class_2487 upgradeData) {
        class_1799 item = super.getUpgradeItem(upgradeData).method_7972();
        item.method_7980(upgradeData.method_10573(TAG_ITEM_TAG, 10) ? upgradeData.method_10562(TAG_ITEM_TAG) : null);
        return item;
    }

    private class_1799 getToolStack(ITurtleAccess turtle, TurtleSide side) {
        return this.getUpgradeItem(turtle.getUpgradeNBTData(side)).method_7972();
    }

    private void setToolStack(ITurtleAccess turtle, TurtleSide side, class_1799 stack) {
        boolean useDurability;
        class_2487 upgradeData = turtle.getUpgradeNBTData(side);
        switch (this.consumeDurability) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NEVER: {
                boolean bl = false;
                break;
            }
            case WHEN_ENCHANTED: {
                boolean bl;
                if (upgradeData.method_10573(TAG_ITEM_TAG, 10) && TurtleTool.isEnchanted(upgradeData.method_10562(TAG_ITEM_TAG))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ALWAYS: {
                boolean bl = useDurability = true;
            }
        }
        if (!useDurability) {
            return;
        }
        if (stack.method_7960()) {
            turtle.setUpgradeWithData(side, null);
            return;
        }
        if (stack.method_7909() != this.item.method_7909()) {
            return;
        }
        class_2487 itemTag = stack.method_7969();
        if (Objects.equals(itemTag, upgradeData.method_10580(TAG_ITEM_TAG))) {
            return;
        }
        if (itemTag == null) {
            upgradeData.method_10551(TAG_ITEM_TAG);
        } else {
            upgradeData.method_10566(TAG_ITEM_TAG, (class_2520)itemTag);
        }
        turtle.updateUpgradeNBTData(side);
    }

    private <T> T withEquippedItem(ITurtleAccess turtle, TurtleSide side, class_2350 direction, Function<TurtlePlayer, T> action) {
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, turtle.getPosition(), direction);
        turtlePlayer.loadInventory(this.getToolStack(turtle, side));
        T result = action.apply(turtlePlayer);
        this.setToolStack(turtle, side, turtlePlayer.player().method_5998(class_1268.field_5808));
        turtlePlayer.player().method_31548().method_5448();
        return result;
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, class_2350 direction) {
        return switch (verb) {
            default -> throw new IncompatibleClassChangeError();
            case TurtleVerb.ATTACK -> this.attack(turtle, side, direction);
            case TurtleVerb.DIG -> this.dig(turtle, side, direction);
        };
    }

    protected TurtleCommandResult checkBlockBreakable(class_1937 world, class_2338 pos, TurtlePlayer player) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215() || state.method_26204() instanceof class_5552 || state.method_26165((class_1657)player.player(), (class_1922)world, pos) <= 0.0f) {
            return UNBREAKABLE;
        }
        return this.breakable == null || state.method_26164(this.breakable) || TurtleTool.isTriviallyBreakable((class_1922)world, pos, state) ? TurtleCommandResult.success() : INEFFECTIVE;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, TurtleSide side, class_2350 direction) {
        class_1937 world = turtle.getLevel();
        class_2338 position = turtle.getPosition();
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, position, direction);
        class_3222 player = turtlePlayer.player();
        class_243 turtlePos = player.method_19538();
        class_243 rayDir = player.method_5828(1.0f);
        class_239 hit = WorldUtil.clip(world, turtlePos, rayDir, 1.5, null);
        boolean attacked = false;
        if (hit instanceof class_3966) {
            class_3966 entityHit = (class_3966)hit;
            class_1799 stack = this.getToolStack(turtle, side);
            turtlePlayer.loadInventory(stack);
            class_1297 hitEntity = entityHit.method_17782();
            DropConsumer.set(hitEntity, TurtleUtil.dropConsumer(turtle));
            class_1269 result = PlatformHelper.get().canAttackEntity(player, hitEntity);
            if (result.method_23665()) {
                attacked = true;
            } else if (result == class_1269.field_5811 && hitEntity.method_5732() && !hitEntity.method_5698((class_1297)player)) {
                attacked = this.attack(player, direction, hitEntity);
            }
            TurtleUtil.stopConsuming(turtle);
            this.setToolStack(turtle, side, player.method_5998(class_1268.field_5808));
            player.method_31548().method_5448();
        }
        return attacked ? TurtleCommandResult.success() : TurtleCommandResult.failure("Nothing to attack here");
    }

    private boolean attack(class_3222 player, class_2350 direction, class_1297 entity) {
        class_1309 target;
        class_1282 source;
        class_1310 class_13102;
        float baseDamage = (float)player.method_26825(class_5134.field_23721) * this.damageMulitiplier;
        class_1799 class_17992 = player.method_5998(class_1268.field_5808);
        if (entity instanceof class_1309) {
            class_1309 target2 = (class_1309)entity;
            class_13102 = target2.method_6046();
        } else {
            class_13102 = class_1310.field_6290;
        }
        float bonusDamage = class_1890.method_8218((class_1799)class_17992, (class_1310)class_13102);
        float damage = baseDamage + bonusDamage;
        if (damage <= 0.0f) {
            return false;
        }
        int knockBack = class_1890.method_8205((class_1309)player);
        int fireAspect = class_1890.method_8199((class_1309)player);
        boolean onFire = false;
        if (entity instanceof class_1309) {
            class_1309 target3 = (class_1309)entity;
            if (fireAspect > 0 && !target3.method_5809()) {
                onFire = true;
                target3.method_5639(1);
            }
        }
        if (!entity.method_5643(source = player.method_48923().method_48802((class_1657)player), damage)) {
            if (onFire) {
                entity.method_5646();
            }
            return false;
        }
        if (entity.method_5805() && entity instanceof class_1531) {
            entity.method_5643(source, damage);
        }
        if (knockBack > 0) {
            if (entity instanceof class_1309) {
                target = (class_1309)entity;
                target.method_6005((double)knockBack * 0.5, (double)(-direction.method_10148()), (double)(-direction.method_10165()));
            } else {
                entity.method_5762((double)(direction.method_10148() * knockBack) * 0.5, 0.1, (double)(direction.method_10165() * knockBack) * 0.5);
            }
        }
        if (entity instanceof class_1309) {
            target = (class_1309)entity;
            class_1890.method_8210((class_1309)target, (class_1297)player);
        }
        class_1890.method_8213((class_1309)player, (class_1297)entity);
        if (entity instanceof class_1309) {
            target = (class_1309)entity;
            player.method_5998(class_1268.field_5808).method_7979(target, (class_1657)player);
        }
        if (entity instanceof class_1309) {
            target = (class_1309)entity;
            if (fireAspect > 0 && !target.method_5809()) {
                target.method_5639(4 * fireAspect);
            }
        }
        return true;
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, TurtleSide side, class_2350 direction) {
        class_3218 level = (class_3218)turtle.getLevel();
        return this.withEquippedItem(turtle, side, direction, turtlePlayer -> {
            class_1799 stack = turtlePlayer.player().method_5998(class_1268.field_5808);
            if (PlatformHelper.get().hasToolUsage(stack) && TurtleTool.useTool(level, turtle, turtlePlayer, stack, direction)) {
                return TurtleCommandResult.success();
            }
            class_2338 blockPosition = turtle.getPosition().method_10093(direction);
            if (level.method_22347(blockPosition) || WorldUtil.isLiquidBlock((class_1937)level, blockPosition)) {
                return TurtleCommandResult.failure("Nothing to dig here");
            }
            TurtleCommandResult breakable = this.checkBlockBreakable((class_1937)level, blockPosition, (TurtlePlayer)turtlePlayer);
            if (!breakable.isSuccess()) {
                return breakable;
            }
            DropConsumer.set((class_1937)level, blockPosition, TurtleUtil.dropConsumer(turtle));
            boolean broken = !turtlePlayer.isBlockProtected(level, blockPosition) && turtlePlayer.player().field_13974.method_14266(blockPosition);
            TurtleUtil.stopConsuming(turtle);
            return broken ? TurtleCommandResult.success() : TurtleCommandResult.failure("Cannot break protected block");
        });
    }

    private static boolean useTool(class_3218 level, ITurtleAccess turtle, TurtlePlayer turtlePlayer, class_1799 stack, class_2350 direction) {
        class_2338 position = turtle.getPosition().method_10093(direction);
        if (direction == class_2350.field_11033 && level.method_22347(position)) {
            position = position.method_10093(direction);
        }
        if (!level.method_24794(position) || level.method_22347(position) || turtlePlayer.isBlockProtected(level, position)) {
            return false;
        }
        class_3965 hit = TurtlePlaceCommand.getHitResult(position, direction.method_10153());
        PlatformHelper.UseOnResult result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit);
        if (result instanceof PlatformHelper.UseOnResult.Handled) {
            PlatformHelper.UseOnResult.Handled handled = (PlatformHelper.UseOnResult.Handled)result;
            return handled.result().method_23665();
        }
        return ((PlatformHelper.UseOnResult.Continue)result).item() && stack.method_7981(new class_1838((class_1657)turtlePlayer.player(), class_1268.field_5808, hit)).method_23665();
    }

    private static boolean isTriviallyBreakable(class_1922 reader, class_2338 pos, class_2680 state) {
        return state.method_26164(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE) || state.method_26214(reader, pos) == 0.0f;
    }
}

