/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.storage.ClientsideExposureStorage;
import io.github.mortuusars.exposure.data.storage.IClientsideExposureStorage;
import io.github.mortuusars.exposure.data.transfer.ExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.ExposureSender;
import io.github.mortuusars.exposure.data.transfer.IExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.render.ExposureRenderer;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import org.jetbrains.annotations.Nullable;

public class ExposureClient {
    private static final IClientsideExposureStorage exposureStorage = new ClientsideExposureStorage();
    private static final ExposureRenderer exposureRenderer = new ExposureRenderer();
    private static IExposureSender exposureSender;
    private static IExposureReceiver exposureReceiver;
    @Nullable
    private static class_304 openCameraControlsKey;

    public static void init() {
        exposureSender = new ExposureSender((packet, player) -> Packets.sendToServer(packet), 28000);
        exposureReceiver = new ExposureReceiver(exposureStorage);
        ExposureClient.registerItemModelProperties();
    }

    public static IClientsideExposureStorage getExposureStorage() {
        return exposureStorage;
    }

    public static IExposureSender getExposureSender() {
        return exposureSender;
    }

    public static IExposureReceiver getExposureReceiver() {
        return exposureReceiver;
    }

    public static ExposureRenderer getExposureRenderer() {
        return exposureRenderer;
    }

    public static void registerKeymappings(Function<class_304, class_304> registerFunction) {
        class_304 keyMapping = new class_304("key.exposure.camera_controls", class_3675.field_16237.method_1444(), "category.exposure");
        openCameraControlsKey = registerFunction.apply(keyMapping);
    }

    private static void registerItemModelProperties() {
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)new class_2960("camera_state"), CameraItemClientExtensions::itemPropertyFunction);
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)new class_2960("camera_gold"), (stack, level, entity, seed) -> stack.method_7969() != null && stack.method_7969().method_10577("GoldenCamera") ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)Exposure.Items.CHROMATIC_SHEET.get(), (class_2960)new class_2960("channels"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof ChromaticSheetItem) {
                ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)patt0$temp;
                f = (float)chromaticSheet.getExposures(stack).size() / 10.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.STACKED_PHOTOGRAPHS.get(), (class_2960)new class_2960("count"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)patt0$temp;
                f = (float)stackedPhotographsItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.ALBUM.get(), (class_2960)new class_2960("photos"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof AlbumItem) {
                AlbumItem albumItem = (AlbumItem)patt0$temp;
                f = (float)albumItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.INTERPLANAR_PROJECTOR.get(), (class_2960)new class_2960("active"), (stack, clientLevel, livingEntity, seed) -> stack.method_7938() ? 1.0f : 0.0f);
    }

    public static void onScreenAdded(class_437 screen) {
    }

    public static class_304 getCameraControlsKey() {
        Preconditions.checkState((openCameraControlsKey != null ? 1 : 0) != 0, (Object)"Viewfinder Controls key mapping was not registered");
        return openCameraControlsKey.method_1415() ? class_310.method_1551().field_1690.field_1832 : openCameraControlsKey;
    }

    public static boolean isShaderActive() {
        return class_310.method_1551().field_1773.method_3183() != null && class_310.method_1551().field_1773.field_4013;
    }

    static {
        openCameraControlsKey = null;
    }

    public static class Models {
        public static final class_1091 CAMERA_GUI = new class_1091("exposure", "camera_gui", "inventory");
        public static final class_1091 PHOTOGRAPH_FRAME_SMALL = new class_1091("exposure", "photograph_frame_small", "");
        public static final class_1091 PHOTOGRAPH_FRAME_SMALL_STRIPPED = new class_1091("exposure", "photograph_frame_small_stripped", "");
        public static final class_1091 PHOTOGRAPH_FRAME_MEDIUM = new class_1091("exposure", "photograph_frame_medium", "");
        public static final class_1091 PHOTOGRAPH_FRAME_MEDIUM_STRIPPED = new class_1091("exposure", "photograph_frame_medium_stripped", "");
        public static final class_1091 PHOTOGRAPH_FRAME_LARGE = new class_1091("exposure", "photograph_frame_large", "");
        public static final class_1091 PHOTOGRAPH_FRAME_LARGE_STRIPPED = new class_1091("exposure", "photograph_frame_large_stripped", "");
    }
}

