/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.CameraClient;
import io.github.mortuusars.exposure.gui.screen.camera.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.Rect2f;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

public class ViewfinderOverlay {
    public static final class_2960 VIEWFINDER_TEXTURE = Exposure.resource("textures/gui/viewfinder/viewfinder.png");
    public static final class_2960 NO_FILM_ICON_TEXTURE = Exposure.resource("textures/gui/viewfinder/icon/no_film.png");
    public static final class_2960 REMAINING_FRAMES_ICON_TEXTURE = Exposure.resource("textures/gui/viewfinder/icon/remaining_frames.png");
    public static Rect2f opening = new Rect2f(0.0f, 0.0f, 0.0f, 0.0f);
    private static final class_4587 POSE_STACK = new class_4587();
    private static class_310 minecraft = class_310.method_1551();
    private static class_1657 player = ViewfinderOverlay.minecraft.field_1724;
    private static int backgroundColor;
    private static float scale;
    private static Float xRot;
    private static Float yRot;
    private static Float xRot0;
    private static Float yRot0;

    public static void setup() {
        minecraft = class_310.method_1551();
        player = ViewfinderOverlay.minecraft.field_1724;
        backgroundColor = Config.Client.getBackgroundColor();
        scale = 0.5f;
    }

    public static float getScale() {
        return scale;
    }

    public static void render() {
        int width = minecraft.method_22683().method_4486();
        int height = minecraft.method_22683().method_4502();
        scale = class_3532.method_16439((float)Math.min(0.8f * minecraft.method_1534(), 0.8f), (float)scale, (float)1.0f);
        float openingSize = Math.min(width, height);
        opening = new Rect2f(((float)width - openingSize) / 2.0f, ((float)height - openingSize) / 2.0f, openingSize, openingSize);
        if (ViewfinderOverlay.minecraft.field_1690.field_1842) {
            return;
        }
        Optional<Camera<?>> cameraOpt = CameraClient.getCamera();
        if (cameraOpt.isEmpty()) {
            return;
        }
        Camera<?> camera = cameraOpt.get();
        CameraItem cameraItem = (CameraItem)((Object)camera.get().getItem());
        class_1799 cameraStack = camera.get().getStack();
        if (xRot == null || yRot == null || xRot0 == null || yRot0 == null) {
            xRot = Float.valueOf(player.method_36455());
            yRot = Float.valueOf(player.method_36454());
            xRot0 = xRot;
            yRot0 = yRot;
        }
        float delta = Math.min(0.7f * minecraft.method_1534(), 0.8f);
        xRot0 = Float.valueOf(class_3532.method_16439((float)delta, (float)xRot0.floatValue(), (float)xRot.floatValue()));
        yRot0 = Float.valueOf(class_3532.method_16439((float)delta, (float)yRot0.floatValue(), (float)yRot.floatValue()));
        xRot = Float.valueOf(player.method_36455());
        yRot = Float.valueOf(player.method_36454());
        float xDelay = xRot.floatValue() - xRot0.floatValue();
        float yDelay = yRot.floatValue() - yRot0.floatValue();
        xDelay *= (float)width / (float)class_310.method_1551().method_22683().method_4489();
        yDelay *= (float)height / (float)class_310.method_1551().method_22683().method_4506();
        xDelay *= 3.5f;
        yDelay *= 3.5f;
        class_4587 poseStack = POSE_STACK;
        poseStack.method_22903();
        poseStack.method_46416((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        poseStack.method_22905(scale, scale, scale);
        float attackAnim = player.method_6055(minecraft.method_1488());
        if (attackAnim > 0.5f) {
            attackAnim = 1.0f - attackAnim;
        }
        poseStack.method_22905(1.0f - attackAnim * 0.4f, 1.0f - attackAnim * 0.6f, 1.0f - attackAnim * 0.4f);
        poseStack.method_46416((float)width / 16.0f * attackAnim, (float)width / 5.0f * attackAnim, 0.0f);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)attackAnim, (float)0.0f, (float)10.0f)));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_16439((float)attackAnim, (float)0.0f, (float)100.0f)));
        poseStack.method_46416((float)(-width) / 2.0f - yDelay, (float)(-height) / 2.0f - xDelay, 0.0f);
        if (((Boolean)ViewfinderOverlay.minecraft.field_1690.method_42448().method_41753()).booleanValue()) {
            ViewfinderOverlay.bobView(poseStack, minecraft.method_1488());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ViewfinderOverlay.drawRect(poseStack, -9999.0f, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, backgroundColor);
        ViewfinderOverlay.drawRect(poseStack, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y, width + 9999, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, backgroundColor);
        ViewfinderOverlay.drawRect(poseStack, -9999.0f, -9999.0f, width + 9999, ViewfinderOverlay.opening.y, backgroundColor);
        ViewfinderOverlay.drawRect(poseStack, -9999.0f, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, width + 9999, height + 9999, backgroundColor);
        if (cameraItem.isShutterOpen(cameraStack)) {
            ViewfinderOverlay.drawRect(poseStack, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, -98624229);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)VIEWFINDER_TEXTURE);
        GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)Exposure.resource("textures/gui/viewfinder/composition_guide/" + cameraItem.getCompositionGuide(cameraStack).getId() + ".png"));
        GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        if (!(ViewfinderOverlay.minecraft.field_1755 instanceof ViewfinderControlsScreen)) {
            ViewfinderOverlay.renderIcons(poseStack, cameraItem, cameraStack);
        }
        poseStack.method_22909();
    }

    private static void renderIcons(class_4587 poseStack, CameraItem cameraItem, class_1799 cameraStack) {
        Optional<ItemAndStack<FilmRollItem>> film = cameraItem.getFilm(cameraStack);
        if (film.isEmpty() || !film.get().getItem().canAddFrame(film.get().getStack())) {
            RenderSystem.setShaderTexture((int)0, (class_2960)NO_FILM_ICON_TEXTURE);
            GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width / 2.0f - 12.0f, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height - 19.0f, 24.0f, 19.0f, 0, 0, 24, 19, 0.0f);
        } else {
            ItemAndStack<FilmRollItem> f = film.get();
            int maxFrames = f.getItem().getMaxFrameCount(f.getStack());
            int exposedFrames = f.getItem().getExposedFramesCount(f.getStack());
            int remainingFrames = Math.max(0, maxFrames - exposedFrames);
            if (maxFrames > 5 && remainingFrames <= 3) {
                RenderSystem.setShaderTexture((int)0, (class_2960)REMAINING_FRAMES_ICON_TEXTURE);
                GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width / 2.0f - 17.0f, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height - 15.0f, 33.0f, 15.0f, 0, (remainingFrames - 1) * 15, 33, 45, 0.0f);
            }
        }
    }

    public static void drawRect(class_4587 poseStack, float minX, float minY, float maxX, float maxY, int color) {
        float temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrix, minX, maxY, 0.0f).method_22915(r, g, b, alpha).method_1344();
        bufferbuilder.method_22918(matrix, maxX, maxY, 0.0f).method_22915(r, g, b, alpha).method_1344();
        bufferbuilder.method_22918(matrix, maxX, minY, 0.0f).method_22915(r, g, b, alpha).method_1344();
        bufferbuilder.method_22918(matrix, minX, minY, 0.0f).method_22915(r, g, b, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static void bobView(class_4587 poseStack, float partialTicks) {
        class_1297 class_12972 = minecraft.method_1560();
        if (class_12972 instanceof class_1657) {
            class_1657 pl = (class_1657)class_12972;
            float f = pl.field_5973 - pl.field_6039;
            float f1 = -(pl.field_5973 + f * partialTicks);
            float f2 = class_3532.method_16439((float)partialTicks, (float)pl.field_7505, (float)pl.field_7483);
            poseStack.method_22904((double)(class_3532.method_15374((float)(f1 * (float)Math.PI)) * f2 * 16.0f), (double)(-Math.abs(class_3532.method_15362((float)(f1 * (float)Math.PI)) * f2 * 32.0f)), 0.0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
        }
    }

    static {
        scale = 1.0f;
        xRot = null;
        yRot = null;
        xRot0 = null;
        yRot0 = null;
    }
}

