/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.network.packet.client.SyncLensesS2CP;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class Lenses {
    private static ConcurrentMap<class_1856, FocalRange> lenses = new ConcurrentHashMap<class_1856, FocalRange>();

    public static void reload(ConcurrentMap<class_1856, FocalRange> newLenses) {
        lenses.clear();
        lenses = newLenses;
    }

    public static Optional<FocalRange> getFocalRangeOf(class_1799 stack) {
        for (Map.Entry lens : lenses.entrySet()) {
            if (!((class_1856)lens.getKey()).method_8093(stack)) continue;
            return Optional.of((FocalRange)lens.getValue());
        }
        return Optional.empty();
    }

    public static IPacket getSyncToClientPacket() {
        return new SyncLensesS2CP(new ConcurrentHashMap<class_1856, FocalRange>(lenses));
    }

    public static void onDatapackSync(@Nullable class_3222 joiningPlayer) {
        IPacket packet = Lenses.getSyncToClientPacket();
        if (joiningPlayer != null) {
            Packets.sendToClient(packet, joiningPlayer);
        } else {
            Packets.sendToAllClients(packet);
        }
    }
}

