/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public record CameraAddFrameC2SP(class_1268 hand, class_2487 frame, List<UUID> entitiesInFrameIds) implements IPacket
{
    public static final class_2960 ID = Exposure.resource("camera_add_frame");

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_2540 toBuffer(class_2540 buffer) {
        buffer.method_10817((Enum)this.hand);
        buffer.method_10794(this.frame);
        buffer.writeInt(this.entitiesInFrameIds.size());
        for (UUID uuid : this.entitiesInFrameIds) {
            buffer.method_10797(uuid);
        }
        return buffer;
    }

    public static CameraAddFrameC2SP fromBuffer(class_2540 buffer) {
        class_1268 hand = (class_1268)buffer.method_10818(class_1268.class);
        @Nullable class_2487 frame = buffer.method_30617();
        if (frame == null) {
            frame = new class_2487();
        }
        int entitiesCount = buffer.readInt();
        ArrayList<UUID> entities = new ArrayList<UUID>();
        for (int i = 0; i < entitiesCount; ++i) {
            entities.add(buffer.method_10790());
        }
        return new CameraAddFrameC2SP(hand, frame, entities);
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable class_1657 player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        class_3222 serverPlayer = (class_3222)player;
        Camera.getCamera(player).ifPresentOrElse(camera -> {
            CameraItem cameraItem = (CameraItem)((Object)((Object)camera.get().getItem()));
            cameraItem.addFrame(serverPlayer, camera.get().getStack(), this.frame, this.getEntities(serverPlayer.method_51469()));
        }, () -> Exposure.LOGGER.error("Cannot add frame. Player is not using a Camera."));
        class_1799 cameraStack = player.method_5998(this.hand);
        class_1792 class_17922 = cameraStack.method_7909();
        if (!(class_17922 instanceof CameraItem)) {
            throw new IllegalStateException("Item in hand in not a Camera.");
        }
        CameraItem cameraItem = (CameraItem)class_17922;
        if (this.frame.method_10577("Projected")) {
            cameraItem.getAttachment(cameraStack, CameraItem.FILTER_ATTACHMENT).ifPresent(filter -> {
                class_1792 patt0$temp = filter.method_7909();
                if (patt0$temp instanceof InterplanarProjectorItem) {
                    InterplanarProjectorItem interplanarProjector = (InterplanarProjectorItem)patt0$temp;
                    player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.INTERPLANAR_PROJECT.get(), class_3419.field_15248, 0.8f, 1.0f);
                    if (interplanarProjector.isConsumable((class_1799)filter)) {
                        filter.method_7934(1);
                        cameraItem.setAttachment(cameraStack, CameraItem.FILTER_ATTACHMENT, (class_1799)filter);
                    }
                }
            });
        }
        return true;
    }

    private List<class_1297> getEntities(class_3218 level) {
        ArrayList<class_1297> entitiesInFrame = new ArrayList<class_1297>();
        for (UUID uuid : this.entitiesInFrameIds) {
            @Nullable class_1297 entity = level.method_14190(uuid);
            if (entity == null) continue;
            entitiesInFrame.add(entity);
        }
        return entitiesInFrame;
    }
}

