/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.recipe;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNbtTransferringRecipe
extends class_1852 {
    private final class_1799 result;
    private final class_1856 transferIngredient;
    private final class_2371<class_1856> ingredients;

    public AbstractNbtTransferringRecipe(class_2960 id, class_1856 transferIngredient, class_2371<class_1856> ingredients, class_1799 result) {
        super(id, class_7710.field_40251);
        this.transferIngredient = transferIngredient;
        this.ingredients = ingredients;
        this.result = result;
    }

    @NotNull
    public class_1856 getTransferIngredient() {
        return this.transferIngredient;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.getResult();
    }

    @NotNull
    public class_1799 getResult() {
        return this.result;
    }

    public boolean matches(class_8566 container, class_1937 level) {
        if (this.getTransferIngredient().method_8103() || this.ingredients.isEmpty()) {
            return false;
        }
        ArrayList<class_1856> unmatchedIngredients = new ArrayList<class_1856>((Collection<class_1856>)this.ingredients);
        unmatchedIngredients.add(0, this.getTransferIngredient());
        int itemsInCraftingGrid = 0;
        block0: for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (!stack.method_7960()) {
                ++itemsInCraftingGrid;
            }
            if (itemsInCraftingGrid > this.ingredients.size() + 1) {
                return false;
            }
            if (unmatchedIngredients.isEmpty()) continue;
            for (int j = 0; j < unmatchedIngredients.size(); ++j) {
                if (!((class_1856)unmatchedIngredients.get(j)).method_8093(stack)) continue;
                unmatchedIngredients.remove(j);
                continue block0;
            }
        }
        return unmatchedIngredients.isEmpty() && itemsInCraftingGrid == this.ingredients.size() + 1;
    }

    @NotNull
    public class_1799 assemble(class_8566 container, @NotNull class_5455 registryAccess) {
        for (int index = 0; index < container.method_5439(); ++index) {
            class_1799 itemStack = container.method_5438(index);
            if (!this.getTransferIngredient().method_8093(itemStack)) continue;
            return this.transferNbt(itemStack, this.method_8110(registryAccess).method_7972());
        }
        return this.method_8110(registryAccess);
    }

    @NotNull
    public class_1799 transferNbt(class_1799 transferIngredientStack, class_1799 recipeResultStack) {
        @Nullable class_2487 transferTag = transferIngredientStack.method_7969();
        if (transferTag != null) {
            if (recipeResultStack.method_7969() != null) {
                recipeResultStack.method_7969().method_10543(transferTag);
            } else {
                recipeResultStack.method_7980(transferTag.method_10553());
            }
        }
        return recipeResultStack;
    }

    public boolean method_8113(int width, int height) {
        return this.ingredients.size() <= width * height;
    }
}

