/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class CombinedInvWrapper<S extends SlottedStackStorage>
extends CombinedSlottedStorage<ItemVariant, S>
implements SlottedStackStorage {
    protected final int[] baseIndex;
    protected final int slotCount;

    public CombinedInvWrapper(List<S> inventories) {
        super(inventories);
        this.baseIndex = new int[inventories.size()];
        int index = 0;
        for (int i = 0; i < inventories.size(); ++i) {
            this.baseIndex[i] = index += ((SlottedStackStorage)inventories.get(i)).getSlotCount();
        }
        this.slotCount = index;
    }

    @SafeVarargs
    public CombinedInvWrapper(S ... inventories) {
        this(List.of(inventories));
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    protected Optional<SlottedStackStorage> getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.parts.size()) {
            return Optional.empty();
        }
        return Optional.of((SlottedStackStorage)this.parts.get(index));
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        int index = this.getIndexForSlot(slot);
        Optional<SlottedStackStorage> handler = this.getHandlerFromIndex(index);
        if (handler.isEmpty()) {
            return;
        }
        slot = this.getSlotFromIndex(slot, index);
        handler.get().setStackInSlot(slot, stack);
    }

    public class_1799 getStackInSlot(int slot) {
        int index = this.getIndexForSlot(slot);
        Optional<SlottedStackStorage> handler = this.getHandlerFromIndex(index);
        if (handler.isEmpty()) {
            return class_1799.field_8037;
        }
        slot = this.getSlotFromIndex(slot, index);
        return handler.get().getStackInSlot(slot);
    }

    public int getSlotLimit(int slot) {
        int index = this.getIndexForSlot(slot);
        Optional<SlottedStackStorage> handler = this.getHandlerFromIndex(index);
        if (handler.isEmpty()) {
            return 0;
        }
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.get().getSlotLimit(localSlot);
    }

    public boolean isItemValid(int slot, ItemVariant resource, int count) {
        int index = this.getIndexForSlot(slot);
        Optional<SlottedStackStorage> handler = this.getHandlerFromIndex(index);
        if (handler.isEmpty()) {
            return false;
        }
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.get().isItemValid(localSlot, resource, count);
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        int index = this.getIndexForSlot(slot);
        Optional<SlottedStackStorage> handler = this.getHandlerFromIndex(index);
        if (handler.isEmpty()) {
            return 0L;
        }
        slot = this.getSlotFromIndex(slot, index);
        return handler.get().insertSlot(slot, resource, maxAmount, ctx);
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        int index = this.getIndexForSlot(slot);
        Optional<SlottedStackStorage> handler = this.getHandlerFromIndex(index);
        if (handler.isEmpty()) {
            return 0L;
        }
        slot = this.getSlotFromIndex(slot, index);
        return handler.get().extractSlot(slot, resource, maxAmount, ctx);
    }
}

