/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Minecraft MC = Minecraft.m_91087_();
    public ConcurrentHashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new ConcurrentHashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean colorTextureCastFailLogged = false;
    public boolean depthTextureCastFailLogged = false;

    @Override
    public Vec3f getLookAtVector() {
        Camera camera = MinecraftRenderWrapper.MC.f_91063_.m_109153_();
        return new Vec3f(camera.m_253058_().x(), camera.m_253058_().y(), camera.m_253058_().z());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        if (MinecraftRenderWrapper.MC.f_91074_ == null) {
            return false;
        }
        if (MinecraftRenderWrapper.MC.f_91074_.m_21221_() == null) {
            return false;
        }
        return MinecraftRenderWrapper.MC.f_91074_.m_21221_().get(MobEffects.f_19610_) != null || MinecraftRenderWrapper.MC.f_91074_.m_21221_().get(MobEffects.f_216964_) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        Camera camera = MinecraftRenderWrapper.MC.f_91063_.m_109153_();
        Vec3 projectedView = camera.m_90583_();
        return new Vec3d(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_);
    }

    @Override
    public Color getFogColor(float partialTicks) {
        FogRenderer.m_109018_((Camera)MinecraftRenderWrapper.MC.f_91063_.m_109153_(), (float)partialTicks, (ClientLevel)MinecraftRenderWrapper.MC.f_91073_, (int)1, (float)MinecraftRenderWrapper.MC.f_91063_.m_109131_(partialTicks));
        float[] colorValues = RenderSystem.getShaderFogColor();
        return new Color(Math.max(0.0f, Math.min(colorValues[0], 1.0f)), Math.max(0.0f, Math.min(colorValues[1], 1.0f)), Math.max(0.0f, Math.min(colorValues[2], 1.0f)), Math.max(0.0f, Math.min(colorValues[3], 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.f_91073_.m_6042_().f_223549_()) {
            float frameTime = MC.m_91296_();
            Vec3 colorValues = MinecraftRenderWrapper.MC.f_91073_.m_171660_(MinecraftRenderWrapper.MC.f_91063_.m_109153_().m_90583_(), frameTime);
            return new Color((float)colorValues.f_82479_, (float)colorValues.f_82480_, (float)colorValues.f_82481_);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.f_91063_.m_109141_(MinecraftRenderWrapper.MC.f_91063_.m_109153_(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.f_91066_.m_193772_();
    }

    protected RenderTarget getRenderTarget() {
        return MC.m_91385_();
    }

    @Override
    public boolean mcRendersToFrameBuffer() {
        return true;
    }

    @Override
    public boolean runningLegacyOpenGL() {
        return false;
    }

    @Override
    public int getTargetFramebuffer() {
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return this.getRenderTarget().f_83920_;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        return this.getRenderTarget().m_83980_();
    }

    @Override
    public int getColorTextureId() {
        return this.getRenderTarget().m_83975_();
    }

    @Override
    public int getTargetFramebufferViewportWidth() {
        return this.getRenderTarget().f_83917_;
    }

    @Override
    public int getTargetFramebufferViewportHeight() {
        return this.getRenderTarget().f_83918_;
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(@NotNull ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.f_91063_.m_109153_().m_167685_() != FogType.NONE || isBlind;
    }

    public void updateLightmap(NativeImage lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.uploadLightmap(lightPixels);
    }

    public void setLightmapId(int tetxureId, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.setLightmapId(tetxureId);
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.Quality.lodShading.get();
        switch (lodShading) {
            default: {
                if (MinecraftRenderWrapper.MC.f_91073_ != null) {
                    Direction mcDir = McObjectConverter.Convert(lodDirection);
                    return MinecraftRenderWrapper.MC.f_91073_.m_7717_(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }
}

