/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.LodUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DummyLightEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DhLitWorldGenRegion
extends WorldGenRegion {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static ChunkStatus debugTriggeredForStatus = null;
    public final ServerLevel serverLevel;
    public final DummyLightEngine lightEngine;
    public final BatchGenerationEnvironment.IEmptyChunkRetrievalFunc generator;
    public final int writeRadius;
    public final int size;
    private final ChunkPos firstPos;
    private final List<ChunkAccess> cache;
    private final Long2ObjectOpenHashMap<ChunkAccess> chunkMap = new Long2ObjectOpenHashMap();
    private final ReentrantLock getChunkLock = new ReentrantLock();

    public DhLitWorldGenRegion(int centerChunkX, int centerChunkZ, ChunkAccess centerChunk, ServerLevel serverLevel, DummyLightEngine lightEngine, List<ChunkAccess> chunkList, ChunkStatus chunkStatus, int writeRadius, BatchGenerationEnvironment.IEmptyChunkRetrievalFunc generator) {
        super(serverLevel, chunkList, chunkStatus, writeRadius);
        this.firstPos = chunkList.get(0).m_7697_();
        this.serverLevel = serverLevel;
        this.generator = generator;
        this.lightEngine = lightEngine;
        this.writeRadius = writeRadius;
        this.cache = chunkList;
        this.size = Mth.m_14107_((double)Math.sqrt(chunkList.size()));
    }

    public boolean m_180807_(BlockPos blockPos) {
        int i = SectionPos.m_123171_((int)blockPos.m_123341_());
        int j = SectionPos.m_123171_((int)blockPos.m_123343_());
        ChunkPos chunkPos = this.m_143488_();
        ChunkAccess center = this.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int k = Math.abs(chunkPos.f_45578_ - i);
        int l = Math.abs(chunkPos.f_45579_ - j);
        if (k > this.writeRadius || l > this.writeRadius) {
            return false;
        }
        if (center.m_187679_()) {
            LevelHeightAccessor levelHeightAccessor = center.m_183618_();
            int minY = levelHeightAccessor.m_141937_();
            int maxY = levelHeightAccessor.m_151558_();
            if (blockPos.m_123342_() < minY || blockPos.m_123342_() >= maxY) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    @NotNull
    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public boolean m_6933_(BlockPos blockPos, BlockState blockState, int i, int j) {
        ChunkAccess chunkAccess = this.m_46865_(blockPos);
        if (chunkAccess instanceof LevelChunk) {
            return true;
        }
        chunkAccess.m_6978_(blockPos, blockState, false);
        return true;
    }

    public boolean m_7740_(BlockPos blockPos, boolean bl, @Nullable Entity entity, int i) {
        BlockState blockState = this.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        return this.m_6933_(blockPos, Blocks.f_50016_.m_49966_(), 3, i);
    }

    public BlockEntity m_7702_(BlockPos blockPos) {
        BlockState blockState = this.m_8055_(blockPos);
        if (blockState.m_60734_() instanceof SpawnerBlock) {
            return ((EntityBlock)blockState.m_60734_()).m_142194_(blockPos, blockState);
        }
        return null;
    }

    @NotNull
    public BlockState m_8055_(BlockPos blockPos) {
        int chunkX = SectionPos.m_123171_((int)blockPos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)blockPos.m_123343_());
        return this.m_6325_(chunkX, chunkZ).m_8055_(blockPos);
    }

    public boolean m_7967_(@NotNull Entity entity) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ChunkAccess m_6325_(int chunkX, int chunkZ) {
        try {
            this.getChunkLock.lock();
            ChunkAccess chunkAccess = this.m_46819_(chunkX, chunkZ, ChunkStatus.f_62314_);
            return chunkAccess;
        }
        finally {
            this.getChunkLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ChunkAccess m_46819_(int chunkX, int chunkZ, @NotNull ChunkStatus chunkStatus) {
        try {
            this.getChunkLock.lock();
            ChunkAccess chunk = this.m_6522_(chunkX, chunkZ, chunkStatus, true);
            if (chunk == null) {
                LodUtil.assertNotReach("getChunk shouldn't return null values");
            }
            ChunkAccess chunkAccess = chunk;
            return chunkAccess;
        }
        finally {
            this.getChunkLock.unlock();
        }
    }

    @Nullable
    public ChunkAccess m_6522_(int chunkX, int chunkZ, @NotNull ChunkStatus chunkStatus, boolean returnNonNull) {
        ChunkAccess chunk = this.getChunkAccess(chunkX, chunkZ, chunkStatus, returnNonNull);
        if (chunk instanceof LevelChunk) {
            chunk = new ImposterProtoChunk((LevelChunk)chunk, false);
        }
        return chunk;
    }

    private ChunkAccess getChunkAccess(int chunkX, int chunkZ, ChunkStatus chunkStatus, boolean returnNonNull) {
        ChunkAccess chunk;
        ChunkAccess chunkAccess = chunk = this.superHasChunk(chunkX, chunkZ) ? this.superGetChunk(chunkX, chunkZ) : null;
        if (chunk != null && ChunkWrapper.getStatus(chunk).m_62427_(chunkStatus)) {
            return chunk;
        }
        if (!returnNonNull) {
            return null;
        }
        if (chunk == null && (chunk = (ChunkAccess)this.chunkMap.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ))) == null) {
            chunk = this.generator.getChunk(chunkX, chunkZ);
            if (chunk == null) {
                throw new NullPointerException("The provided generator should not return null!");
            }
            this.chunkMap.put(ChunkPos.m_45589_((int)chunkX, (int)chunkZ), (Object)chunk);
        }
        if (chunkStatus != ChunkStatus.f_62314_ && chunkStatus != debugTriggeredForStatus) {
            LOGGER.info("WorldGen requiring [" + String.valueOf(chunkStatus) + "] is outside the expected range. Returning EMPTY chunk.", new Object[0]);
            debugTriggeredForStatus = chunkStatus;
        }
        return chunk;
    }

    public boolean superHasChunk(int x, int z) {
        int k = x - this.firstPos.f_45578_;
        int l = z - this.firstPos.f_45579_;
        return l >= 0 && l < this.size && k >= 0 && k < this.size;
    }

    private ChunkAccess superGetChunk(int x, int z) {
        int k = x - this.firstPos.f_45578_;
        int l = z - this.firstPos.f_45579_;
        return this.cache.get(k + l * this.size);
    }

    @NotNull
    public LevelLightEngine m_5518_() {
        return this.lightEngine;
    }

    public int m_45517_(@NotNull LightLayer lightLayer, @NotNull BlockPos blockPos) {
        return 0;
    }

    public int m_45524_(@NotNull BlockPos blockPos, int i) {
        return 0;
    }

    public boolean m_45527_(@NotNull BlockPos blockPos) {
        return this.m_45517_(LightLayer.SKY, blockPos) >= 15;
    }

    public int m_6171_(@NotNull BlockPos blockPos, @NotNull ColorResolver colorResolver) {
        return this.calculateBlockTint(blockPos, colorResolver);
    }

    private Biome _getBiome(BlockPos pos) {
        return (Biome)this.m_204166_(pos).m_203334_();
    }

    public int calculateBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        if (i == 0) {
            return colorResolver.m_130045_(this._getBiome(blockPos), (double)blockPos.m_123341_(), (double)blockPos.m_123343_());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        Cursor3D cursor3D = new Cursor3D(blockPos.m_123341_() - i, blockPos.m_123342_(), blockPos.m_123343_() - i, blockPos.m_123341_() + i, blockPos.m_123342_(), blockPos.m_123343_() + i);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.m_122304_()) {
            mutableBlockPos.m_122178_(cursor3D.m_122305_(), cursor3D.m_122306_(), cursor3D.m_122307_());
            int n = colorResolver.m_130045_(this._getBiome((BlockPos)mutableBlockPos), (double)mutableBlockPos.m_123341_(), (double)mutableBlockPos.m_123343_());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }
}

