/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class BambooHopperEntity
extends AirplaneEntity {
    public BambooHopperEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world, true);
    }

    @Override
    public class_1792 asItem() {
        return Items.BAMBOO_HOPPER.get();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.emitSmokeParticle(3.4375f, 1.125f, -0.25f, 0.0f, 0.0f, -0.2f);
        this.emitSmokeParticle(-3.4375f, 1.125f, -0.25f, 0.0f, 0.0f, -0.2f);
        float water = (float)this.field_5964.getDouble((Object)class_3486.field_15517);
        if (water > 0.0f) {
            this.emitSplashParticle(3.4375f, water, -0.5f, 0.0f, 0.0f, 0.0f);
            this.emitSplashParticle(-3.4375f, water, -0.5f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void emitSplashParticle(float x, float y, float z, float nx, float ny, float nz) {
        if (!this.isWithinParticleRange() || !this.method_37908().field_9236) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        double length = Math.min(100.0, this.getSpeedVector().method_1033() * 20.0);
        while (length > 1.0) {
            if (!((length -= 1.0) > (double)this.field_5974.method_43057())) continue;
            Vector4f p = this.transformPosition(transform, x + (this.field_5974.method_43057() - 0.5f), y, z - (this.field_5974.method_43057() - 0.0f));
            this.method_37908().method_8406((class_2394)class_2398.field_11247, (double)p.x, (double)p.y, (double)p.z, (double)nx, (double)ny, (double)nz);
            this.method_37908().method_8406((class_2394)class_2398.field_11202, (double)p.x, (double)p.y, (double)p.z, (double)nx, (double)ny, (double)nz);
        }
    }

    @Override
    protected float getGravity() {
        float water = (float)this.method_5861(class_3486.field_15517);
        return water > 0.0f ? 0.04f * water : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return (float)((double)this.enginePower.getSmooth() * this.getSpeedVector().method_1033());
    }

    @Override
    protected void updateVelocity() {
        super.updateVelocity();
        if (this.field_5957) {
            this.method_36457((this.method_36455() + this.getProperties().get(VehicleStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(VehicleStat.GROUND_PITCH));
        }
    }

    @Override
    public boolean worksUnderWater() {
        return true;
    }

    @Override
    protected float getDismountRotation() {
        return 0.0f;
    }

    @Override
    public double getZoom() {
        return 6.0;
    }

    @Override
    protected class_3414 getEngineStartSound() {
        return Sounds.ENGINE_START_BAMBOO_HOPPER.get();
    }

    @Override
    protected class_3414 getEngineSound() {
        return Sounds.PROPELLER_BAMBOO_HOPPER.get();
    }
}

