/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.network.c2s.EnginePowerMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import immersive_aircraft.util.Utils;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class EngineVehicle
extends InventoryVehicleEntity {
    protected static final class_2940<Float> ENGINE = class_2945.method_12791(EngineVehicle.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> UTILIZATION = class_2945.method_12791(EngineVehicle.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> LOW_ON_FUEL = class_2945.method_12791(EngineVehicle.class, (class_2941)class_2943.field_13323);
    public final InterpolatedFloat engineRotation = new InterpolatedFloat();
    public final InterpolatedFloat enginePower = new InterpolatedFloat(20.0f);
    public float engineSpinUpStrength = 0.0f;
    public float engineSound = 0.0f;
    public int mainWarning = 0;
    public int mslWarning = 0;
    public final EnumMap<Cautions, Integer> cautions = new EnumMap(Cautions.class);
    FuelState lastFuelState = FuelState.NEVER;
    public static final int TARGET_FUEL = 1000;
    public static final int LOW_FUEL = 900;
    private final int[] fuel = new int[this.getInventoryDescription().getSlots(VehicleInventoryDescription.BOILER).size()];

    public GUI_STYLE getGuiStyle() {
        return GUI_STYLE.ENGINE;
    }

    public EngineVehicle(class_1299<? extends EngineVehicle> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super((class_1299<? extends InventoryVehicleEntity>)entityType, world, canExplodeOnCrash);
        for (Cautions c : Cautions.values()) {
            this.cautions.compute(c, (cautions, v) -> 0);
        }
    }

    protected class_3414 getEngineStartSound() {
        return Sounds.ENGINE_START.get();
    }

    protected class_3414 getEngineSound() {
        return Sounds.PROPELLER.get();
    }

    protected float getEngineVolume() {
        return 0.25f;
    }

    protected float getEnginePitch() {
        return 1.0f;
    }

    protected float getEngineReactionSpeed() {
        return 20.0f;
    }

    public boolean worksUnderWater() {
        return false;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ENGINE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(UTILIZATION, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LOW_ON_FUEL, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.enginePower.setSteps(this.getEngineReactionSpeed() / this.getProperties().get(VehicleStat.ACCELERATION));
        this.enginePower.update(this.getEngineTarget() * (this.method_5799() && !this.worksUnderWater() ? 0.1f : 1.0f));
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.01f);
        if (this.method_37908().method_8608()) {
            this.engineRotation.update((this.engineRotation.getValue() + this.getPropellerSpeed()) % 1000.0f);
        }
        if (!this.method_5782() && this.getEngineTarget() > 0.0f) {
            this.setEngineTarget(0.0f);
        }
        if (this.method_37908().field_9236) {
            this.engineSound += this.getEnginePower() * 0.25f;
            if (this.engineSound > 1.0f) {
                this.engineSound -= 1.0f;
                if (this.isFuelLow()) {
                    this.engineSound -= (float)this.field_5974.method_43048(2);
                }
                this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.5, this.method_23321(), this.getEngineSound(), this.method_5634(), Math.min(1.0f, this.getEngineVolume() + this.engineSpinUpStrength), (this.field_5974.method_43057() * 0.1f + 0.95f) * this.getEnginePitch(), false);
            }
        }
        if (this.fuel.length > 0 && !this.method_37908().field_9236) {
            float consumption = this.getFuelConsumption();
            this.consumeFuel(consumption);
        }
        if (this.method_5782()) {
            if (!this.method_37908().method_8608()) {
                this.refuel();
                class_1309 class_13092 = this.method_5642();
                if (class_13092 instanceof class_3222) {
                    class_3222 player = (class_3222)class_13092;
                    float utilization = this.getFuelUtilization();
                    if (utilization > 0.0f && this.isFuelLow()) {
                        if (this.lastFuelState != FuelState.LOW) {
                            player.method_7353((class_2561)class_2561.method_43471((String)("immersive_aircraft." + this.getFuelType() + ".low")), true);
                            this.lastFuelState = FuelState.LOW;
                        }
                    } else if (utilization > 0.0f) {
                        this.lastFuelState = FuelState.FUELED;
                    } else if (this.lastFuelState != FuelState.EMPTY) {
                        player.method_7353((class_2561)class_2561.method_43471((String)("immersive_aircraft." + this.getFuelType() + "." + (this.lastFuelState == FuelState.FUELED ? "out" : "none"))), true);
                        this.lastFuelState = FuelState.EMPTY;
                    }
                }
            }
        } else {
            this.lastFuelState = FuelState.NEVER;
        }
        this.mainWarning = Math.max(0, this.mainWarning - 1);
        this.mslWarning = Math.max(0, this.mslWarning - 1);
        for (Cautions caution : Cautions.values()) {
            this.cautions.compute(caution, (cautions, integer) -> {
                int n;
                if (integer == null) {
                    n = 0;
                } else {
                    integer = integer - 1;
                    n = Math.max(0, integer);
                }
                return n;
            });
        }
        this.handleWarnings();
    }

    private void handleWarnings() {
        double altRate = this.getSpeedVector().field_1351 * 10.0;
        if ((double)this.getEnginePower() >= 0.5 && altRate < -2.0 && this.method_23318() + altRate * 3.0 < (double)this.method_37908().method_8615()) {
            this.cautions.put(Cautions.PULL_UP, 40);
        }
        if (this.method_23318() < (double)this.method_37908().method_8597().comp_651()) {
            this.cautions.put(Cautions.VOID, 10);
            this.mainWarning = 6;
        }
        if (this.getHealth() * 100.0f < 20.0f) {
            this.cautions.put(Cautions.DAMAGED, 10);
            this.mainWarning = 6;
        }
    }

    public float consumeFuel(float consumption) {
        while (consumption > 0.0f && (consumption >= 1.0f || this.field_5974.method_43057() < consumption)) {
            for (int i = 0; i < this.fuel.length; ++i) {
                if (this.fuel[i] <= 0) continue;
                int n = i;
                this.fuel[n] = this.fuel[n] - 1;
            }
            consumption -= 1.0f;
        }
        return consumption;
    }

    public float getPropellerSpeed() {
        return this.getEnginePower();
    }

    public boolean isFuelLow() {
        if (!Config.getInstance().burnFuelInCreative && this.isPilotCreative()) {
            return false;
        }
        if (this.method_37908().field_9236) {
            return (Boolean)this.field_6011.method_12789(LOW_ON_FUEL);
        }
        boolean low = true;
        for (int i : this.fuel) {
            if (i <= 900) continue;
            low = false;
            break;
        }
        this.field_6011.method_12778(LOW_ON_FUEL, (Object)low);
        return low;
    }

    public String getFuelType() {
        return "fuel";
    }

    public float getFuelConsumption() {
        return this.getEngineTarget() * this.getProperties().get(VehicleStat.FUEL) * Config.getInstance().fuelConsumption;
    }

    private void refuel(int i) {
        class_1799 stack;
        int time;
        List<SlotDescription> slots = this.getInventoryDescription().getSlots(VehicleInventoryDescription.BOILER);
        while (this.fuel[i] <= 1000 && i < slots.size() && (time = Utils.getFuelTime(stack = this.getInventory().method_5438(slots.get(i).index()))) > 0) {
            int n = i;
            this.fuel[n] = this.fuel[n] + time;
            class_1792 item = stack.method_7909();
            stack.method_7934(1);
            if (!stack.method_7960()) continue;
            class_1792 remainingItem = item.method_7858();
            this.getInventory().method_5447(slots.get(i).index(), remainingItem == null ? class_1799.field_8037 : new class_1799((class_1935)remainingItem));
        }
    }

    private void refuel() {
        for (int i = 0; i < this.fuel.length; ++i) {
            this.refuel(i);
        }
    }

    public float getEnginePower() {
        return (float)((double)this.enginePower.getSmooth() * Math.sqrt(this.getFuelUtilization()));
    }

    public float getEngineTarget() {
        return ((Float)this.field_6011.method_12789(ENGINE)).floatValue();
    }

    public void setEngineTarget(float engineTarget) {
        if (this.getFuelUtilization() > 0.0f || engineTarget == 0.0f) {
            if (this.method_37908().field_9236) {
                if (this.getEngineTarget() != engineTarget) {
                    NetworkHandler.sendToServer(new EnginePowerMessage(engineTarget));
                }
                if (this.getFuelUtilization() > 0.0f && (double)this.getEngineTarget() == 0.0 && engineTarget > 0.0f) {
                    this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.5, this.method_23321(), this.getEngineStartSound(), this.method_5634(), 1.5f, this.getEnginePitch(), false);
                }
            }
            this.field_6011.method_12778(ENGINE, (Object)Float.valueOf(engineTarget));
        }
    }

    public float getFuelUtilization() {
        if (Config.getInstance().fuelConsumption == 0.0f) {
            return 1.0f;
        }
        if (!Config.getInstance().burnFuelInCreative && this.isPilotCreative()) {
            return 1.0f;
        }
        if (this.fuel.length == 0) {
            return 1.0f;
        }
        if (this.method_37908().field_9236) {
            return ((Float)this.field_6011.method_12789(UTILIZATION)).floatValue();
        }
        int running = 0;
        for (int i : this.fuel) {
            if (i <= 0) continue;
            ++running;
        }
        float utilization = (float)running / (float)this.fuel.length * (this.isFuelLow() ? 0.75f : 1.0f);
        this.field_6011.method_12778(UTILIZATION, (Object)Float.valueOf(utilization));
        return utilization;
    }

    public void emitSmokeParticle(float x, float y, float z, float nx, float ny, float nz) {
        if (!this.isWithinParticleRange() || !this.method_37908().field_9236) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        Matrix3f normalTransform = this.getVehicleNormalTransform();
        float power = this.getEnginePower();
        if ((double)power > 0.05) {
            int i = 0;
            while ((float)i < 1.0f + this.engineSpinUpStrength * 4.0f) {
                Vector4f p = this.transformPosition(transform, x, y, z);
                Vector3f vel = this.transformVector(normalTransform, nx, ny, nz);
                class_243 velocity = this.method_18798();
                if ((double)this.field_5974.method_43057() < (double)this.engineSpinUpStrength * 0.1) {
                    vel.mul(0.5f);
                    this.method_37908().method_8406((class_2394)class_2398.field_27783, (double)p.x(), (double)p.y(), (double)p.z(), (double)vel.x() + velocity.field_1352, (double)vel.y() + velocity.field_1351, (double)vel.z() + velocity.field_1350);
                } else {
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, (double)p.x, (double)p.y, (double)p.z, (double)vel.x + velocity.field_1352, (double)vel.y + velocity.field_1351, (double)vel.z + velocity.field_1350);
                }
                ++i;
            }
        }
    }

    @Override
    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        for (int i = 0; i < this.fuel.length; ++i) {
            tag.method_10569("Fuel" + i, this.fuel[i]);
        }
    }

    @Override
    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        for (int i = 0; i < this.fuel.length; ++i) {
            this.fuel[i] = tag.method_10550("Fuel" + i);
        }
    }

    @Override
    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set("engine_rotation", this.engineRotation.getSmooth(tickDelta));
    }

    public static enum GUI_STYLE {
        NONE,
        ENGINE;

    }

    public static enum Cautions {
        PULL_UP,
        VOID,
        DAMAGED;

    }

    protected static enum FuelState {
        NEVER,
        EMPTY,
        FUELED,
        LOW;

    }
}

