/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.special.monobogey;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.ElementProvider;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import dev.engine_room.flywheel.lib.transform.Affine;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public class MonoBogeyDisplay
implements BogeyDisplay {
    private final Affine<?> frame;
    private final Affine<?>[] wheels;
    private final Affine<?>[] shafts;
    private final boolean inContraption;

    public MonoBogeyDisplay(ElementProvider<?> prov, boolean inContraption) {
        this.inContraption = inContraption;
        this.frame = prov.create(CRBlockPartials.MONOBOGEY_FRAME);
        this.wheels = prov.create(CRBlockPartials.MONOBOGEY_WHEEL, 4);
        this.shafts = prov.create(AllPartialModels.SHAFT, 4);
    }

    @Override
    public void update(class_2487 bogeyData, float wheelAngle) {
        boolean upsideDown = bogeyData.method_10577("UpsideDown");
        boolean specialUpsideDown = !this.inContraption && upsideDown;
        ((Affine)this.frame.rotateZDegrees(specialUpsideDown ? 180.0f : 0.0f)).translateY(specialUpsideDown ? -3.0f : 0.0f);
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                int i = (left ? 1 : 0) + (front + 1);
                Affine<?> shaft = this.shafts[i];
                ((Affine)((Affine)((Affine)((Affine)shaft.translate(left ? -1.3125f : 0.3125f, specialUpsideDown ? 2.0f : 0.0f, -0.5f + (float)(front * 8) / 16.0f)).center()).rotateTo(class_2350.field_11036, class_2350.field_11035)).rotateYDegrees(left ? wheelAngle : -wheelAngle)).uncenter();
                Affine<?> wheel = this.wheels[i];
                ((Affine)((Affine)wheel.translate(left ? -0.8125f : 0.8125f, specialUpsideDown ? 2.0f : 0.0f, (float)(front * 16) / 16.0f)).rotateYDegrees(left ? wheelAngle : -wheelAngle)).translate(0.8125f, 0.0f, 1.0f);
            }
        }
    }
}

