/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ChopTrainEndPacket
implements S2CPacket {
    final UUID trainId;
    final int numberOfCarriages;
    final boolean doubleEnded;

    public ChopTrainEndPacket(Train train, int numberOfCarriages, boolean doubleEnded) {
        this.trainId = train.id;
        this.numberOfCarriages = numberOfCarriages;
        this.doubleEnded = doubleEnded;
    }

    public ChopTrainEndPacket(class_2540 buf) {
        this.trainId = buf.method_10790();
        this.numberOfCarriages = buf.readInt();
        this.doubleEnded = buf.readBoolean();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.trainId);
        buffer.writeInt(this.numberOfCarriages);
        buffer.writeBoolean(this.doubleEnded);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(class_310 mc) {
        Train train;
        class_638 level = mc.field_1687;
        if (level != null && (train = (Train)CreateClient.RAILWAYS.trains.get(this.trainId)) != null) {
            for (int i = 0; i < this.numberOfCarriages; ++i) {
                train.carriages.remove(train.carriages.size() - 1);
                train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
            }
            double[] originalStress = ((AccessorTrain)train).railways$getStress();
            double[] newStress = new double[originalStress.length - this.numberOfCarriages];
            System.arraycopy(originalStress, 0, newStress, 0, newStress.length);
            ((AccessorTrain)train).railways$setStress(newStress);
            train.doubleEnded = this.doubleEnded;
        }
    }
}

