/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.gui.input.IMouseOverable;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import net.minecraft.class_155;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class UserInput
implements IJeiUserInput {
    private final class_3675.class_306 key;
    private final double mouseX;
    private final double mouseY;
    private final int modifiers;
    private final InputType inputType;

    public static UserInput fromVanilla(int keyCode, int scanCode, int modifiers, InputType inputType) {
        class_3675.class_306 input = class_3675.method_15985((int)keyCode, (int)scanCode);
        return new UserInput(input, MouseUtil.getX(), MouseUtil.getY(), modifiers, inputType);
    }

    public static Optional<UserInput> fromVanilla(double mouseX, double mouseY, int mouseButton, InputType inputType) {
        if (mouseButton < 0) {
            return Optional.empty();
        }
        class_3675.class_306 input = class_3675.class_307.field_1672.method_1447(mouseButton);
        UserInput userInput = new UserInput(input, mouseX, mouseY, 0, inputType);
        return Optional.of(userInput);
    }

    public UserInput(class_3675.class_306 key, double mouseX, double mouseY, int modifiers, InputType inputType) {
        this.key = key;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.modifiers = modifiers;
        this.inputType = inputType;
    }

    @Override
    public class_3675.class_306 getKey() {
        return this.key;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isSimulate() {
        return this.inputType == InputType.SIMULATE;
    }

    private boolean isKeyboard() {
        return this.key.method_1442() == class_3675.class_307.field_1668;
    }

    public boolean isAllowedChatCharacter() {
        return this.isKeyboard() && class_155.method_643((char)((char)this.key.method_1444()));
    }

    @Override
    public boolean is(IJeiKeyMapping keyMapping) {
        return keyMapping.isActiveAndMatches(this.key);
    }

    @Override
    public boolean is(class_304 keyMapping) {
        IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
        return inputHelper.isActiveAndMatches(keyMapping, this.key);
    }

    public boolean callVanilla(IMouseOverable mouseOverable, MouseClickable mouseClickable) {
        if (this.key.method_1442() == class_3675.class_307.field_1672 && mouseOverable.isMouseOver(this.mouseX, this.mouseY)) {
            if (this.isSimulate()) {
                return true;
            }
            return mouseClickable.mouseClicked(this.mouseX, this.mouseY, this.key.method_1444());
        }
        return false;
    }

    public boolean callVanilla(KeyPressable keyPressable) {
        if (this.key.method_1442() == class_3675.class_307.field_1668) {
            if (this.isSimulate()) {
                return false;
            }
            return keyPressable.keyPressed(this.key.method_1444(), 0, this.modifiers);
        }
        return false;
    }

    public boolean callVanilla(IMouseOverable mouseOverable, MouseClickable mouseClickable, KeyPressable keyPressable) {
        return switch (this.key.method_1442()) {
            case class_3675.class_307.field_1668 -> this.callVanilla(keyPressable);
            case class_3675.class_307.field_1672 -> this.callVanilla(mouseOverable, mouseClickable);
            default -> false;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inputType", (Object)this.inputType).add("key", (Object)KeyNameUtil.getKeyDisplayName(this.key).getString()).add("modifiers", this.modifiers).add("mouse", (Object)String.format("%s, %s", this.mouseX, this.mouseY)).toString();
    }

    @FunctionalInterface
    public static interface MouseClickable {
        public boolean mouseClicked(double var1, double var3, int var5);
    }

    @FunctionalInterface
    public static interface KeyPressable {
        public boolean keyPressed(int var1, int var2, int var3);
    }
}

