/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public record RecipeLayoutWithButtons<R>(IRecipeLayoutDrawable<R> recipeLayout, RecipeTransferButton transferButton, RecipeBookmarkButton bookmarkButton) {
    public int totalWidth() {
        int buttonRight;
        class_768 buttonArea;
        class_768 area = this.recipeLayout.getRect();
        class_768 areaWithBorder = this.recipeLayout.getRectWithBorder();
        int leftBorderWidth = area.method_3321() - areaWithBorder.method_3321();
        int rightAreaWidth = areaWithBorder.method_3319() - leftBorderWidth;
        if (this.transferButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
            buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        if (this.bookmarkButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeBookmarkButtonArea();
            buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        return leftBorderWidth + rightAreaWidth;
    }

    public IUserInputHandler createUserInputHandler() {
        return new CombinedInputHandler("RecipeLayoutWithButtons", this.bookmarkButton.createInputHandler(), this.transferButton.createInputHandler(), new RecipeLayoutUserInputHandler<R>(this.recipeLayout));
    }

    public void tick(@Nullable class_1703 parentContainer, @Nullable class_1657 player) {
        this.recipeLayout.tick();
        this.transferButton.update(parentContainer, player);
        this.bookmarkButton.tick();
    }

    private record RecipeLayoutUserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler
    {
        @Override
        public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipeLayout.isMouseOver(mouseX, mouseY = input.getMouseY())) {
                class_3675.class_306 key = input.getKey();
                boolean simulate = input.isSimulate();
                if (this.recipeLayout.getInputHandler().handleInput(mouseX, mouseY, input)) {
                    return Optional.of(this);
                }
                IInternalKeyMappings keyMappings = Internal.getKeyMappings();
                if (keyMappings.getCopyRecipeId().isActiveAndMatches(key) && this.handleCopyRecipeId(this.recipeLayout, simulate)) {
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }

        private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout, boolean simulate) {
            R recipe;
            if (simulate) {
                return true;
            }
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
            class_2960 registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
            if (registryName == null) {
                class_5250 message = class_2561.method_43471((String)"jei.message.copy.recipe.id.failure");
                if (player != null) {
                    player.method_7353((class_2561)message, false);
                }
                return false;
            }
            String recipeId = registryName.toString();
            minecraft.field_1774.method_1455(recipeId);
            class_5250 message = class_2561.method_43469((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{class_2561.method_43470((String)recipeId)});
            if (player != null) {
                player.method_7353((class_2561)message, false);
            }
            return true;
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (this.recipeLayout.isMouseOver(mouseX, mouseY) && this.recipeLayout.getInputHandler().handleMouseScrolled(mouseX, mouseY, scrollDelta)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }
    }
}

