/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.custom.MagicPaintingVariants;
import twilightforest.util.MagicPaintingVariant;

public class MagicPainting
extends class_1530 {
    private static final class_2940<String> DATA_PAINTING_VARIANT_ID = class_2945.method_12791(MagicPainting.class, (class_2941)class_2943.field_13326);
    public static final String EMPTY = "null";

    public MagicPainting(class_1299<? extends MagicPainting> entityType, class_1937 level) {
        super(entityType, level);
    }

    private MagicPainting(class_1937 level, class_2338 pos) {
        super((class_1299)TFEntities.MAGIC_PAINTING.get(), level, pos);
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_PAINTING_VARIANT_ID, (Object)EMPTY);
    }

    public void method_5674(class_2940<?> pKey) {
        if (DATA_PAINTING_VARIANT_ID.equals(pKey)) {
            this.method_6895();
        }
    }

    public void setVariant(String variant) {
        this.field_6011.method_12778(DATA_PAINTING_VARIANT_ID, (Object)variant);
    }

    public Optional<MagicPaintingVariant> getVariant() {
        String id = (String)this.field_6011.method_12789(DATA_PAINTING_VARIANT_ID);
        if (id.equals(EMPTY)) {
            return Optional.empty();
        }
        return MagicPaintingVariants.getVariant(this.method_37908().method_30349(), id);
    }

    public static Optional<MagicPainting> create(class_1937 level, class_2338 pos, class_2350 direction) {
        MagicPainting magicPainting = new MagicPainting(level, pos);
        ArrayList<MagicPaintingVariant> list = new ArrayList<MagicPaintingVariant>();
        class_5455 regAccess = level.method_30349();
        regAccess.method_30530(MagicPaintingVariants.REGISTRY_KEY).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        magicPainting.method_6892(direction);
        list.removeIf(variant -> {
            magicPainting.setVariant(MagicPaintingVariants.getVariantId(regAccess, variant));
            return !magicPainting.method_6888();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int biggestPossibleArea = list.stream().mapToInt(MagicPainting::variantArea).max().orElse(0);
        list.removeIf(variantArea -> MagicPainting.variantArea(variantArea) < biggestPossibleArea);
        Optional optional = class_156.method_40083(list, (class_5819)magicPainting.field_5974);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        magicPainting.setVariant(MagicPaintingVariants.getVariantId(regAccess, (MagicPaintingVariant)optional.get()));
        magicPainting.method_6892(direction);
        return Optional.of(magicPainting);
    }

    private static int variantArea(MagicPaintingVariant variant) {
        return variant.width() * variant.height();
    }

    public void method_5652(class_2487 tag) {
        tag.method_10582("variant", (String)this.field_6011.method_12789(DATA_PAINTING_VARIANT_ID));
        tag.method_10567("facing", (byte)this.field_7099.method_10161());
        super.method_5652(tag);
    }

    public void method_5749(class_2487 tag) {
        this.setVariant(tag.method_10545("variant") ? tag.method_10558("variant") : EMPTY);
        this.field_7099 = class_2350.method_10139((int)tag.method_10571("facing"));
        super.method_5749(tag);
        this.method_6892(this.field_7099);
    }

    public int method_6897() {
        return this.getVariant().map(MagicPaintingVariant::width).orElse(16);
    }

    public int method_6891() {
        return this.getVariant().map(MagicPaintingVariant::height).orElse(16);
    }

    public void method_6889(@Nullable class_1297 entity) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (player.method_31549().field_7477) {
                    return;
                }
            }
            this.method_5775((class_1799)class_156.method_654((Object)new class_1799((class_1935)TFItems.MAGIC_PAINTING.get()), stack -> {
                class_2487 tag = stack.method_7911("EntityTag");
                tag.method_10582("variant", (String)this.field_6011.method_12789(DATA_PAINTING_VARIANT_ID));
            }));
        }
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    public void method_5808(double x, double y, double z, float yaw, float pitch) {
        this.method_5814(x, y, z);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.method_5814(x, y, z);
    }

    public class_243 method_43390() {
        return class_243.method_24954((class_2382)this.field_7100);
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, this.field_7099.method_10146(), this.method_6896());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.method_6892(class_2350.method_10143((int)packet.method_11166()));
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)TFItems.MAGIC_PAINTING.get());
    }
}

