/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ai.goal.ThrowRiderGoal;
import twilightforest.entity.ai.goal.YetiRampageGoal;
import twilightforest.entity.ai.goal.YetiTiredGoal;
import twilightforest.entity.projectile.FallingIce;
import twilightforest.entity.projectile.IceBomb;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.WorldUtil;

public class AlphaYeti
extends class_1588
implements class_1603,
IHostileMount,
EnforcedHomePoint {
    private static final class_2940<Optional<class_4208>> HOME_POINT = class_2945.method_12791(AlphaYeti.class, (class_2941)class_2943.field_38825);
    private static final class_2940<Byte> RAMPAGE_FLAG = class_2945.method_12791(AlphaYeti.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> TIRED_FLAG = class_2945.method_12791(AlphaYeti.class, (class_2941)class_2943.field_13319);
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
    private int collisionCounter;
    private boolean canRampage;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();

    public AlphaYeti(class_1299<? extends AlphaYeti> type, class_1937 world) {
        super(type, world);
        this.field_6194 = 317;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new YetiTiredGoal(this, 100));
        this.field_6201.method_6277(3, (class_1352)new YetiRampageGoal(this, 10, 180));
        this.field_6201.method_6277(4, (class_1352)new class_1381(this, 1.0, 40, 40, 40.0f){

            public boolean method_6264() {
                return AlphaYeti.this.method_6051().method_43048(50) > 0 && AlphaYeti.this.method_5968() != null && AlphaYeti.this.method_5858((class_1297)AlphaYeti.this.method_5968()) >= 16.0 && super.method_6264();
            }
        });
        this.field_6201.method_6277(4, (class_1352)new ThrowRiderGoal((class_1314)this, 1.0, false){

            @Override
            protected void method_6288(class_1309 victim, double p_190102_2_) {
                super.method_6288(victim, p_190102_2_);
                if (!AlphaYeti.this.method_5685().isEmpty()) {
                    AlphaYeti.this.method_5783((class_3414)TFSounds.ALPHA_YETI_GRAB.get(), 4.0f, 0.75f + AlphaYeti.this.method_6051().method_43057() * 0.25f);
                }
            }

            @Override
            public void method_6270() {
                if (!AlphaYeti.this.method_5685().isEmpty()) {
                    AlphaYeti.this.method_5783((class_3414)TFSounds.ALPHA_YETI_THROW.get(), 4.0f, 0.75f + AlphaYeti.this.method_6051().method_43057() * 0.25f);
                }
                super.method_6270();
            }
        });
        this.addRestrictionGoals((class_1314)this, this.field_6201);
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 2.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(RAMPAGE_FLAG, (Object)0);
        this.method_5841().method_12784(TIRED_FLAG, (Object)0);
        this.method_5841().method_12784(HOME_POINT, Optional.empty());
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23719, 0.38).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23718, 0.5);
    }

    public void method_6007() {
        if (!this.method_5685().isEmpty() && ((class_1297)this.method_5685().get(0)).method_5715()) {
            ((class_1297)this.method_5685().get(0)).method_5660(false);
        }
        super.method_6007();
        if (this.method_5782()) {
            this.method_5988().method_6226((class_1297)this.method_5685().get(0), 100.0f, 100.0f);
        }
        if (!this.method_37908().method_8608()) {
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
            if (this.isRampaging() && (this.field_5976 || this.field_5992)) {
                ++this.collisionCounter;
            }
            if (this.collisionCounter >= 15) {
                this.destroyBlocksInAABB(this.method_5829());
                this.collisionCounter = 0;
            }
        } else {
            if (this.isRampaging()) {
                float rotation = (float)this.field_6012 / 10.0f;
                for (int i = 0; i < 20; ++i) {
                    this.addSnowEffect(rotation + (float)(i * 50), (float)i + rotation);
                }
                this.field_42108.method_48567(this.field_42108.method_48566() + 0.6f);
            }
            if (this.isTired()) {
                for (int i = 0; i < 20; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() * 0.5, this.method_23318() + (double)this.method_5751(), this.method_23321() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() * 0.5, (double)((this.field_5974.method_43057() - 0.5f) * 0.75f), 0.0, (double)((this.field_5974.method_43057() - 0.5f) * 0.75f));
                }
            }
        }
    }

    private void addSnowEffect(float rotation, float hgt) {
        double px = 3.0 * Math.cos(rotation);
        double py = hgt % 5.0f;
        double pz = 3.0 * Math.sin(rotation);
        this.method_37908().method_8406((class_2394)TFParticleType.SNOW.get(), this.field_6038 + px, this.field_5971 + py, this.field_5989 + pz, 0.0, 0.0, 0.0);
    }

    public void method_5980(@Nullable class_1309 entity) {
        if (entity != null && entity != this.method_5968()) {
            this.method_5783((class_3414)TFSounds.ALPHA_YETI_ALERT.get(), 4.0f, 0.5f + this.method_6051().method_43057() * 0.5f);
        }
        super.method_5980(entity);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_3222 player;
        if (!this.canRampage && !this.isTired() && source.method_48789(class_8103.field_42247)) {
            return false;
        }
        this.canRampage = true;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        return super.method_5643(source, amount);
    }

    public void method_5730() {
        if (!this.method_5753()) {
            this.method_5639(5);
            if (this.method_5643(this.method_48923().method_48817(), 4.0f)) {
                this.method_5783(class_3417.field_14821, 0.4f, 2.0f + this.field_5974.method_43057() * 0.4f);
                EntityUtil.killLavaAround((class_1297)this);
            }
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)TFSounds.ALPHA_YETI_GROWL.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.ALPHA_YETI_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.ALPHA_YETI_DEATH.get();
    }

    public float method_6017() {
        return 0.5f + this.method_6051().method_43057() * 0.5f;
    }

    protected float method_6107() {
        return 4.0f;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        class_243 riderPos = this.getRiderPosition();
        callback.accept(passenger, riderPos.method_10216(), riderPos.method_10214(), riderPos.method_10215());
    }

    public double method_5621() {
        return 5.75;
    }

    private class_243 getRiderPosition() {
        if (this.method_5782()) {
            float distance = 0.4f;
            double dx = Math.cos((double)(this.method_36454() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.method_36454() + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new class_243(this.method_23317() + dx, this.method_23318() + this.method_5621() + ((class_1297)this.method_5685().get(0)).method_5678(), this.method_23321() + dz);
        }
        return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void destroyBlocksInAABB(class_238 box) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            for (class_2338 pos : WorldUtil.getAllInBB(box)) {
                if (!EntityUtil.canDestroyBlock(this.method_37908(), pos, (class_1297)this)) continue;
                this.method_37908().method_22352(pos, false);
            }
        }
    }

    public void makeRandomBlockFall(int range, int hangTime) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            int bx = class_3532.method_15357((double)this.method_23317()) + this.method_6051().method_43048(range) - this.method_6051().method_43048(range);
            int bz = class_3532.method_15357((double)this.method_23321()) + this.method_6051().method_43048(range) - this.method_6051().method_43048(range);
            int by = class_3532.method_15357((double)(this.method_23318() + (double)this.method_5751()));
            this.makeBlockFallAbove(new class_2338(bx, by, bz), hangTime);
        }
    }

    private void makeBlockFallAbove(class_2338 pos, int hangTime) {
        for (int i = 1; i < 25; ++i) {
            class_2338 up = pos.method_10086(i);
            if (!this.method_37908().method_8320(up).method_26164(class_3481.field_15467) || !this.method_37908().method_8320(up.method_10074()).method_26215()) continue;
            this.makeBlockFall(up, hangTime);
            break;
        }
    }

    public void makeBlockAboveTargetFall() {
        if (this.method_5968() != null) {
            this.makeBlockFallAbove(this.method_5968().method_24515(), 40);
        }
    }

    private void makeBlockFall(class_2338 pos, int hangTime) {
        FallingIce ice = new FallingIce(this.method_37908(), (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, this.method_37908().method_8320(pos), hangTime);
        this.method_37908().method_8501(pos, class_2246.field_10124.method_9564());
        this.method_37908().method_8649((class_1297)ice);
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        if (!this.canRampage) {
            IceBomb ice = new IceBomb((class_1299<? extends IceBomb>)((class_1299)TFEntities.THROWN_ICE.get()), this.method_37908(), (class_1309)this);
            double d0 = target.method_23317() - this.method_23317();
            double d1 = target.method_5829().field_1322 + (double)(target.method_17682() / 3.0f) - ice.method_23318();
            double d2 = target.method_23321() - this.method_23321();
            double d3 = class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)));
            ice.method_7485(d0, d1 + d3 * 0.2, d2, 1.6f, 14 - this.method_37908().method_8407().method_5461() * 4);
            this.method_5783((class_3414)TFSounds.ALPHA_YETI_ICE.get(), 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
            this.method_32876(class_5712.field_28161);
            this.method_37908().method_8649((class_1297)ice);
        }
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            if (this.isRestrictionPointValid(this.method_37908().method_27983()) && this.method_37908().method_8477(this.getRestrictionPoint().method_19446())) {
                this.method_37908().method_8501(this.getRestrictionPoint().method_19446(), ((class_2248)TFBlocks.ALPHA_YETI_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public boolean canRampage() {
        return this.canRampage;
    }

    public void setRampaging(boolean rampaging) {
        this.method_5841().method_12778(RAMPAGE_FLAG, (Object)((byte)(rampaging ? 1 : 0)));
    }

    public boolean isRampaging() {
        return (Byte)this.method_5841().method_12789(RAMPAGE_FLAG) == 1;
    }

    public void setTired(boolean tired) {
        this.method_5841().method_12778(TIRED_FLAG, (Object)((byte)(tired ? 1 : 0)));
        this.canRampage = false;
    }

    public boolean isTired() {
        return (Byte)this.method_5841().method_12789(TIRED_FLAG) == 1;
    }

    public boolean method_5747(float distance, float multiplier, class_1282 source) {
        if (!this.method_37908().method_8608() && this.isRampaging()) {
            this.method_5783((class_3414)TFSounds.ALPHA_YETI_ICE.get(), 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
            this.hitNearbyEntities();
        }
        return super.method_5747(distance, multiplier, source);
    }

    private void hitNearbyEntities() {
        for (class_1309 entity : this.method_37908().method_18467(class_1309.class, this.method_5829().method_1009(5.0, 0.0, 5.0))) {
            if (entity == this || !entity.method_5643(this.method_48923().method_48812((class_1309)this), 5.0f)) continue;
            entity.method_5762(0.0, 0.4, 0.0);
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.method_37908().method_8608()) {
            this.bossInfo.method_5408(0.0f);
            LandmarkUtil.markStructureConquered(this.method_37908(), this, TFStructures.YETI_CAVE, true);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            TFLootTables.entityDropsIntoContainer((class_1309)this, cause, ((TFChestBlock)((Object)TFBlocks.CANOPY_CHEST.get())).method_9564(), EntityUtil.bossChestLocation(this));
        }
    }

    protected boolean method_27071() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public void method_5652(class_2487 compound) {
        this.saveHomePointToNbt(compound);
        super.method_5652(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadHomePointFromNbt(compound);
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    @Override
    @Nullable
    public class_4208 getRestrictionPoint() {
        return ((Optional)this.method_5841().method_12789(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable class_4208 pos) {
        this.method_5841().method_12778(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 30;
    }
}

