/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_5699;
import net.minecraft.class_6544;
import net.minecraft.class_6880;

public final class Codecs {
    public static final Codec<class_2338> STRING_POS = Codec.STRING.comapFlatMap(Codecs::parseString2BlockPos, class_2382::method_23854);
    public static final Codec<class_2350> ONLY_HORIZONTAL = class_2350.field_29502.comapFlatMap(direction -> direction.method_10166() != class_2350.class_2351.field_11052 ? DataResult.success((Object)direction) : DataResult.error(() -> "Horizontal direction only!", (Object)direction), Function.identity());
    public static final Codec<Float> FLOAT_STRING = Codec.STRING.comapFlatMap(Codecs::parseString2Float, f -> Float.toString(f.floatValue()));
    public static final Codec<class_6544.class_6547<class_6880<class_1959>>> CLIMATE_SYSTEM = class_5699.method_36973((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_6544.class_4762.field_24679.fieldOf("parameters").forGetter(Pair::getFirst), (App)class_1959.field_24677.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(class_6544.class_6547::new, class_6544.class_6547::method_38128);

    public static <T> Codec<Float2ObjectSortedMap<T>> floatTreeCodec(Codec<T> elementCodec) {
        return Codec.compoundList(FLOAT_STRING, elementCodec).xmap(floatEList -> (Float2ObjectSortedMap)floatEList.stream().collect(Float2ObjectAVLTreeMap::new, (map, pair) -> map.put((Float)pair.getFirst(), pair.getSecond()), AbstractFloat2ObjectMap::putAll), map -> map.entrySet().stream().map(entry -> new Pair((Object)((Float)entry.getKey()), entry.getValue())).toList());
    }

    private static DataResult<class_2338> parseString2BlockPos(String string) {
        try {
            return class_156.method_29190((IntStream)Arrays.stream(string.split(" *, *")).mapToInt(Integer::parseInt), (int)3).map(arr -> new class_2338(arr[0], arr[1], arr[2]));
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
    }

    private static DataResult<Float> parseString2Float(String string) {
        try {
            return DataResult.success((Object)Float.valueOf(string));
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
    }

    public static <E> DataResult<Pair<E, E>> arrayToPair(List<E> list) {
        return class_156.method_33141(list, (int)2).map(l -> Pair.of(l.get(0), l.get(1)));
    }

    private Codecs() {
    }
}

