/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import org.jetbrains.annotations.NotNull;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.RectangleLatticeIterator;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.structures.TFStructureComponentOld;

public class HollowHillComponent
extends TFStructureComponentOld {
    private static final float SPACING = 3.75f;
    private static final float X_OFFSET = class_3532.method_15362((float)0.5235988f) * 3.75f;
    private static final float Z_OFFSET = class_3532.method_15374((float)0.5235988f) * 3.75f;
    private static final float X_SPACING = X_OFFSET * 2.0f;
    private static final float Z_SPACING = 3.75f;
    private static final float CHEST_SPAWN_CHANCE = 0.025f;
    private static final float SPAWNER_SPAWN_CHANCE = 0.025f;
    private static final float SPECIAL_SPAWN_CHANCE = 0.05f;
    private static final float ORE_STALACTITE_CHANCE = 0.85f;
    private final int hillSize;
    final int radius;
    final int hdiam;

    public HollowHillComponent(class_6625 ctx, class_2487 nbt) {
        this((class_3773)TFStructurePieceTypes.TFHill.get(), nbt);
    }

    public HollowHillComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.hillSize = nbt.method_10550("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
    }

    public HollowHillComponent(class_3773 piece, int i, int size, int x, int y, int z) {
        super(piece, i, x, y, z);
        this.method_14926(class_2350.field_11035);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
        this.field_15315 = TFLandmark.getComponentToAddBoundingBox(x, y, z, -this.radius, -(3 + this.hillSize), -this.radius, this.radius * 2, this.radius / (this.hillSize == 1 ? 2 : this.hillSize), this.radius * 2, class_2350.field_11035, true);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10569("hillSize", this.hillSize);
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 writeableBounds, class_1923 chunkPosIn, class_2338 blockPos) {
        int distSq;
        class_2338 locatorPos = this.method_35458();
        float shortenedRadiusSq = (float)(this.radius * this.radius) * 0.85f;
        for (class_2338.class_2339 latticePos : RectangleLatticeIterator.boundedGrid(writeableBounds, 0, X_SPACING, 3.75f, 0.0f, 0.0f)) {
            distSq = HollowHillComponent.getDistSqFromCenter(locatorPos, (class_2338)latticePos);
            if ((float)distSq > shortenedRadiusSq) continue;
            this.setFeatures(world, rand, writeableBounds, latticePos, distSq);
        }
        for (class_2338.class_2339 latticePos : RectangleLatticeIterator.boundedGrid(writeableBounds, 0, X_SPACING, 3.75f, X_OFFSET, Z_OFFSET)) {
            distSq = HollowHillComponent.getDistSqFromCenter(locatorPos, (class_2338)latticePos);
            if ((float)distSq > shortenedRadiusSq) continue;
            this.setFeatures(world, rand, writeableBounds, latticePos, distSq);
        }
    }

    private void setFeatures(class_5281 world, class_5819 rand, class_3341 writeableBounds, class_2338.class_2339 pos, int distSq) {
        rand.method_43052(rand.method_43055() ^ pos.method_10063());
        this.placeCeilingFeature(world, rand, pos, distSq);
        this.placeFloorFeature(world, rand, writeableBounds, pos, distSq);
    }

    private void placeFloorFeature(class_5281 world, class_5819 rand, class_3341 writeableBounds, class_2338.class_2339 pos, int distSq) {
        int y = this.method_14924(class_3532.method_15375((float)(this.getFloorHeight(class_3532.method_15355((float)distSq)) + 0.25f)));
        float floatChance = rand.method_43057();
        if (floatChance < 0.05f) {
            float angle = rand.method_43057() * ((float)Math.PI * 2);
            int x = Math.round(class_3532.method_15362((float)angle) * class_3532.field_15724) + pos.method_10263();
            int z = Math.round(class_3532.method_15374((float)angle) * class_3532.field_15724) + pos.method_10260();
            pos.method_10103(x, y, z);
            if (floatChance < 0.025f) {
                HollowHillComponent.setSpawnerInWorld(world, writeableBounds, this.getMobID(rand), v -> {}, pos.method_10084());
            } else {
                this.placeTreasureAtWorldPosition(world, this.getTreasureType(), false, writeableBounds, pos.method_10084());
            }
            world.method_8652(pos.method_10074(), class_2246.field_10445.method_9564(), 50);
            world.method_8652((class_2338)pos, class_2246.field_10445.method_9564(), 50);
        } else {
            pos.method_33098(y);
            BlockSpikeFeature.startSpike(world, (class_2338)pos, BlockSpikeFeature.STONE_STALACTITE, rand, false);
        }
    }

    private void placeCeilingFeature(class_5281 world, class_5819 rand, class_2338.class_2339 pos, int distSq) {
        class_2338 ceiling = pos.method_33096(this.method_14924(class_3532.method_15386((float)this.getCeilingHeight(class_3532.method_15355((float)distSq)))));
        Stalactite stalag = rand.method_43057() < 0.85f ? BlockSpikeFeature.makeRandomOreStalactite(rand, this.hillSize) : BlockSpikeFeature.STONE_STALACTITE;
        BlockSpikeFeature.startSpike(world, ceiling, stalag, rand, true);
    }

    @NotNull
    private TFLootTables getTreasureType() {
        return this.hillSize == 3 ? TFLootTables.LARGE_HOLLOW_HILL : (this.hillSize == 2 ? TFLootTables.MEDIUM_HOLLOW_HILL : TFLootTables.SMALL_HOLLOW_HILL);
    }

    protected void generateOreStalactite(class_5281 world, class_2382 pos, class_3341 sbb) {
        this.generateOreStalactite(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), sbb);
    }

    protected void generateOreStalactite(class_5281 world, int x, int y, int z, class_3341 sbb) {
        int dz;
        int dy;
        int dx = this.method_14928(x, z);
        class_2338 pos = new class_2338(dx, dy = this.method_14924(y), dz = this.method_14941(x, z));
        if (sbb.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_10260) {
            class_5819 stalRNG = class_5819.method_43049((long)(world.method_8412() + (long)dx * (long)dz));
            Stalactite stalag = BlockSpikeFeature.makeRandomOreStalactite(stalRNG, this.hillSize);
            BlockSpikeFeature.startSpike(world, pos, stalag, stalRNG, true);
        }
    }

    protected void generateBlockSpike(class_5281 world, Stalactite config, int x, int y, int z, class_3341 sbb, boolean hanging) {
        int dz;
        int dy;
        int dx = this.method_14928(x, z);
        class_2338 pos = new class_2338(dx, dy = this.method_14924(y), dz = this.method_14941(x, z));
        if (sbb.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_10260) {
            class_5819 stalRNG = class_5819.method_43049((long)(world.method_8412() + (long)dx * (long)dz));
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG, hanging);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        return class_3532.method_15355((float)(dx * dx + dz * dz)) < (float)this.radius;
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(class_5819 rand) {
        return this.randomCoordinatesInHill2D(rand, this.radius);
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(class_5819 rand, int maximumRadius) {
        class_2338.class_2339 pos = this.randomFloorCoordinates(rand, maximumRadius);
        return new int[]{pos.method_10263(), pos.method_10260()};
    }

    class_2338.class_2339 randomFloorCoordinates(class_5819 rand, float maximumRadius) {
        float degree = rand.method_43057() * ((float)Math.PI * 2);
        float radius = rand.method_43057() * 0.9f * maximumRadius;
        float dist = class_3532.method_15355((float)(radius * radius));
        float height = this.getFloorHeight(dist);
        return new class_2338.class_2339((double)(maximumRadius - class_3532.method_15362((float)degree) * radius), (double)height, (double)(maximumRadius - class_3532.method_15374((float)degree) * radius));
    }

    private float getFloorHeight(float dist) {
        return (float)(this.hillSize * 2) - class_3532.method_15362((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 20.0f) + 1.0f;
    }

    class_2338.class_2339 randomCeilingCoordinates(class_5819 rand, float maximumRadius) {
        float degree = rand.method_43057() * ((float)Math.PI * 2);
        float radius = rand.method_43057() * 0.9f * maximumRadius;
        float dist = class_3532.method_15355((float)(radius * radius));
        float height = this.getCeilingHeight(dist);
        return new class_2338.class_2339((double)(maximumRadius - class_3532.method_15362((float)degree) * radius), (double)height, (double)(maximumRadius - class_3532.method_15374((float)degree) * radius));
    }

    private float getCeilingHeight(float dist) {
        return class_3532.method_15362((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 4.0f);
    }

    protected class_1299<?> getMobID(class_5819 rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected class_1299<?> getMobID(class_5819 rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return class_1299.field_6079;
    }

    public class_1299<?> getLevel1Mob(class_5819 rand) {
        return switch (rand.method_43048(10)) {
            case 3, 4, 5 -> class_1299.field_6079;
            case 6, 7 -> class_1299.field_6051;
            case 8 -> class_1299.field_6125;
            case 9 -> (class_1299)TFEntities.REDCAP.get();
            default -> (class_1299)TFEntities.SWARM_SPIDER.get();
        };
    }

    public class_1299<?> getLevel2Mob(class_5819 rand) {
        return switch (rand.method_43048(10)) {
            case 3, 4, 5 -> class_1299.field_6051;
            case 6, 7 -> class_1299.field_6137;
            case 8 -> (class_1299)TFEntities.SWARM_SPIDER.get();
            case 9 -> class_1299.field_6084;
            default -> (class_1299)TFEntities.REDCAP.get();
        };
    }

    public class_1299<?> getLevel3Mob(class_5819 rand) {
        return switch (rand.method_43048(11)) {
            case 0 -> (class_1299)TFEntities.SLIME_BEETLE.get();
            case 1 -> (class_1299)TFEntities.FIRE_BEETLE.get();
            case 2 -> (class_1299)TFEntities.PINCH_BEETLE.get();
            case 3, 4, 5 -> class_1299.field_6137;
            case 6, 7, 8 -> class_1299.field_6084;
            case 9 -> class_1299.field_6046;
            default -> (class_1299)TFEntities.WRAITH.get();
        };
    }

    public static int getDistSqFromCenter(class_2338 center, class_2338 to) {
        int x = to.method_10263() - center.method_10263();
        int z = to.method_10260() - center.method_10260();
        return x * x + z * z;
    }
}

