/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.icetower.IceTowerBeardComponent;
import twilightforest.world.components.structures.icetower.IceTowerBossWingComponent;
import twilightforest.world.components.structures.icetower.IceTowerDecorator;
import twilightforest.world.components.structures.icetower.IceTowerMainComponent;
import twilightforest.world.components.structures.icetower.IceTowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class IceTowerWingComponent
extends TowerWingComponent {
    protected static final int SIZE = 11;
    private static final int RANGE = 17;
    boolean hasBase = false;
    protected int treasureFloor = -1;

    public IceTowerWingComponent(class_6625 ctx, class_2487 nbt) {
        this((class_3773)TFStructurePieceTypes.TFITWin.get(), nbt);
    }

    public IceTowerWingComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.hasBase = nbt.method_10577("hasBase");
        this.treasureFloor = nbt.method_10550("treasureFloor");
    }

    protected IceTowerWingComponent(class_3773 piece, int i, int x, int y, int z, int pSize, int pHeight, class_2350 direction) {
        super(piece, i, x, y, z, pSize, pHeight, direction);
        if (this.deco == null) {
            this.deco = new IceTowerDecorator();
        }
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10556("hasBase", this.hasBase);
        tagCompound.method_10569("treasureFloor", this.treasureFloor);
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, class_2470.field_11464);
        this.hasBase = this.shouldHaveBase(rand);
        if (this.method_14923() < 5) {
            class_2470 dirOffset = RotationUtil.ROTATIONS[rand.method_43048(RotationUtil.ROTATIONS.length)];
            for (class_2470 rotation : RotationUtil.ROTATIONS) {
                class_2470 dir = dirOffset.method_10501(rotation);
                int[] dest = this.getValidOpening(rand, dir);
                if (this.method_14923() == 4 && parent instanceof IceTowerMainComponent && !((IceTowerMainComponent)parent).hasBossWing) {
                    ((IceTowerMainComponent)parent).hasBossWing = this.makeBossTowerWing(list, rand, this.method_14923() + 1, dest[0], dest[1], dest[2], 15, 41, dir);
                    continue;
                }
                int childHeight = (rand.method_43048(2) + rand.method_43048(2) + 2) * 10 + 1;
                this.makeTowerWing(list, rand, this.method_14923() + 1, dest[0], dest[1], dest[2], 11, childHeight, dir);
            }
        }
        int floors = this.height / 10;
        if (this.treasureFloor == -1 && floors > 1) {
            this.treasureFloor = rand.method_43048(floors - 1);
        }
        this.makeARoof(parent, list, rand);
        if (!this.hasBase) {
            this.makeABeard(parent, list, rand);
        }
    }

    protected boolean shouldHaveBase(class_5819 rand) {
        return this.method_14923() == 0 || rand.method_43056();
    }

    private boolean isOutOfRange(class_3443 parent, int nx, int nz, int range) {
        class_3341 sbb = parent.method_14935();
        int centerX = sbb.method_35415() + (sbb.method_35418() - sbb.method_35415() + 1) / 2;
        int centerZ = sbb.method_35417() + (sbb.method_35420() - sbb.method_35417() + 1) / 2;
        return Math.abs(nx - centerX) > range || Math.abs(nz - centerZ) > range;
    }

    @Override
    public boolean makeTowerWing(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        IceTowerWingComponent wing;
        class_3443 intersect;
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            if (!start.field_34944.isEmpty() && this.isOutOfRange((class_3443)start.field_34944.get(0), dx[0], dx[2], 17)) {
                return false;
            }
        }
        if ((intersect = list.method_35461((wing = new IceTowerWingComponent((class_3773)TFStructurePieceTypes.TFITWin.get(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction)).method_14935())) == null || intersect == this) {
            list.method_35462((class_3443)wing);
            if (list instanceof class_6626) {
                class_6626 start = (class_6626)list;
                wing.method_14918((class_3443)start.field_34944.get(0), list, rand);
            }
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    public boolean makeBossTowerWing(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        IceTowerBossWingComponent wing = new IceTowerBossWingComponent(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        class_3443 intersect = list.method_35461(wing.method_14935());
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)wing);
            if (list instanceof class_6626) {
                class_6626 start = (class_6626)list;
                wing.method_14918((class_3443)start.field_34944.get(0), list, rand);
            }
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    @Override
    protected int getYByStairs(int rx, class_5819 rand, class_2470 direction) {
        int floors = this.height / 10;
        return 11 + rand.method_43048(floors - 1) * 10;
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        class_5819 decoRNG = class_5819.method_43049((long)(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L));
        this.method_14938(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, this.deco.randomBlocks);
        this.method_14942(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.hasBase) {
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    this.method_14936(world, this.deco.blockState, x, -1, z, sbb);
                }
            }
        }
        this.makeFloorsForTower(world, decoRNG, sbb);
        this.makeOpenings(world, sbb);
    }

    protected void makeFloorsForTower(class_5281 world, class_5819 decoRNG, class_3341 sbb) {
        int floors = this.height / 10;
        class_2470 ladderDir = class_2470.field_11465;
        class_2470 downLadderDir = null;
        int floorHeight = 10;
        for (int i = 0; i < floors - 1; ++i) {
            this.placeFloor(world, decoRNG, sbb, floorHeight, i);
            downLadderDir = ladderDir.method_10501(class_2470.field_11463);
            this.decorateFloor(world, decoRNG, i, i * floorHeight, i * floorHeight + floorHeight, ladderDir, downLadderDir, sbb);
        }
        int topFloor = floors - 1;
        this.decorateTopFloor(world, decoRNG, topFloor, topFloor * floorHeight, topFloor * floorHeight + floorHeight, ladderDir, downLadderDir, sbb);
    }

    protected void placeFloor(class_5281 world, class_5819 rand, class_3341 sbb, int floorHeight, int floor) {
        for (int x = 1; x < this.size - 1; ++x) {
            for (int z = 1; z < this.size - 1; ++z) {
                this.method_14917(world, this.deco.floorState, x, floor * floorHeight + floorHeight, z, sbb);
            }
        }
    }

    @Override
    protected void makeDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (this.method_14929((class_1922)world, dx, dy + 2, dz, sbb).method_26204() != class_2246.field_10124) {
            this.method_14917(world, this.deco.accentState, dx, dy + 2, dz, sbb);
        }
    }

    @Override
    protected void decorateFloor(class_5281 world, class_5819 rand, int floor, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        boolean hasTreasure = this.treasureFloor == floor;
        switch (rand.method_43048(8)) {
            case 0: {
                if (this.isNoDoorAreaRotated(9, bottom + 5, 1, 10, top + 1, 7, ladderUpDir)) {
                    this.decorateWraparoundWallSteps(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                    break;
                }
            }
            case 1: {
                if (this.isNoDoorAreaRotated(7, bottom, 0, 10, top + 1, 10, ladderUpDir)) {
                    this.decorateFarWallSteps(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                    break;
                }
            }
            case 2: {
                if (this.isNoDoorAreaRotated(9, bottom + 5, 1, 10, top + 1, 7, ladderUpDir)) {
                    this.decorateWraparoundWallStepsPillars(world, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
                    break;
                }
            }
            case 3: {
                this.decoratePlatform(world, rand, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
                break;
            }
            case 4: {
                this.decoratePillarParkour(world, rand, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
                break;
            }
            case 5: {
                this.decoratePillarPlatforms(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                break;
            }
            case 6: {
                this.decoratePillarPlatformsOutside(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                break;
            }
            default: {
                this.decorateQuadPillarStairs(world, rand, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
            }
        }
    }

    private boolean isNoDoorAreaRotated(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2470 rotation) {
        boolean isClear = true;
        class_3341 exclusionBox = switch (rotation) {
            case class_2470.field_11463 -> new class_3341(this.size - 1 - maxZ, minY, minX, this.size - 1 - minZ, maxY, maxX);
            case class_2470.field_11464 -> new class_3341(this.size - 1 - maxX, minY, this.size - 1 - maxZ, this.size - 1 - minX, maxY, this.size - 1 - minZ);
            case class_2470.field_11465 -> new class_3341(minZ, minY, this.size - 1 - maxX, maxZ, maxY, this.size - 1 - minX);
            default -> new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
        };
        for (class_2338 door : this.openings) {
            if (!exclusionBox.method_14662((class_2382)door)) continue;
            isClear = false;
        }
        return isClear;
    }

    protected void decorateTopFloor(class_5281 world, class_5819 rand, int floor, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        if (rand.method_43056()) {
            this.decoratePillarsCorners(world, rand, bottom, top, ladderDownDir, sbb);
        } else {
            this.decoratePillarsGrid(world, rand, bottom, top, ladderDownDir, sbb);
        }
        if (this.isDeadEnd()) {
            this.decorateTopFloorTreasure(world, bottom, ladderDownDir, sbb);
        }
    }

    private void decorateTopFloorTreasure(class_5281 world, int bottom, class_2470 rotation, class_3341 sbb) {
        this.fillBlocksRotated(world, sbb, 5, bottom + 1, 5, 5, bottom + 4, 5, this.deco.pillarState, rotation);
        this.placeTreasureAtCurrentPosition(world, 5, bottom + 5, 5, TFLootTables.AURORA_ROOM, sbb);
    }

    private void decoratePillars(class_5281 world, int bottom, int top, class_2470 rotation, class_3341 sbb) {
        this.fillBlocksRotated(world, sbb, 3, bottom + 1, 3, 3, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 1, 3, 7, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 1, 7, 3, top - 1, 7, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 1, 7, 7, top - 1, 7, this.deco.pillarState, rotation);
    }

    private void decoratePillarsGrid(class_5281 world, class_5819 rand, int bottom, int top, class_2470 rotation, class_3341 sbb) {
        class_2680 pillarEW = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        class_2680 pillarNS = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 9, bottom + 5, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 7, 9, bottom + 5, 7, pillarNS, rotation);
        this.decoratePillars(world, bottom, top, rotation, sbb);
    }

    private void decoratePillarsCorners(class_5281 world, class_5819 rand, int bottom, int top, class_2470 rotation, class_3341 sbb) {
        class_2680 pillarEW = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        class_2680 pillarNS = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 9, bottom + 5, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 7, 9, bottom + 5, 7, pillarNS, rotation);
        this.fillAirRotated(world, sbb, 3, bottom + 5, 3, 7, bottom + 5, 7, rotation);
        this.decoratePillars(world, bottom, top, rotation, sbb);
    }

    private void decorateFarWallSteps(class_5281 world, int bottom, int top, class_2470 ladderUpDir, boolean hasTreasure, class_3341 sbb) {
        int by;
        int y;
        int z;
        for (z = 1; z < 10; ++z) {
            y = bottom + 10 - z / 2;
            this.setBlockStateRotated(world, z % 2 == 0 ? this.deco.pillarState : this.deco.platformState, 9, y, z, ladderUpDir, sbb);
            for (by = bottom + 1; by < y; ++by) {
                this.setBlockStateRotated(world, this.deco.pillarState, 9, by, z, ladderUpDir, sbb);
            }
        }
        for (z = 1; z < 10; ++z) {
            y = bottom + 1 + z / 2;
            this.setBlockStateRotated(world, z % 2 == 0 ? this.deco.platformState : this.deco.pillarState, 8, y, z, ladderUpDir, sbb);
            for (by = bottom + 1; by < y; ++by) {
                this.setBlockStateRotated(world, this.deco.pillarState, 8, by, z, ladderUpDir, sbb);
            }
        }
        this.setBlockStateRotated(world, this.deco.platformState, 7, bottom + 1, 1, ladderUpDir, sbb);
        for (z = 2; z < 7; ++z) {
            this.setBlockStateRotated(world, AIR, 9, top, z, ladderUpDir, sbb);
        }
        class_2680 pillarNS = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 1, bottom + 8, 5, this.method_14934().method_10153(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
            this.setBlockStateRotated(world, pillarNS, 1, bottom + 7, 5, ladderUpDir, sbb);
        }
    }

    private void decorateWraparoundWallSteps(class_5281 world, int bottom, int top, class_2470 ladderUpDir, boolean hasTreasure, class_3341 sbb) {
        int y;
        int z;
        class_2680 topPlatform = (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
        class_2680 bottomPlatform = (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        for (z = 1; z < 10; ++z) {
            y = bottom + 10 - z / 2;
            this.setBlockStateRotated(world, z % 2 == 0 ? topPlatform : bottomPlatform, 9, y, z, ladderUpDir, sbb);
        }
        for (int x = 1; x < 9; ++x) {
            y = bottom + 2 + (x - 1) / 2;
            this.setBlockStateRotated(world, x % 2 == 0 ? topPlatform : bottomPlatform, x, y, 9, ladderUpDir, sbb);
        }
        this.setBlockStateRotated(world, topPlatform, 1, bottom + 1, 8, ladderUpDir, sbb);
        this.setBlockStateRotated(world, this.deco.platformState, 1, bottom + 1, 7, ladderUpDir, sbb);
        for (z = 2; z < 7; ++z) {
            this.setBlockStateRotated(world, AIR, 9, top, z, ladderUpDir, sbb);
        }
        if (hasTreasure) {
            this.placeTreasureRotated(world, 1, bottom + 5, 5, this.method_14934(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
            class_2680 pillarNS = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
            this.setBlockStateRotated(world, pillarNS, 1, bottom + 4, 5, ladderUpDir, sbb);
        }
    }

    private void decorateWraparoundWallStepsPillars(class_5281 world, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, boolean hasTreasure, class_3341 sbb) {
        class_2680 pillarEW = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        class_2680 pillarNS = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        this.decorateWraparoundWallSteps(world, bottom, top, ladderUpDir, false, sbb);
        this.decoratePillars(world, bottom, top, ladderDownDir, sbb);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 2, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 2, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 8, bottom + 5, 3, 9, bottom + 5, 3, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 8, bottom + 5, 7, 9, bottom + 5, 7, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 2, 3, 2, bottom + 2, 3, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 6, 3, 2, bottom + 6, 3, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 4, 7, 2, bottom + 4, 7, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 8, 7, 2, bottom + 8, 7, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 3, bottom + 6, 8, 3, bottom + 6, 9, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 7, bottom + 8, 8, 7, bottom + 8, 9, pillarEW, ladderDownDir);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 7, bottom + 6, 1, this.method_14934(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePlatform(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, boolean hasTreasure, class_3341 sbb) {
        int x;
        int y;
        int z;
        class_2680 topPlatform = (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
        class_2680 bottomPlatform = (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        this.decoratePillars(world, bottom, top, ladderDownDir, sbb);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 3, 7, bottom + 5, 7, this.deco.floorState, ladderDownDir);
        for (z = 6; z < 10; ++z) {
            y = bottom - 2 + z / 2;
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 1, y, z, ladderDownDir, sbb);
        }
        for (x = 2; x < 6; ++x) {
            y = bottom + 2 + x / 2;
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 9, ladderDownDir, sbb);
        }
        this.setBlockStateRotated(world, this.deco.platformState, 5, bottom + 5, 8, ladderDownDir, sbb);
        this.setBlockStateRotated(world, this.deco.platformState, 5, bottom + 6, 2, ladderUpDir, sbb);
        for (x = 5; x < 10; ++x) {
            y = bottom + 4 + x / 2;
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 1, ladderUpDir, sbb);
            if (x <= 6) continue;
            this.setBlockStateRotated(world, AIR, x, top, 1, ladderUpDir, sbb);
        }
        for (z = 2; z < 5; ++z) {
            y = bottom + 8 + z / 2;
            this.setBlockStateRotated(world, AIR, 9, top, z, ladderUpDir, sbb);
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 9, y, z, ladderUpDir, sbb);
        }
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 6, 5, this.method_14934(), ladderDownDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decorateQuadPillarStairs(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, boolean hasTreasure, class_3341 sbb) {
        int x;
        int y;
        int z;
        this.decoratePillars(world, bottom, top, ladderDownDir, sbb);
        class_2680 topPlatform = (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
        class_2680 bottomPlatform = (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        for (z = 6; z < 9; ++z) {
            y = bottom - 2 + z / 2;
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 2, y, z, ladderDownDir, sbb);
        }
        for (x = 3; x < 9; ++x) {
            y = bottom + 1 + x / 2;
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 8, ladderDownDir, sbb);
        }
        for (z = 7; z > 1; --z) {
            y = top - 2 - (z - 1) / 2;
            if (z < 4) {
                this.setBlockStateRotated(world, AIR, 8, top, z, ladderDownDir, sbb);
            }
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 8, y, z, ladderDownDir, sbb);
        }
        for (x = 7; x > 3; --x) {
            y = top + 1 - (x - 1) / 2;
            this.setBlockStateRotated(world, AIR, x, top, 2, ladderDownDir, sbb);
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 2, ladderDownDir, sbb);
        }
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 7, 7, this.method_14934(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePillarPlatforms(class_5281 world, int bottom, int top, class_2470 ladderUpDir, boolean hasTreasure, class_3341 sbb) {
        class_2470 r = ladderUpDir;
        for (int i = 1; i < 10; ++i) {
            r = r.method_10501(class_2470.field_11463);
            this.fillBlocksRotated(world, sbb, 2, bottom + i, 2, 4, bottom + i, 4, this.deco.floorState, this.field_15313);
        }
        this.fillAirRotated(world, sbb, 2, top, 2, 8, top, 4, ladderUpDir);
        this.fillAirRotated(world, sbb, 2, top, 2, 4, top, 6, ladderUpDir);
        this.setBlockStateRotated(world, this.deco.platformState, 7, top, 3, ladderUpDir, sbb);
        this.setBlockStateRotated(world, this.deco.platformState, 3, top, 3, ladderUpDir, sbb);
        this.decoratePillars(world, bottom, top, ladderUpDir, sbb);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 5, 2, this.method_14934(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePillarPlatformsOutside(class_5281 world, int bottom, int top, class_2470 ladderUpDir, boolean hasTreasure, class_3341 sbb) {
        for (int i = 0; i < 2; ++i) {
            for (class_2470 r : RotationUtil.ROTATIONS) {
                if (i == 0 && r == class_2470.field_11467) continue;
                class_2470 rotation = ladderUpDir.method_10501(r);
                this.fillBlocksRotated(world, sbb, 1, bottom + i, 1, 3, bottom + i, 3, this.deco.platformState, rotation);
                this.fillBlocksRotated(world, sbb, 4, bottom + i, 1, 6, bottom + i, 3, this.deco.floorState, rotation);
            }
        }
        class_2470 rotation = ladderUpDir.method_10501(class_2470.field_11464);
        this.fillAirRotated(world, sbb, 5, top, 8, 9, top, 9, rotation);
        this.fillAirRotated(world, sbb, 8, top, 6, 9, top, 9, rotation);
        this.fillBlocksRotated(world, sbb, 8, top - 2, 7, 9, top - 2, 7, this.deco.platformState, rotation);
        this.fillBlocksRotated(world, sbb, 8, top - 2, 8, 9, top - 2, 9, this.deco.floorState, rotation);
        this.fillBlocksRotated(world, sbb, 7, top - 1, 8, 7, top - 1, 9, this.deco.platformState, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - 1, 8, 6, top - 1, 9, (class_2680)this.deco.platformState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679), rotation);
        this.fillBlocksRotated(world, sbb, 5, top, 8, 5, top, 9, this.deco.platformState, rotation);
        this.decoratePillars(world, bottom, top, ladderUpDir, sbb);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 5, 2, this.method_14934(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePillarParkour(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, boolean hasTreasure, class_3341 sbb) {
        class_2680 pillarEW = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        class_2680 pillarNS = (class_2680)this.deco.pillarState.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        this.decoratePillars(world, bottom, top, ladderDownDir, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, 5, bottom + 1, 5, ladderDownDir, sbb);
        this.fillBlocksRotated(world, sbb, 5, bottom + 2, 7, 5, bottom + 2, 9, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 3, 7, 2, bottom + 3, 7, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 3, bottom + 3, 8, 3, bottom + 3, 9, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 7, 7, 2, bottom + 7, 7, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 3, bottom + 7, 8, 3, bottom + 7, 9, pillarEW, ladderDownDir);
        this.fillAirRotated(world, sbb, 3, bottom + 4, 7, 3, bottom + 6, 7, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 4, 5, 2, bottom + 4, 5, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 2, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 2, bottom + 5, 3, pillarNS, ladderDownDir);
        this.fillAirRotated(world, sbb, 3, bottom + 6, 3, 3, bottom + 8, 3, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 5, bottom + 6, 1, 5, bottom + 6, 2, pillarEW, ladderDownDir);
        this.fillAirRotated(world, sbb, 7, bottom + 8, 3, 7, bottom + 10, 3, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 7, bottom + 7, 1, 7, bottom + 7, 2, pillarEW, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 8, bottom + 7, 3, 9, bottom + 7, 3, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 8, bottom + 8, 5, 9, bottom + 8, 5, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 8, bottom + 9, 7, 9, bottom + 9, 7, pillarNS, ladderDownDir);
        this.fillBlocksRotated(world, sbb, 7, bottom + 9, 8, 7, bottom + 9, 9, pillarEW, ladderDownDir);
        this.fillAirRotated(world, sbb, 2, top, 2, 8, top, 4, ladderUpDir);
        this.fillAirRotated(world, sbb, 2, top, 2, 4, top, 6, ladderUpDir);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 8, bottom + 8, 7, this.method_14934(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    @Override
    public void makeARoof(class_3443 parent, class_6130 list, class_5819 rand) {
        int index = this.method_14923();
        this.tryToFitRoof(list, rand, new IceTowerRoofComponent(index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()));
    }

    @Override
    public void makeABeard(class_3443 parent, class_6130 list, class_5819 rand) {
        int index = this.method_14923();
        IceTowerBeardComponent beard = new IceTowerBeardComponent(index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        list.method_35462((class_3443)beard);
        beard.method_14918(this, list, rand);
    }
}

