/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones;

import java.io.File;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.SkipItemCallback;
import net.pneumono.gravestones.compat.AccessoriesCompat;
import net.pneumono.gravestones.compat.BackwardsCompat;
import net.pneumono.gravestones.compat.TrinketsCompat;
import net.pneumono.gravestones.content.GravestonesApiUsages;
import net.pneumono.gravestones.content.GravestonesCommands;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.gravestones.GravestoneDataSaving;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gravestones
implements ModInitializer {
    public static final String MOD_ID = "gravestones";
    public static final Function<MinecraftServer, File> GRAVESTONES_ROOT = GravestoneDataSaving::getOrCreateGravestonesFolder;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Gravestones");

    public void onInitialize() {
        LOGGER.info("Initializing Gravestones");
        GravestonesConfig.registerGravestonesConfigs();
        ServerLifecycleEvents.SERVER_STARTED.register(BackwardsCompat::convertOldFiles);
        GravestonesRegistry.registerModContent();
        GravestonesApiUsages.register();
        GravestonesCommands.registerCommands();
        if (Gravestones.isModLoaded("spelunkery")) {
            SkipItemCallback.EVENT.register((player, itemStack, slot) -> itemStack.method_31574(class_1802.field_38747));
        }
        boolean usingAccessories = false;
        if (Gravestones.isModLoaded("accessories")) {
            AccessoriesCompat.register();
            usingAccessories = true;
        }
        if (!usingAccessories && Gravestones.isModLoaded("trinkets")) {
            TrinketsCompat.register();
        }
    }

    private static boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    public static class_2960 id(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }
}

