/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.s2c;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.MelodyLoader;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record MelodyListMessage(Map<class_2960, MelodyDescriptor> melodies) implements ImmersivePayload
{
    public MelodyListMessage(class_1657 receiver) {
        this(MelodyListMessage.createMelodiesMap(receiver));
    }

    public MelodyListMessage(class_2540 b) {
        this(MelodyListMessage.readMelodies(b));
    }

    private static Map<class_2960, MelodyDescriptor> createMelodiesMap(class_1657 receiver) {
        HashMap<class_2960, MelodyDescriptor> melodies = new HashMap<class_2960, MelodyDescriptor>();
        for (Map.Entry<class_2960, MelodyLoader.LazyMelody> lazyMelodyEntry : ServerMelodyManager.getDatapackMelodies().entrySet()) {
            melodies.put(lazyMelodyEntry.getKey(), lazyMelodyEntry.getValue().getDescriptor());
        }
        if (Config.getInstance().showOtherPlayersMelodies) {
            melodies.putAll(ServerMelodyManager.getIndex().getMelodies());
        } else {
            ServerMelodyManager.getIndex().getMelodies().forEach((id, desc) -> {
                if (Utils.ownsMelody(id, receiver)) {
                    melodies.put((class_2960)id, (MelodyDescriptor)desc);
                }
            });
        }
        return melodies;
    }

    @Override
    public void encode(class_2540 b) {
        b.writeInt(this.melodies.size());
        for (Map.Entry<class_2960, MelodyDescriptor> entry : this.melodies.entrySet()) {
            b.method_10812(entry.getKey());
            entry.getValue().encodeLite(b);
        }
    }

    private static Map<class_2960, MelodyDescriptor> readMelodies(class_2540 b) {
        int size = b.readInt();
        HashMap<class_2960, MelodyDescriptor> melodies = new HashMap<class_2960, MelodyDescriptor>();
        for (int i = 0; i < size; ++i) {
            melodies.put(b.method_10810(), new MelodyDescriptor(b));
        }
        return melodies;
    }

    @Override
    public void handle(class_1657 e) {
        Common.networkManager.handleMelodyListMessage(this);
    }
}

