/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.compacting;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CompactingUpgradeWrapper
extends UpgradeWrapperBase<CompactingUpgradeWrapper, CompactingUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToCompact = new HashSet<Integer>();

    public CompactingUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((CompactingUpgradeItem)this.upgradeItem).getFilterSlotCount(), stack -> RecipeHelper.getItemCompactingShapes(stack).stream().anyMatch(shape -> shape != RecipeHelper.CompactingShape.NONE));
    }

    @Override
    public long onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        return maxAmount;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, @Nullable TransactionContext ctx) {
        this.compactSlot(inventoryHandler, slot, ctx);
    }

    private void compactSlot(IItemHandlerSimpleInserter inventoryHandler, int slot, @Nullable TransactionContext ctx) {
        class_1799 slotStack = inventoryHandler.getStackInSlot(slot);
        if (slotStack.method_7960() || !this.filterLogic.matchesFilter(slotStack)) {
            return;
        }
        Set<RecipeHelper.CompactingShape> shapes = RecipeHelper.getItemCompactingShapes(slotStack);
        if (((CompactingUpgradeItem)this.upgradeItem).shouldCompactThreeByThree() && (shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE))) {
            this.tryCompacting(inventoryHandler, slotStack, 3, 3, ctx);
        } else if (shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            this.tryCompacting(inventoryHandler, slotStack, 2, 2, ctx);
        }
    }

    private void tryCompacting(IItemHandlerSimpleInserter inventoryHandler, class_1799 stack, int width, int height, @Nullable TransactionContext ctx) {
        int totalCount = width * height;
        RecipeHelper.CompactingResult compactingResult = RecipeHelper.getCompactingResult(stack, width, height);
        if (!compactingResult.getResult().method_7960()) {
            ItemVariant resource = ItemVariant.of((class_1799)stack);
            long extracted = StorageUtil.simulateExtract((Storage)inventoryHandler, (Object)resource, (long)totalCount, (TransactionContext)ctx);
            if (extracted != (long)totalCount) {
                return;
            }
            ItemVariant resultVariant = ItemVariant.of((class_1799)compactingResult.getResult());
            while (extracted == (long)totalCount) {
                List<class_1799> remainingItemsCopy;
                class_1799 resultCopy = compactingResult.getResult().method_7972();
                List<class_1799> list = remainingItemsCopy = compactingResult.getRemainingItems().isEmpty() ? Collections.emptyList() : compactingResult.getRemainingItems().stream().map(class_1799::method_7972).toList();
                if (!this.fitsResultAndRemainingItems(inventoryHandler, remainingItemsCopy, resultCopy, ctx)) break;
                try (Transaction extractContext = Transaction.openNested((TransactionContext)ctx);){
                    InventoryHelper.extractFromInventory(stack.method_46651(totalCount), inventoryHandler, (TransactionContext)extractContext);
                    extractContext.commit();
                }
                try (Transaction insertContext = Transaction.openNested((TransactionContext)ctx);){
                    inventoryHandler.insert(resultVariant, compactingResult.getResult().method_7947(), (TransactionContext)insertContext);
                    InventoryHelper.insertIntoInventory(remainingItemsCopy, (Storage<ItemVariant>)inventoryHandler, (TransactionContext)insertContext);
                    insertContext.commit();
                }
                extracted = StorageUtil.simulateExtract((Storage)inventoryHandler, (Object)resource, (long)totalCount, (TransactionContext)ctx);
            }
        }
    }

    private boolean fitsResultAndRemainingItems(IItemHandlerSimpleInserter inventoryHandler, List<class_1799> remainingItems, class_1799 result, @Nullable TransactionContext ctx) {
        if (!remainingItems.isEmpty()) {
            try (Transaction insertSimulation = Transaction.openNested((TransactionContext)ctx);){
                boolean bl = InventoryHelper.insertIntoInventory(inventoryHandler, ItemVariant.of((class_1799)result), result.method_7947(), (TransactionContext)insertSimulation).method_7960() && InventoryHelper.insertIntoInventory(remainingItems, (Storage<ItemVariant>)inventoryHandler, (TransactionContext)insertSimulation).isEmpty();
                return bl;
            }
        }
        return InventoryHelper.simulateInsertIntoInventory(inventoryHandler, ItemVariant.of((class_1799)result), result.method_7947(), ctx).method_7960();
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldCompactNonUncraftable() {
        return NBTHelper.getBoolean(this.upgrade, "compactNonUncraftable").orElse(false);
    }

    public void setCompactNonUncraftable(boolean shouldCompactNonUncraftable) {
        NBTHelper.setBoolean(this.upgrade, "compactNonUncraftable", shouldCompactNonUncraftable);
        this.save();
    }

    @Override
    public void onSlotChange(SlottedStackStorage inventoryHandler, int slot) {
        if (this.shouldWorkInGUI()) {
            this.slotsToCompact.add(slot);
        }
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean(this.upgrade, "shouldWorkInGUI", shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean(this.upgrade, "shouldWorkInGUI").orElse(false);
    }

    @Override
    public void tick(@Nullable class_1297 entity, class_1937 world, class_2338 pos) {
        if (this.slotsToCompact.isEmpty()) {
            return;
        }
        for (int slot : this.slotsToCompact) {
            Transaction ctx = Transaction.openOuter();
            try {
                this.compactSlot(this.storageWrapper.getInventoryHandler(), slot, (TransactionContext)ctx);
                ctx.commit();
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
        this.slotsToCompact.clear();
    }
}

