/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.math.Float2;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderreich.gui.overlay.RenderContext;
import de.ambertation.wunderreich.gui.overlay.SolidPrimitives;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
final class BlockInfo {
    public final Float3 pos;
    public final double camDistSquare;
    public final float deflate;
    public final int color;
    public final float alpha;
    public final int outlineColor;
    public final float outlineAlpha;

    BlockInfo(Float3 pos, double camDistSquare, float deflate, int color, float alpha, int outlineColor, float outlineAlpha) {
        this.pos = pos;
        this.camDistSquare = camDistSquare;
        this.deflate = deflate;
        this.color = color;
        this.alpha = alpha;
        this.outlineColor = outlineColor;
        this.outlineAlpha = outlineAlpha;
    }

    public static BlockInfo withCamPos(Float3 pos, Float3 camPos, float deflate, int color, float alpha, int outlineColor, float outlineAlpha) {
        return new BlockInfo(pos, pos.sub(camPos).lengthSquare(), deflate, color, alpha, outlineColor, outlineAlpha);
    }

    static void renderTransparentPositions(RenderContext ctx, List<BlockInfo> positions, Float3 refPlanePosition) {
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        BlockInfo.drawAll(ctx, tesselator, positions);
        BlockInfo.drawRefPlane(ctx, tesselator, refPlanePosition);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        BlockInfo.drawAll(ctx, tesselator, positions);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
    }

    static void drawAll(RenderContext ctx, class_289 tesselator, List<BlockInfo> positions) {
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_29337);
        for (BlockInfo nfo : positions) {
            SolidPrimitives.renderSingleBlock(ctx, bufferBuilder, nfo);
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    static void drawRefPlane(RenderContext ctx, class_289 tesselator, Float3 refPlanePosition) {
        if (refPlanePosition != null) {
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_29337);
            SolidPrimitives.renderQuadXZ(ctx, bufferBuilder, refPlanePosition, Float2.IDENTITY, -1, 0.2f);
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
    }
}

