/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.overlay;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Quaternion;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.interfaces.Transformable;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderreich.gui.overlay.BlockInfo;
import de.ambertation.wunderreich.gui.overlay.LinePrimitives;
import de.ambertation.wunderreich.gui.overlay.OverlayRenderer;
import de.ambertation.wunderreich.gui.overlay.RenderContext;
import de.ambertation.wunderreich.gui.overlay.TextRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformWidget {
    @NotNull
    private Transformable source;
    @Nullable
    private Transform changedTransform;
    @Nullable
    private Bounds.Interpolate hoveredCorner;
    @Nullable
    private Bounds.Interpolate selectedCorner;
    @NotNull
    private Float3 cursorPos = Float3.ZERO;
    private static final String SELECTED_CORNER_STATE = "s";
    private class_2487 dataTag;

    public TransformWidget(@NotNull Transformable source) {
        this.source = source;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(@NotNull RenderContext ctx, float phase) {
        Float3[] corners = this.getCornersAndCenterInWorldSpace();
        if (this.selectedCorner != null) {
            LinePrimitives.renderCorners(ctx, corners, -42652, 1.0f);
            Float3[] corners2 = new Float3[corners.length];
            for (int i = 0; i < corners.length; ++i) {
                corners2[i] = this.source.getLocalTransform().asInvertedMatrix().mul(this.source.getParentTransformMatrix().inverted()).transform(corners[i]);
            }
            LinePrimitives.renderCorners(ctx, corners2, -1, 1.0f);
            Float3 corner = corners[this.selectedCorner.idx];
            TextRenderer.render(ctx, this.cursorPos.add(0.0, -0.2, 0.0), this.source.getLocalTransform(), ColorHelper.WHITE);
            TextRenderer.render(ctx, this.cursorPos.add(0.0, -0.4, 0.0), this.changedTransform, ColorHelper.WHITE);
            TextRenderer.render(ctx, this.cursorPos.add(0.0, 0.2, 0.0), corners[this.selectedCorner.opposite().idx], ColorHelper.WHITE);
            OverlayRenderer.INSTANCE.positions.add(BlockInfo.withCamPos(corner, ctx.camToWorldSpace, 0.1f, ColorHelper.blendColors((float)phase, (int)-42652, (int)-6324), 0.8f, -42652, phase));
            LinePrimitives.renderSingleBlock(ctx, corner, -0.05f, -42652, 1.0f);
            TextRenderer.render(ctx, corner, -42652);
        } else {
            LinePrimitives.renderCorners(ctx, corners, -13260801, 1.0f);
            for (int idx = 0; idx < corners.length; ++idx) {
                Float3 corner = corners[idx];
                if (this.hoveredCorner != null && this.hoveredCorner.idx == idx) {
                    OverlayRenderer.INSTANCE.positions.add(BlockInfo.withCamPos(corner, ctx.camToWorldSpace, 0.1f, -42652, 0.5f, -42652, 0.8f));
                    LinePrimitives.renderSingleBlock(ctx, corner, 0.1f, -42652, 1.0f);
                    TextRenderer.render(ctx, corner, -42652);
                    continue;
                }
                OverlayRenderer.INSTANCE.positions.add(BlockInfo.withCamPos(corner, ctx.camToWorldSpace, 0.1f, ColorHelper.blendColors((float)phase, (int)-13260801, (int)-6324), 0.8f, -6324, phase));
                LinePrimitives.renderSingleBlock(ctx, corner, 0.1f, ColorHelper.blendColors((float)phase, (int)-13260801, (int)-6324), 1.0f);
            }
        }
    }

    public Transform getChangedTransform() {
        if (this.changedTransform == null) {
            return this.source.getLocalTransform();
        }
        return this.changedTransform;
    }

    private void updateChangedTransform(Float3 selectedCornerPos) {
        if (this.selectedCorner != null && selectedCornerPos != null) {
            if (this.selectedCorner.idx == Bounds.Interpolate.CENTER.idx) {
                Matrix4 toLocal = this.source.getLocalTransform().asInvertedMatrix().mul(this.source.getParentTransformMatrix().inverted());
                Float3 oldCenter = toLocal.transform(this.source.getCornerInWorldSpace(Bounds.Interpolate.CENTER, false));
                Float3 newCenter = toLocal.transform(selectedCornerPos);
                Float3 cc = newCenter.sub(oldCenter);
                cc = this.source.getLocalTransform().transform(cc);
                this.changedTransform = Transform.of((Float3)cc, (Float3)this.source.getLocalTransform().size, (Quaternion)this.source.getLocalTransform().rotation);
            } else if (this.source.isOperation()) {
                Matrix4 toLocal = this.source.getLocalTransform().asInvertedMatrix().mul(this.source.getParentTransformMatrix().inverted());
                Float3 A = toLocal.transform(selectedCornerPos);
                Float3 B = toLocal.transform(this.source.getCornerInWorldSpace(this.selectedCorner.opposite(), false));
                Float3 oldCenter = toLocal.transform(this.source.getCornerInWorldSpace(Bounds.Interpolate.CENTER, false));
                Float3 oldA = toLocal.transform(this.source.getCornerInWorldSpace(this.selectedCorner, false));
                Float3 newSize = A.sub(B);
                Float3 oldSize = oldA.sub(B);
                Float3 tSize = newSize.div(oldSize);
                Float3 newCenter = B.add(newSize.div(2.0));
                Float3 cc = newCenter.sub(oldCenter.mul(tSize));
                cc = this.source.getLocalTransform().transform(cc);
                tSize = this.source.getLocalTransform().size.mul(tSize);
                this.changedTransform = Transform.of((Float3)cc, (Float3)tSize, (Quaternion)this.source.getLocalTransform().rotation);
            } else {
                Float3 A = this.source.getParentTransformMatrix().inverted().transform(selectedCornerPos);
                Float3 B = this.source.getParentTransformMatrix().inverted().transform(this.source.getCornerInWorldSpace(this.selectedCorner.opposite(), false));
                Float3 newSize = A.sub(B);
                Float3 newCenter = B.add(newSize.div(2.0));
                newSize = newSize.unRotate(this.source.getLocalTransform().rotation).abs();
                this.changedTransform = Transform.of((Float3)newCenter, (Float3)newSize, (Quaternion)this.source.getLocalTransform().rotation);
            }
            this.source.setLocalTransform(this.changedTransform);
        }
    }

    private Float3[] getCornersAndCenterInWorldSpace() {
        if (this.selectedCorner != null && this.cursorPos != null && this.changedTransform != null) {
            return this.source.getCornersAndCenterInWorldSpace(false, this.changedTransform);
        }
        return this.source.getCornersAndCenterInWorldSpace(false);
    }

    public boolean click() {
        if (this.selectedCorner != null) {
            this.selectedCorner = null;
            this.writeState();
            return true;
        }
        if (this.hoveredCorner != null) {
            this.selectedCorner = this.hoveredCorner;
            this.writeState();
            return true;
        }
        return false;
    }

    public boolean cursorTick(Float3 mousePos) {
        if (this.hasSelection()) {
            this.cursorPos = mousePos;
            this.updateChangedTransform(this.cursorPos);
        }
        boolean res = this.cursorOver(mousePos);
        return res;
    }

    private boolean cursorOver(Float3 mousePos) {
        Float3[] corners = this.getCornersAndCenterInWorldSpace();
        for (int idx = 0; idx < corners.length; ++idx) {
            if (!(corners[idx].sub(mousePos).length() <= 0.5)) continue;
            this.hoveredCorner = Bounds.Interpolate.CORNERS_AND_CENTER[idx];
            return true;
        }
        this.hoveredCorner = null;
        return false;
    }

    @ApiStatus.Internal
    public void setDataTag(class_2487 c) {
        this.dataTag = c;
    }

    public void writeState() {
        if (this.dataTag == null) {
            return;
        }
        this.dataTag.method_10567(SELECTED_CORNER_STATE, this.selectedCorner == null ? (byte)-1 : this.selectedCorner.idx);
    }

    public void readState() {
        if (this.dataTag == null) {
            return;
        }
        if (this.dataTag.method_10545(SELECTED_CORNER_STATE)) {
            byte idx = this.dataTag.method_10571(SELECTED_CORNER_STATE);
            this.selectedCorner = idx < 0 ? null : Bounds.Interpolate.CORNERS_AND_CENTER[idx];
        }
    }

    public boolean hasSelection() {
        return this.selectedCorner != null;
    }

    public boolean hasHovered() {
        return this.hoveredCorner != null;
    }

    @Nullable
    public Float3 hoveredCornerPos() {
        if (this.hoveredCorner != null) {
            return this.source.getCornerInWorldSpace(this.hoveredCorner, false);
        }
        return null;
    }
}

