/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.network;

import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.blocks.WunderKisteBlock;
import de.ambertation.wunderreich.network.ServerBoundPacketHandler;
import de.ambertation.wunderreich.utils.LiveBlockManager;
import de.ambertation.wunderreich.utils.WunderKisteDomain;
import de.ambertation.wunderreich.utils.WunderKisteServerExtension;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AddRemoveWunderKisteMessage
extends ServerBoundPacketHandler<Content> {
    public static final AddRemoveWunderKisteMessage INSTANCE = ServerBoundPacketHandler.register("wunder_kiste", new AddRemoveWunderKisteMessage());

    protected AddRemoveWunderKisteMessage() {
    }

    public static void addedBox(class_3218 level, class_2338 pos) {
        LiveBlockManager.LiveBlock lb = new LiveBlockManager.LiveBlock(pos, (class_1937)level);
        class_2680 state = level.method_8320(pos);
        boolean wasManaged = WunderKisteBlock.getLiveBlockManager().contains(lb);
        WunderKisteDomain domain = WunderKisteServerExtension.getDomain(state);
        boolean result = WunderKisteBlock.getLiveBlockManager().add(lb);
        Wunderreich.LOGGER.info("Adding WunderKiste at " + pos + " (wasManaged: " + wasManaged + ", domain: " + domain + ", didAdd:" + result + ")");
    }

    public static void removedBox(class_3218 level, class_2338 pos) {
        LiveBlockManager.LiveBlock lb = new LiveBlockManager.LiveBlock(pos, (class_1937)level);
        boolean wasManaged = WunderKisteBlock.getLiveBlockManager().contains(lb);
        boolean result = WunderKisteBlock.getLiveBlockManager().remove(lb);
        Wunderreich.LOGGER.info("Removing WunderKiste at " + pos + " (wasManaged: " + wasManaged + ", didRemove:" + result + ")");
    }

    public void send(boolean didAdd, class_2338 pos) {
        this.sendToServer(new Content(didAdd, pos, null));
    }

    @Override
    protected void serializeOnClient(class_2540 buf, Content content) {
        buf.writeBoolean(content.didAdd);
        buf.method_10807(content.pos);
    }

    @Override
    protected Content deserializeOnServer(class_2540 buf, class_3222 player, PacketSender responseSender) {
        boolean didAdd = buf.readBoolean();
        class_2338 pos = buf.method_10811();
        class_3218 level = player.method_51469();
        return new Content(didAdd, pos, level);
    }

    @Override
    protected void processOnGameThread(MinecraftServer server, class_3222 player, Content content) {
        if (content.didAdd) {
            AddRemoveWunderKisteMessage.addedBox(content.level, content.pos);
        } else {
            AddRemoveWunderKisteMessage.removedBox(content.level, content.pos);
        }
    }

    static {
        WunderKisteBlock.getLiveBlockManager().onChangeAt(WunderKisteBlock::updateNeighbours);
    }

    protected record Content(boolean didAdd, class_2338 pos, class_3218 level) {
    }
}

