/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils;

import de.ambertation.wunderlib.math.Float3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class RandomList<T>
implements Iterable<Entry<T>> {
    private final ArrayList<Entry<T>> list;
    private float weightSum;

    public RandomList() {
        this(9);
    }

    public RandomList(int capacity) {
        this.list = new ArrayList(capacity);
        this.weightSum = 0.0f;
    }

    public static float random() {
        return (float)Math.random();
    }

    @Override
    @NotNull
    public Iterator<Entry<T>> iterator() {
        return this.list.iterator();
    }

    public void add(T value, float weight) {
        Entry<T> e = new Entry<T>(value, weight);
        this.list.add(e);
        this.weightSum += e.weight;
    }

    public T get(int idx) {
        Entry<T> e = this.list.get(idx);
        if (e == null) {
            return null;
        }
        return e.value;
    }

    public int getRandomIndex() {
        return this.getRandomIndex(RandomList::random);
    }

    public int getRandomIndex(Supplier<Float> rnd) {
        int CYCLES = 3;
        int count = this.list.size();
        float sum = 0.0f;
        float r = rnd.get().floatValue();
        float random = r * this.weightSum * 3.0f;
        for (int i = 0; i < count * 3; ++i) {
            Entry<T> e = this.list.get(i % count);
            if (!(random <= (sum += e.weight))) continue;
            return i % count;
        }
        return this.list.size() - 1;
    }

    public int getRandomIndexAt(Float3 pos, Function<Float3, Float> rnd) {
        int CYCLES = 3;
        int count = this.list.size();
        float sum = 0.0f;
        float r = rnd.apply(pos).floatValue();
        float random = r * this.weightSum * 3.0f;
        for (int i = 0; i < count * 3; ++i) {
            Entry<T> e = this.list.get(i % count);
            if (!(random <= (sum += e.weight))) continue;
            return i % count;
        }
        return this.list.size() - 1;
    }

    public T getRandom() {
        return this.getRandom(RandomList::random);
    }

    public T getRandom(Supplier<Float> rnd) {
        int idx = this.getRandomIndex(rnd);
        if (idx < 0 || idx >= this.list.size()) {
            return null;
        }
        return this.get(idx);
    }

    public T getRandomAt(Float3 pos, Function<Float3, Float> rnd) {
        int idx = this.getRandomIndexAt(pos, rnd);
        if (idx < 0 || idx >= this.list.size()) {
            return null;
        }
        return this.get(idx);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.toString();
    }

    public static class Entry<T> {
        public final T value;
        public final float weight;

        Entry(T value, float weight) {
            this.value = value;
            this.weight = weight;
        }

        public String toString() {
            return "Entry{value=" + this.value + ", weight=" + this.weight + "}";
        }
    }
}

