/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.StatueBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.MultiLineEditBoxWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;

public class PlayerSuggestionBoxWidget
extends MultiLineEditBoxWidget {
    private static final Map<UUID, String> USERNAME_CACHE = new HashMap<UUID, String>();
    private static final class_2561 EMPTY_SEARCH = class_2561.method_43471((String)"gui.supplementaries.present.send").method_27692(class_124.field_1080).method_27692(class_124.field_1056);
    private final List<SimplePlayerEntry> allPlayers = new ArrayList<SimplePlayerEntry>();
    private final List<SimplePlayerEntry> filtered = new ArrayList<SimplePlayerEntry>();
    private SimplePlayerEntry selectedPlayer = null;
    @Nullable
    private String suggestion;
    private String fullSuggestion = "";

    public static void setUsernameCache(Map<UUID, String> usernameCache) {
        USERNAME_CACHE.clear();
        USERNAME_CACHE.putAll(usernameCache);
    }

    public PlayerSuggestionBoxWidget(class_310 mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height);
        Collection onlinePlayers = mc.field_1724.field_3944.method_31363();
        for (UUID uUID : onlinePlayers) {
            class_640 playerinfo = mc.field_1724.field_3944.method_2871(uUID);
            if (playerinfo == null) continue;
            this.allPlayers.add(new SimplePlayerEntry(playerinfo));
        }
        for (Map.Entry entry : USERNAME_CACHE.entrySet()) {
            if (onlinePlayers.contains(entry.getKey())) continue;
            this.allPlayers.add(new SimplePlayerEntry((UUID)entry.getKey(), (String)entry.getValue()));
        }
        this.filtered.addAll(this.allPlayers);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.field_22764) {
            if (this.canConsumeInput() && this.suggestion != null) {
                int x = this.method_46426();
                MultiLineEditBoxWidget.DisplayCache cache = this.getDisplayCache();
                if (cache.lines.length > 0) {
                    x += this.font.method_1727(cache.lines[0].contents);
                }
                graphics.method_51433(this.font, this.suggestion, x, this.method_46427(), -8355712, false);
            }
            if (this.getText().isEmpty()) {
                graphics.method_51439(this.font, EMPTY_SEARCH, this.method_46426(), this.method_46427(), 0, false);
            } else if (this.selectedPlayer != null) {
                this.selectedPlayer.render(graphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, partialTicks);
            }
        }
    }

    @Override
    public boolean method_25404(int key, int alt, int ctrl) {
        if (key == 32) {
            return true;
        }
        if (key == 258 && this.canConsumeInput()) {
            if (!this.fullSuggestion.isEmpty()) {
                this.setText(this.fullSuggestion);
                this.moveCursorToEnd();
                this.clearDisplayCache();
            }
            return true;
        }
        return super.method_25404(key, alt, ctrl);
    }

    @Override
    public void onValueChanged() {
        this.updateFilteredEntries();
        String newValue = this.getText();
        this.selectedPlayer = null;
        String suggestion = "";
        this.fullSuggestion = "";
        if (!newValue.isEmpty()) {
            for (SimplePlayerEntry entry : this.filtered) {
                String name = entry.getName();
                if (this.fullSuggestion.isEmpty()) {
                    this.fullSuggestion = name;
                    suggestion = name.substring(newValue.length());
                }
                if (!name.equalsIgnoreCase(newValue)) continue;
                this.selectedPlayer = entry;
                break;
            }
        }
        this.setSuggestion(suggestion);
    }

    private void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public void setState(boolean hasItem, boolean packed) {
        super.setState(hasItem, packed);
        this.filtered.clear();
        if (!packed && hasItem) {
            this.method_25365(true);
            this.filtered.addAll(this.allPlayers);
        }
    }

    private void updateFilteredEntries() {
        String filter = this.getText();
        filter = filter == null ? "" : filter.toLowerCase(Locale.ROOT);
        this.filtered.clear();
        String finalFilter = filter;
        this.filtered.addAll(this.allPlayers.stream().filter(s -> s.getName().toLowerCase(Locale.ROOT).startsWith(finalFilter)).toList());
    }

    public void addPlayer(class_640 info) {
        this.allPlayers.removeIf(simplePlayerEntry -> simplePlayerEntry.getId().equals(info.method_2966().getId()));
        this.allPlayers.add(new SimplePlayerEntry(info));
        this.updateFilteredEntries();
        this.onValueChanged();
    }

    public void removePlayer(UUID id) {
        for (SimplePlayerEntry simplePlayerEntry : this.allPlayers) {
            if (!simplePlayerEntry.getId().equals(id)) continue;
            simplePlayerEntry.setOnline(false);
            return;
        }
    }

    public static class SimplePlayerEntry {
        private static final int SKIN_SIZE = 8;
        private final Supplier<class_2960> skinGetter;
        private GameProfile profile;
        private boolean isOnline;

        public SimplePlayerEntry(class_640 playerInfo) {
            this.profile = playerInfo.method_2966();
            this.skinGetter = () -> ((class_640)playerInfo).method_2968();
            this.isOnline = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimplePlayerEntry(UUID id, String lastName) {
            GameProfile profile = new GameProfile(id, lastName);
            this.skinGetter = () -> StatueBlockTileRenderer.getPlayerSkin(this.profile);
            if (!profile.isComplete() || !profile.getProperties().containsKey((Object)"textures")) {
                SimplePlayerEntry simplePlayerEntry = this;
                synchronized (simplePlayerEntry) {
                    this.profile = profile;
                }
                class_2631.method_11335((GameProfile)this.profile, gameProfile -> {
                    this.profile = gameProfile;
                });
            }
            this.isOnline = false;
        }

        public void setOnline(boolean online) {
            this.isOnline = online;
        }

        public UUID getId() {
            return this.profile.getId();
        }

        public String getName() {
            return this.profile.getName();
        }

        public void render(class_332 graphics, int x, int y, int width, int height, float pPartialTicks) {
            int i = x + width - 4;
            float c = this.isOnline ? 1.0f : 0.5f;
            RenderSystem.setShaderColor((float)1.0f, (float)c, (float)c, (float)1.0f);
            class_2960 resourceLocation = this.skinGetter.get();
            graphics.method_25293(resourceLocation, i, y, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.method_25293(resourceLocation, i, y, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

