/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.mehvahdjukaar.moonlight.api.block.DynamicRenderedItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBuntingBlock;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class BuntingBlockTile
extends DynamicRenderedItemDisplayTile {
    public static final ModelDataKey<class_1767> NORTH_BUNTING = new ModelDataKey(class_1767.class);
    public static final ModelDataKey<class_1767> SOUTH_BUNTING = new ModelDataKey(class_1767.class);
    public static final ModelDataKey<class_1767> EAST_BUNTING = new ModelDataKey(class_1767.class);
    public static final ModelDataKey<class_1767> WEST_BUNTING = new ModelDataKey(class_1767.class);
    private final Map<class_2350, class_1767> buntings = new EnumMap<class_2350, class_1767>(class_2350.class);

    public BuntingBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BUNTING_TILE.get(), pos, state, 4);
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867);
    }

    @Nullable
    public class_1767 getBunting(class_2350 direction) {
        if (this.isStructureRotated().booleanValue()) {
            direction = direction.method_10170();
        }
        return this.buntings.get(direction);
    }

    public void setBunting(class_2350 direction, @Nullable class_1767 color) {
        if (this.isStructureRotated().booleanValue()) {
            direction = direction.method_10160();
        }
        if (color == null) {
            this.buntings.remove(direction);
        } else {
            this.buntings.put(direction, color);
        }
    }

    @NotNull
    private Boolean isStructureRotated() {
        return (Boolean)this.method_11010().method_11654((class_2769)RopeBuntingBlock.FLIP_TILE);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        class_2680 state = this.method_11010();
    }

    public void updateClientVisualsOnLoad() {
        this.buntings.clear();
        for (class_2350 d : class_2350.class_2353.field_11062) {
            class_1767 color;
            class_1799 stack = this.method_5438(d.method_10161());
            if (!(stack.method_7909() instanceof BuntingItem) || (color = BuntingItem.getColor(stack)) == null) continue;
            this.setBunting(d, color);
        }
        this.requestModelReload();
    }

    public void updateTileOnInventoryChanged() {
        class_2680 state = this.method_11010();
        if (this.method_5442()) {
            this.field_11863.method_8501(this.field_11867, RopeBuntingBlock.toRope(state));
        } else {
            class_2680 state2 = state;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2754<ModBlockProperties.Bunting> prop = RopeBuntingBlock.HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir);
                ModBlockProperties.Bunting old = (ModBlockProperties.Bunting)((Object)state2.method_11654(prop));
                boolean isEmpty = this.method_5438(dir.method_10161()).method_7960();
                state2 = (class_2680)state2.method_11657(prop, (Comparable)((Object)(isEmpty ? (old == ModBlockProperties.Bunting.NONE ? ModBlockProperties.Bunting.NONE : ModBlockProperties.Bunting.ROPE) : ModBlockProperties.Bunting.BUNTING)));
            }
            if (state != state2) {
                this.field_11863.method_8501(this.field_11867, state2);
            }
        }
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public boolean isNeverFancy() {
        return ClientConfigs.Blocks.FAST_BUNTINGS.get();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(NORTH_BUNTING, (Object)this.getBunting(class_2350.field_11043));
        builder.with(SOUTH_BUNTING, (Object)this.getBunting(class_2350.field_11035));
        builder.with(EAST_BUNTING, (Object)this.getBunting(class_2350.field_11034));
        builder.with(WEST_BUNTING, (Object)this.getBunting(class_2350.field_11039));
    }

    protected boolean getFancyDistance(class_243 cameraPos) {
        LOD lod = new LOD(cameraPos, this.method_11016());
        return lod.isNear();
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"item.supplementaries.bunting");
    }

    public boolean method_5437(int index, class_1799 stack) {
        return stack.method_7909() instanceof BuntingItem && this.method_5438(index).method_7960() && RopeBuntingBlock.canSupportBunting(this.method_11010(), index);
    }

    public boolean method_49104(class_1263 container, int i, class_1799 itemStack) {
        return false;
    }

    public boolean method_17489(class_1657 player) {
        return false;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return null;
    }

    public boolean rotateBuntings(class_2680 state, class_2470 rotation) {
        HashMap<class_2350, class_1799> newMap = new HashMap<class_2350, class_1799>();
        for (class_2350 dir2 : class_2350.class_2353.field_11062) {
            class_1799 stack2 = this.method_5438(dir2.method_10161());
            if (stack2.method_7960()) continue;
            class_2350 newDir = rotation.method_10503(dir2);
            if (RopeBuntingBlock.canSupportBunting(state, newDir.method_10161())) {
                newMap.put(newDir, stack2);
                continue;
            }
            return false;
        }
        if (!newMap.isEmpty()) {
            this.method_5448();
            newMap.forEach((dir, stack) -> this.method_5447(dir.method_10161(), (class_1799)stack));
            return true;
        }
        return false;
    }
}

