/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.mehvahdjukaar.moonlight.api.client.anim.PendulumAnimation;
import net.mehvahdjukaar.moonlight.api.client.anim.SwingAnimation;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3962;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5712;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import net.minecraft.class_8168;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HatStandEntity
extends class_1309 {
    private static final class_2379 DEFAULT_HEAD_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    public static final class_2940<Byte> DATA_CLIENT_FLAGS = class_2945.method_12791(HatStandEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<class_2379> DATA_HEAD_POSE = class_2945.method_12791(HatStandEntity.class, (class_2941)class_2943.field_13316);
    public static final class_2940<OptionalInt> FACING_TARGET = class_2945.method_12791(HatStandEntity.class, (class_2941)class_2943.field_17910);
    private final class_2371<class_1799> helmet = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private boolean invisible;
    public long lastHit;
    private boolean slotsDisabled = false;
    private class_2379 headPose;
    public final SwingAnimation swingAnimation;
    public final class_7094 skibidiAnimation;
    private final int tickOffset;
    private int skibidiAnimDur = 0;
    @Nullable
    private Float originalYRot = null;
    @Nullable
    private class_1297 target = null;
    public class_243 jumpScareAngles = class_243.field_1353;

    public HatStandEntity(class_1299<? extends HatStandEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.headPose = DEFAULT_HEAD_POSE;
        this.method_49477(0.0f);
        if (PlatHelper.getPhysicalSide().isClient()) {
            this.swingAnimation = new PendulumAnimation(ClientConfigs.Blocks.HAT_STAND_CONFIG, this::getRotationAxis);
            this.skibidiAnimation = new class_7094();
        } else {
            this.swingAnimation = null;
            this.skibidiAnimation = null;
        }
        this.tickOffset = this.field_5974.method_43048(100);
        this.originalYRot = null;
    }

    public class_2596<class_2602> method_18002() {
        if (PlatHelper.getPlatform().isForge()) {
            return PlatHelper.getEntitySpawnPacket((class_1297)this);
        }
        return super.method_18002();
    }

    private Vector3f getRotationAxis() {
        return this.method_5828(0.0f).method_46409();
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_CLIENT_FLAGS, (Object)0);
        this.field_6011.method_12784(FACING_TARGET, (Object)OptionalInt.empty());
        this.field_6011.method_12784(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
    }

    public Iterable<class_1799> method_5661() {
        return this.helmet;
    }

    public Iterable<class_1799> method_5877() {
        return List.of();
    }

    public class_1799 method_6118(class_1304 slot) {
        if (Objects.requireNonNull(slot) == class_1304.field_6169) {
            return (class_1799)this.helmet.get(0);
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        if (slot == class_1304.field_6169) {
            this.method_6116(slot, (class_1799)this.helmet.set(0, (Object)stack), stack);
        }
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = class_1308.method_32326((class_1799)stack);
        return this.method_6118(equipmentSlot).method_7960();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_1799 stack = (class_1799)this.helmet.get(0);
        if (!stack.method_7960()) {
            compound.method_10566("Helmet", (class_2520)stack.method_7953(new class_2487()));
        }
        compound.method_10556("Invisible", this.method_5767());
        compound.method_10556("NoBasePlate", this.isNoBasePlate());
        compound.method_10556("DisabledSlots", this.slotsDisabled);
        class_2499 compoundTag = new class_2499();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundTag = this.headPose.method_10255();
        }
        compound.method_10566("HeadPose", (class_2520)compoundTag);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Helmet")) {
            this.helmet.set(0, (Object)class_1799.method_7915((class_2487)compound.method_10562("Helmet")));
        }
        this.method_5648(compound.method_10577("Invisible"));
        this.setNoBasePlate(compound.method_10577("NoBasePlate"));
        this.slotsDisabled = compound.method_10577("DisabledSlots");
        class_2499 listTag = compound.method_10554("HeadPose", 5);
        this.setHeadPose(listTag.isEmpty() ? DEFAULT_HEAD_POSE : new class_2379(listTag));
    }

    public boolean method_5810() {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        class_1937 level = this.method_37908();
        if (level.field_9236) {
            class_1297 e;
            this.swingAnimation.tick(!level.method_8316(this.method_23312()).method_15769());
            List list = level.method_8335((class_1297)this, this.method_5829());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !this.swingAnimation.hitByEntity(e = (class_1297)iterator.next())) {
            }
            float currentRot = this.method_36454();
            if (this.target != null && this.skibidiAnimation.method_41327()) {
                class_243 distanceVec = this.target.method_19538().method_1020(this.method_19538()).method_1029();
                float targetYRot = distanceVec.method_46409().angleSigned((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)) * 57.295776f - 90.0f;
                float difference = class_3532.method_15381((float)currentRot, (float)targetYRot);
                this.method_36456(class_3532.method_16439((float)0.5f, (float)currentRot, (float)(currentRot + difference)));
            } else if (this.originalYRot != null && currentRot != this.originalYRot.floatValue()) {
                this.method_36456(this.originalYRot.floatValue());
                this.originalYRot = null;
            }
        } else if (this.skibidiAnimDur != 0) {
            --this.skibidiAnimDur;
            if (this.skibidiAnimDur == 0) {
                this.method_5841().method_12778(FACING_TARGET, (Object)OptionalInt.empty());
                this.method_18380(class_4050.field_18076);
            }
        } else if (this.method_18376() == class_4050.field_18076 && (this.field_6012 + this.tickOffset) % 100 == 0 && this.field_5974.method_43057() < 0.2f) {
            this.setSkibidiIfInCauldron(null);
        }
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        super.method_6070();
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (!itemStack.method_31574(class_1802.field_8448)) {
            boolean isClientSide = player.method_37908().field_9236;
            if (player.method_21823()) {
                if (isClientSide) {
                    this.swingAnimation.addImpulse(0.001f);
                    this.swingAnimation.addPositiveImpulse(1.2f);
                }
                return class_1269.method_29236((boolean)isClientSide);
            }
            if (player.method_7325()) {
                return class_1269.field_5812;
            }
            if (isClientSide) {
                return class_1269.field_21466;
            }
            if (!this.slotsDisabled) {
                if (itemStack.method_7960()) {
                    class_1304 targetSlot = class_1304.field_6169;
                    if (this.method_6084(targetSlot) && this.swapItem(player, targetSlot, itemStack, hand)) {
                        return class_1269.field_5812;
                    }
                } else {
                    class_1304 equipmentSlot = class_1308.method_32326((class_1799)itemStack);
                    if (CommonConfigs.Building.HAT_STAND_UNRESTRICTED.get().booleanValue()) {
                        equipmentSlot = class_1304.field_6169;
                    }
                    if (equipmentSlot != class_1304.field_6169) {
                        return class_1269.field_5814;
                    }
                    if (this.swapItem(player, equipmentSlot, itemStack, hand)) {
                        return class_1269.field_5812;
                    }
                }
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private boolean swapItem(class_1657 player, class_1304 slot, class_1799 stack, class_1268 hand) {
        class_1799 itemStack = this.method_6118(slot);
        if (player.method_31549().field_7477 && itemStack.method_7960() && !stack.method_7960()) {
            this.method_5673(slot, stack.method_46651(1));
            return true;
        }
        if (!stack.method_7960() && stack.method_7947() > 1) {
            if (!itemStack.method_7960()) {
                return false;
            }
            this.method_5673(slot, stack.method_7971(1));
            return true;
        }
        this.method_5673(slot, stack);
        player.method_6122(hand, itemStack);
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236 && source.method_5526() instanceof class_1676) {
            this.swingAnimation.hitByEntity(source.method_5526());
        }
        if (!this.method_37908().field_9236 && !this.method_31481()) {
            if (source.method_48789(class_8103.field_42242)) {
                this.dismantle(source);
                return false;
            }
            if (!this.method_5679(source) && !this.invisible) {
                if (source.method_48789(class_8103.field_42249)) {
                    this.dismantle(source);
                    return false;
                }
                if (source.method_48789(class_8103.field_42258)) {
                    if (this.method_5809()) {
                        this.causeDamage(source, 0.15f);
                    } else {
                        this.method_5639(5);
                    }
                    return false;
                }
                if (source.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f) {
                    this.causeDamage(source, 4.0f);
                    return false;
                }
                boolean isDirectArrow = source.method_5526() instanceof class_1665;
                boolean isPierceArrow = isDirectArrow && ((class_1665)source.method_5526()).method_7447() > 0;
                boolean bl3 = "player".equals(source.method_5525());
                if (!bl3 && !isDirectArrow) {
                    return false;
                }
                class_1297 sourceEntity = source.method_5529();
                if (sourceEntity instanceof class_1657) {
                    class_1657 player = (class_1657)sourceEntity;
                    if (!player.method_31549().field_7476) {
                        return false;
                    }
                }
                if (source.method_5530()) {
                    this.dismantle(null);
                    return isPierceArrow;
                }
                long l = this.method_37908().method_8510();
                if (l - this.lastHit > 5L && !isDirectArrow) {
                    this.method_37908().method_8421((class_1297)this, (byte)32);
                    this.method_32875(class_5712.field_28736, source.method_5529());
                    this.lastHit = l;
                } else {
                    this.dismantle(source);
                }
                return true;
            }
        }
        return false;
    }

    public void method_5711(byte id) {
        if (id == 32) {
            if (this.method_37908().field_9236) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14897, this.method_5634(), 0.3f, 1.0f, false);
                this.lastHit = this.method_37908().method_8510();
            }
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_5640(double distance) {
        double d = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d) || d == 0.0) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    private void showBreakingParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void causeDamage(class_1282 damageSource, float amount) {
        float f = this.method_6032();
        if ((f -= amount) <= 0.5f) {
            this.dismantle(damageSource);
        } else {
            this.method_6033(f);
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
        }
    }

    protected float method_6031(float yRot, float animStep) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * (this.method_6109() ? 0.5f : 0.7f);
    }

    public void method_5636(float pOffset) {
        float r;
        this.field_5982 = r = this.method_36454();
        this.field_6220 = r;
        this.field_6283 = r;
    }

    public void method_5847(float pRotation) {
        float r;
        this.field_5982 = r = this.method_36454();
        this.field_6259 = r;
        this.field_6241 = r;
    }

    public void method_5773() {
        super.method_5773();
        class_2379 rotations = (class_2379)this.field_6011.method_12789(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
    }

    protected void method_6027() {
        this.method_5648(this.invisible);
    }

    public void method_5648(boolean invisible) {
        this.invisible = invisible;
        super.method_5648(invisible);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.field_6011.method_12778(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.field_6011.method_12789(DATA_CLIENT_FLAGS), 8, noBasePlate));
    }

    public boolean isNoBasePlate() {
        return ((Byte)this.field_6011.method_12789(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void dismantle(@Nullable class_1282 source) {
        if (source != null) {
            this.method_16080(source);
        }
        this.showBreakingParticles();
        this.playBrokenSound();
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876(class_5712.field_37676);
    }

    protected void method_16080(class_1282 damageSource) {
        super.method_16080(damageSource);
        this.method_5699(this.method_31480(), 1.0f);
    }

    protected void method_16078() {
        super.method_16078();
        class_1799 itemStack = (class_1799)this.helmet.get(0);
        if (!itemStack.method_7960()) {
            this.method_5699(itemStack, 1.0f);
            this.helmet.set(0, (Object)class_1799.field_8037);
        }
    }

    private void playBrokenSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15118, this.method_5634(), 1.0f, 1.0f);
    }

    public void method_5768() {
        this.dismantle(this.method_37908().method_48963().method_48830());
    }

    public boolean method_5659() {
        return this.method_5767();
    }

    public void setHeadPose(class_2379 headPose) {
        this.headPose = headPose;
        this.field_6011.method_12778(DATA_HEAD_POSE, (Object)headPose);
    }

    public class_2379 getHeadPose() {
        return this.headPose;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_5698(class_1297 entity) {
        if (!(entity instanceof class_1657)) return false;
        class_1657 p = (class_1657)entity;
        if (this.method_37908().method_8505(p, this.method_24515())) return false;
        return true;
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_15186, class_3417.field_15186);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_14897;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15118;
    }

    public void method_5800(class_3218 level, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public void method_5674(class_2940<?> key) {
        if (DATA_CLIENT_FLAGS.equals(key)) {
            this.method_18382();
            this.field_23807 = true;
        }
        if (field_18064.equals(key) && this.method_37908().field_9236) {
            class_4050 pose = this.method_18376();
            if (pose == class_4050.field_38098 || pose == class_4050.field_18080) {
                this.skibidiAnimation.method_41322(this.field_6012);
            } else {
                this.skibidiAnimation.method_41325();
            }
        }
        if (FACING_TARGET.equals(key) && this.method_37908().field_9236) {
            OptionalInt o = (OptionalInt)this.method_5841().method_12789(FACING_TARGET);
            if (o.isPresent()) {
                this.target = this.method_37908().method_8469(o.getAsInt());
                this.originalYRot = Float.valueOf(this.method_36454());
            } else {
                this.target = null;
            }
        }
        super.method_5674(key);
    }

    public boolean method_6102() {
        return false;
    }

    public class_1799 method_31480() {
        class_1799 itemStack = new class_1799((class_1935)ModRegistry.HAT_STAND.get());
        if (this.method_16914()) {
            itemStack.method_7977(this.method_5797());
        }
        return itemStack;
    }

    public boolean method_36608() {
        return !this.method_5767();
    }

    private void setSkibidiIfInCauldron(@Nullable class_1309 target) {
        class_2680 state = this.method_36601();
        class_2248 block = state.method_26204();
        if (block instanceof class_2275 || block instanceof class_3962) {
            this.setSkibidi(true, true, target);
        } else if (block instanceof class_2377 || block instanceof class_8168) {
            this.setSkibidi(true, false, target);
        }
    }

    public void setSkibidi(boolean skibidi, boolean tall, @Nullable class_1309 playerTarget) {
        OptionalInt opt = playerTarget != null ? OptionalInt.of(playerTarget.method_5628()) : OptionalInt.empty();
        this.field_6011.method_12778(FACING_TARGET, (Object)opt);
        if (skibidi) {
            this.method_18380(tall ? class_4050.field_18080 : class_4050.field_38098);
            this.skibidiAnimDur = 160;
        } else {
            this.method_18380(class_4050.field_18076);
        }
    }

    public static void makeSkibidiInArea(class_1309 player) {
        class_1937 level = player.method_37908();
        List toilets = level.method_18467(HatStandEntity.class, new class_238(player.method_23312()).method_1014(10.0));
        toilets.forEach(h -> h.setSkibidiIfInCauldron(player));
    }
}

