/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1735;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class RopeArrowItem
extends class_1744 {
    public RopeArrowItem(class_1792.class_1793 builder) {
        super(builder);
    }

    public class_1665 method_7702(class_1937 world, class_1799 stack, class_1309 shooter) {
        int charges = RopeArrowItem.getRopes(stack);
        return new RopeArrowEntity(world, shooter, charges);
    }

    public static int getRopes(class_1799 stack) {
        return stack.method_7936() - stack.method_7919();
    }

    public static int addRopes(class_1799 stack, int ropes) {
        int current = RopeArrowItem.getRopes(stack);
        int newCharges = Math.min(RopeArrowItem.getRopeCapacity(), current + ropes);
        int remaining = ropes - (newCharges - current);
        stack.method_7974(newCharges);
        return remaining;
    }

    public static int getRopeCapacity() {
        return CommonConfigs.Tools.ROPE_ARROW_CAPACITY.get();
    }

    public static boolean isValidRope(class_1799 stack) {
        return stack.method_31573(ModTags.ROPES);
    }

    public int getMaxDamage(class_1799 stack) {
        return RopeArrowItem.getRopeCapacity();
    }

    public boolean isInfinite(class_1799 stack, class_1799 bow, class_1657 player) {
        return false;
    }

    public boolean isRepairable(class_1799 stack) {
        return false;
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        return false;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)stack.method_7919() * 13.0f / (float)this.getMaxDamage(stack));
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }

    public int method_31571(class_1799 stack) {
        return 7294006;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 0;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        tooltip.add((class_2561)class_2561.method_43469((String)"message.supplementaries.rope_arrow_tooltip", (Object[])new Object[]{RopeArrowItem.getRopes(stack), RopeArrowItem.getRopeCapacity()}));
        if (worldIn == null) {
            return;
        }
        if (!MiscUtils.showsHints((class_1922)worldIn, flagIn)) {
            return;
        }
        class_6880.class_6883<class_2248> override = CommonConfigs.getRopeOverride();
        if (override != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"message.supplementaries.rope_arrow", (Object[])new Object[]{override.method_40237().method_29177().toString()}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        }
    }

    public boolean method_31565(class_1799 ropeArrow, class_1735 pSlot, class_5536 pAction, class_1657 pPlayer) {
        class_1799 itemstack;
        if (pAction != class_5536.field_27014 && RopeArrowItem.isValidRope(itemstack = pSlot.method_7677())) {
            float ropes = RopeArrowItem.getRopes(ropeArrow);
            int missingRope = (int)((float)ropeArrow.method_7936() - ropes);
            if (missingRope != 0) {
                class_1799 rest;
                class_1799 ropeTaken = pSlot.method_32753(itemstack.method_7947(), missingRope, pPlayer);
                int remainingRopes = RopeArrowItem.addRopes(ropeArrow, ropeTaken.method_7947());
                this.playInsertSound((class_1297)pPlayer);
                class_1799 remaining = ropeTaken.method_7972();
                remaining.method_7939(remainingRopes);
                if (!remaining.method_7960() && !(rest = pSlot.method_32756(remaining)).method_7960()) {
                    pPlayer.method_7328(rest, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_31566(class_1799 ropeArrow, class_1799 ropeStack, class_1735 pSlot, class_5536 pAction, class_1657 pPlayer, class_5630 pAccess) {
        if (pAction == class_5536.field_27014 && pSlot.method_32754(pPlayer) && RopeArrowItem.isValidRope(ropeStack)) {
            float ropes = RopeArrowItem.getRopes(ropeArrow);
            int missingRope = (int)((float)ropeArrow.method_7936() - ropes);
            if (missingRope != 0) {
                int ropeWeCanAdd = Math.min(missingRope, ropeStack.method_7947());
                RopeArrowItem.addRopes(ropeArrow, ropeWeCanAdd);
                ropeStack.method_7934(ropeWeCanAdd);
                this.playInsertSound((class_1297)pPlayer);
                return true;
            }
        }
        return false;
    }

    private void playInsertSound(class_1297 pEntity) {
        pEntity.method_5783(ModSounds.ROPE_PLACE.get(), 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

