/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMenu;
import vectorwing.farmersdelight.common.block.entity.inventory.CookingPotItemHandler;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CookingPotBlockEntity
extends SyncedBlockEntity
implements class_3908,
HeatableBlockEntity,
class_1275,
class_1732 {
    public static final int MEAL_DISPLAY_SLOT = 6;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    public static final Map<class_1792, class_1792> INGREDIENT_REMAINDER_OVERRIDES = Map.ofEntries(Map.entry(class_1802.field_27876, class_1802.field_8550), Map.entry(class_1802.field_28354, class_1802.field_8550), Map.entry(class_1802.field_8666, class_1802.field_8550), Map.entry(class_1802.field_8108, class_1802.field_8550), Map.entry(class_1802.field_8714, class_1802.field_8550), Map.entry(class_1802.field_8478, class_1802.field_8550), Map.entry(class_1802.field_8766, class_1802.field_8428), Map.entry(class_1802.field_8208, class_1802.field_8428), Map.entry(class_1802.field_8308, class_1802.field_8428), Map.entry(class_1802.field_8515, class_1802.field_8428), Map.entry(class_1802.field_8574, class_1802.field_8469), Map.entry(class_1802.field_8436, class_1802.field_8469), Map.entry(class_1802.field_8150, class_1802.field_8469), Map.entry(class_1802.field_8287, class_1802.field_8469));
    private final ItemStackHandlerContainer inventory = this.createHandler();
    private final CookingPotItemHandler inputHandler = new CookingPotItemHandler(this.inventory, class_2350.field_11036);
    private final CookingPotItemHandler outputHandler = new CookingPotItemHandler(this.inventory, class_2350.field_11033);
    private int cookTime;
    private int cookTimeTotal;
    private class_1799 mealContainerStack = class_1799.field_8037;
    private class_2561 customName;
    protected final class_3913 cookingPotData = this.createIntArray();
    private final Object2IntOpenHashMap<class_2960> usedRecipeTracker = new Object2IntOpenHashMap();
    private class_2960 lastRecipeID;
    private boolean checkNewRecipe = true;

    public CookingPotBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.COOKING_POT.get(), pos, state);
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(CookingPotBlockEntity::getStorage, ModBlockEntityTypes.COOKING_POT.get());
    }

    public static class_1799 getMealFromItem(class_1799 cookingPotStack) {
        class_2487 inventoryTag;
        if (!cookingPotStack.method_31574(ModItems.COOKING_POT.get())) {
            return class_1799.field_8037;
        }
        class_2487 compound = cookingPotStack.method_7941("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.method_10562("Inventory")).method_10573("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            return handler.getStackInSlot(6);
        }
        return class_1799.field_8037;
    }

    public static void takeServingFromItem(class_1799 cookingPotStack) {
        class_2487 inventoryTag;
        if (!cookingPotStack.method_31574(ModItems.COOKING_POT.get())) {
            return;
        }
        class_2487 compound = cookingPotStack.method_7941("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.method_10562("Inventory")).method_10573("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            class_1799 newMealStack = handler.getStackInSlot(6);
            newMealStack.method_7934(1);
            compound.method_10551("Inventory");
            compound.method_10566("Inventory", (class_2520)handler.serializeNBT());
        }
    }

    public static class_1799 getContainerFromItem(class_1799 cookingPotStack) {
        if (!cookingPotStack.method_31574(ModItems.COOKING_POT.get())) {
            return class_1799.field_8037;
        }
        class_2487 compound = cookingPotStack.method_7941("BlockEntityTag");
        if (compound != null) {
            return class_1799.method_7915((class_2487)compound.method_10562("Container"));
        }
        return class_1799.field_8037;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.cookTime = compound.method_10550("CookTime");
        this.cookTimeTotal = compound.method_10550("CookTimeTotal");
        this.mealContainerStack = class_1799.method_7915((class_2487)compound.method_10562("Container"));
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
        class_2487 compoundRecipes = compound.method_10562("RecipesUsed");
        for (String key : compoundRecipes.method_10541()) {
            this.usedRecipeTracker.put((Object)new class_2960(key), compoundRecipes.method_10550(key));
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10569("CookTime", this.cookTime);
        compound.method_10569("CookTimeTotal", this.cookTimeTotal);
        compound.method_10566("Container", this.mealContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        class_2487 compoundRecipes = new class_2487();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.method_10569(recipeId.toString(), craftedAmount.intValue()));
        compound.method_10566("RecipesUsed", (class_2520)compoundRecipes);
    }

    private class_2487 writeItems(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10566("Container", this.mealContainerStack.serializeNBT());
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        return compound;
    }

    public class_2487 writeMeal(class_2487 compound) {
        if (this.getMeal().method_7960()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(9);
        for (int i = 0; i < 9; ++i) {
            drops.setStackInSlot(i, i == 6 ? this.inventory.getStackInSlot(i) : class_1799.field_8037);
        }
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        compound.method_10566("Container", this.mealContainerStack.serializeNBT());
        compound.method_10566("Inventory", (class_2520)drops.serializeNBT());
        return compound;
    }

    public static void cookingTick(class_1937 level, class_2338 pos, class_2680 state, CookingPotBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional<CookingPotRecipe> recipe = cookingPot.getMatchingRecipe(new RecipeWrapper((ItemStackHandler)cookingPot.inventory));
            if (recipe.isPresent() && cookingPot.canCook(recipe.get())) {
                didInventoryChange = cookingPot.processCooking(recipe.get(), cookingPot);
            } else {
                cookingPot.cookTime = class_3532.method_15340((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = class_3532.method_15340((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        class_1799 mealStack = cookingPot.getMeal();
        if (!mealStack.method_7960()) {
            if (!cookingPot.doesMealHaveContainer(mealStack)) {
                cookingPot.moveMealToOutput();
                didInventoryChange = true;
            } else if (!cookingPot.inventory.getStackInSlot(7).method_7960()) {
                cookingPot.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            cookingPot.inventoryChanged();
        }
    }

    public static void animationTick(class_1937 level, class_2338 pos, class_2680 state, CookingPotBlockEntity cookingPot) {
        if (cookingPot.isHeated(level, pos)) {
            double z;
            double y;
            double x;
            class_5819 random = level.field_9229;
            if (random.method_43057() < 0.2f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.6 - 0.3);
                y = (double)pos.method_10264() + 0.7;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.6 - 0.3);
                level.method_8406((class_2394)class_2398.field_11241, x, y, z, 0.0, 0.0, 0.0);
            }
            if (random.method_43057() < 0.05f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                y = (double)pos.method_10264() + 0.5;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionY = random.method_43056() ? 0.015 : 0.005;
                level.method_8406((class_2394)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
        }
    }

    private Optional<CookingPotRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.field_11863.method_8433()).getRecipeMap(ModRecipeTypes.COOKING.get()).get(this.lastRecipeID)) instanceof CookingPotRecipe) {
            if (recipe.method_8115((class_1263)inventoryWrapper, this.field_11863)) {
                return Optional.of((CookingPotRecipe)recipe);
            }
            if (class_1799.method_7984((class_1799)recipe.method_8110(this.field_11863.method_30349()), (class_1799)this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.field_11863.method_8433().method_8132(ModRecipeTypes.COOKING.get(), (class_1263)inventoryWrapper, this.field_11863))).isPresent()) {
            class_2960 newRecipeID = ((CookingPotRecipe)((Optional)recipe).get()).method_8114();
            if (this.lastRecipeID != null && !this.lastRecipeID.equals((Object)newRecipeID)) {
                this.cookTime = 0;
            }
            this.lastRecipeID = newRecipeID;
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public class_1799 getContainer() {
        class_1799 mealStack = this.getMeal();
        if (mealStack.method_7960() || this.mealContainerStack.method_7960()) {
            return mealStack.getRecipeRemainder();
        }
        return this.mealContainerStack;
    }

    private boolean hasInput() {
        for (int i = 0; i < 6; ++i) {
            if (this.inventory.getStackInSlot(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(CookingPotRecipe recipe) {
        if (this.hasInput()) {
            class_1799 resultStack = recipe.method_8110(this.field_11863.method_30349());
            if (resultStack.method_7960()) {
                return false;
            }
            class_1799 storedMealStack = this.inventory.getStackInSlot(6);
            if (storedMealStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)storedMealStack, (class_1799)resultStack)) {
                return false;
            }
            if (storedMealStack.method_7947() + resultStack.method_7947() <= this.inventory.getSlotLimit(6)) {
                return true;
            }
            return storedMealStack.method_7947() + resultStack.method_7947() <= resultStack.method_7914();
        }
        return false;
    }

    private boolean processCooking(CookingPotRecipe recipe, CookingPotBlockEntity cookingPot) {
        if (this.field_11863 == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        class_1799 resultStack = recipe.method_8110(this.field_11863.method_30349());
        class_1799 storedMealStack = this.inventory.getStackInSlot(6);
        if (storedMealStack.method_7960()) {
            this.inventory.setStackInSlot(6, resultStack.method_7972());
        } else if (class_1799.method_7984((class_1799)storedMealStack, (class_1799)resultStack)) {
            storedMealStack.method_7933(resultStack.method_7947());
        }
        cookingPot.method_7662(recipe);
        for (int i = 0; i < 6; ++i) {
            class_1799 slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.getRecipeRemainder().method_7960()) {
                this.ejectIngredientRemainder(slotStack.getRecipeRemainder());
            } else if (INGREDIENT_REMAINDER_OVERRIDES.containsKey(slotStack.method_7909())) {
                this.ejectIngredientRemainder(INGREDIENT_REMAINDER_OVERRIDES.get(slotStack.method_7909()).method_7854());
            }
            if (slotStack.method_7960()) continue;
            slotStack.method_7934(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(class_1799 remainderStack) {
        class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)CookingPotBlock.FACING)).method_10160();
        double x = (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.25;
        double y = (double)this.field_11867.method_10264() + 0.7;
        double z = (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.25;
        ItemUtils.spawnItemEntity(this.field_11863, remainderStack, x, y, z, (float)direction.method_10148() * 0.08f, 0.25, (float)direction.method_10165() * 0.08f);
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 recipeID = recipe.method_8114();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public class_1860<?> method_7663() {
        return null;
    }

    public void method_7664(class_1657 player, List<class_1799> items) {
        List<class_1860<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.method_37908(), player.method_19538());
        player.method_7254(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<class_1860<?>> getUsedRecipesAndPopExperience(class_1937 level, class_243 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                CookingPotBlockEntity.splitAndSpawnExperience((class_3218)level, pos, entry.getIntValue(), ((CookingPotRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(class_3218 level, class_243 pos, int craftedAmount, float experience) {
        int expTotal = class_3532.method_15375((float)((float)craftedAmount * experience));
        float expFraction = class_3532.method_22450((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        class_1303.method_31493((class_3218)level, (class_243)pos, (int)expTotal);
    }

    public boolean isHeated() {
        if (this.field_11863 == null) {
            return false;
        }
        return this.isHeated(this.field_11863, this.field_11867);
    }

    public ItemStackHandlerContainer getInventory() {
        return this.inventory;
    }

    public class_1799 getMeal() {
        return this.inventory.getStackInSlot(6);
    }

    public class_2371<class_1799> getDroppableInventory() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < 9; ++i) {
            if (i == 6) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        class_1799 mealStack = this.inventory.getStackInSlot(6);
        class_1799 outputStack = this.inventory.getStackInSlot(8);
        int mealCount = Math.min(mealStack.method_7947(), mealStack.method_7914() - outputStack.method_7947());
        if (outputStack.method_7960()) {
            this.inventory.setStackInSlot(8, mealStack.method_7971(mealCount));
        } else if (outputStack.method_7909() == mealStack.method_7909()) {
            mealStack.method_7934(mealCount);
            outputStack.method_7933(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        class_1799 mealStack = this.inventory.getStackInSlot(6);
        class_1799 containerInputStack = this.inventory.getStackInSlot(7);
        class_1799 outputStack = this.inventory.getStackInSlot(8);
        if (this.isContainerValid(containerInputStack) && outputStack.method_7947() < outputStack.method_7914()) {
            int smallerStackCount = Math.min(mealStack.method_7947(), containerInputStack.method_7947());
            int mealCount = Math.min(smallerStackCount, mealStack.method_7914() - outputStack.method_7947());
            if (outputStack.method_7960()) {
                containerInputStack.method_7934(mealCount);
                this.inventory.setStackInSlot(8, mealStack.method_7971(mealCount));
            } else if (outputStack.method_7909() == mealStack.method_7909()) {
                mealStack.method_7934(mealCount);
                containerInputStack.method_7934(mealCount);
                outputStack.method_7933(mealCount);
            }
        }
    }

    public class_1799 useHeldItemOnMeal(class_1799 container) {
        if (this.isContainerValid(container) && !this.getMeal().method_7960()) {
            container.method_7934(1);
            this.inventoryChanged();
            return this.getMeal().method_7971(1);
        }
        return class_1799.field_8037;
    }

    private boolean doesMealHaveContainer(class_1799 meal) {
        return !this.mealContainerStack.method_7960() || !meal.getRecipeRemainder().method_7960();
    }

    public boolean isContainerValid(class_1799 containerItem) {
        if (containerItem.method_7960()) {
            return false;
        }
        if (!this.mealContainerStack.method_7960()) {
            return class_1799.method_7984((class_1799)this.mealContainerStack, (class_1799)containerItem);
        }
        return class_1799.method_7984((class_1799)this.getMeal(), (class_1799)containerItem);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : TextUtils.getTranslation("container.cooking_pot", new Object[0]);
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
    }

    public class_1703 createMenu(int id, class_1661 player, class_1657 entity) {
        return new CookingPotMenu(id, player, this, this.cookingPotData);
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        if (side == null || side.equals((Object)class_2350.field_11036)) {
            return this.inputHandler;
        }
        return this.outputHandler;
    }

    public void method_11012() {
        super.method_11012();
    }

    @Override
    public class_2487 method_16887() {
        return this.writeItems(new class_2487());
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(9){

            public int getSlotLimit(int slot) {
                if (slot == 6) {
                    return Math.max(64, this.getStackInSlot(slot).method_7914());
                }
                return this.getStackInSlot(slot).method_7914();
            }

            protected int getStackLimit(int slot, ItemVariant resource) {
                if (slot == 6) {
                    return Math.max(64, this.getStackInSlot(slot).method_7914());
                }
                return Math.min(this.getSlotLimit(slot), resource.getItem().method_7882());
            }

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 6) {
                    CookingPotBlockEntity.this.checkNewRecipe = true;
                }
                CookingPotBlockEntity.this.inventoryChanged();
            }
        };
    }

    private class_3913 createIntArray() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> CookingPotBlockEntity.this.cookTime;
                    case 1 -> CookingPotBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        CookingPotBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        CookingPotBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }
}

