/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.EnumSet;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CookingPotRecipe
implements class_1860<RecipeWrapper> {
    public static final int INPUT_SLOTS = 6;
    private final class_2960 id;
    private final String group;
    private final CookingPotRecipeBookTab tab;
    private final class_2371<class_1856> inputItems;
    private final class_1799 output;
    private final class_1799 container;
    private final float experience;
    private final int cookTime;

    public CookingPotRecipe(class_2960 id, String group, @Nullable CookingPotRecipeBookTab tab, class_2371<class_1856> inputItems, class_1799 output, class_1799 container, float experience, int cookTime) {
        this.id = id;
        this.group = group;
        this.tab = tab;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.method_7960() ? container : (!output.getRecipeRemainder().method_7960() ? output.getRecipeRemainder() : class_1799.field_8037);
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    @Nullable
    public CookingPotRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputItems;
    }

    public class_1799 method_8110(class_5455 access) {
        return this.output;
    }

    public class_1799 getOutputContainer() {
        return this.container;
    }

    public class_1799 assemble(RecipeWrapper inv, class_5455 access) {
        return this.output.method_7972();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        class_1662 stackedContents = new class_1662();
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            class_1799 itemstack = inv.method_5438(j);
            if (itemstack.method_7960()) continue;
            ++i;
            stackedContents.method_20478(itemstack, 1);
        }
        return i == this.inputItems.size() && stackedContents.method_7402((class_1860)this, null);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.COOKING.get();
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.COOKING.get();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModItems.COOKING_POT.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CookingPotRecipe that = (CookingPotRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getCookTime() != that.getCookTime()) {
            return false;
        }
        if (!this.method_8114().equals((Object)that.method_8114())) {
            return false;
        }
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (this.tab != that.tab) {
            return false;
        }
        if (!this.inputItems.equals(that.inputItems)) {
            return false;
        }
        if (!this.output.equals(that.output)) {
            return false;
        }
        return this.container.equals(that.container);
    }

    public int hashCode() {
        int result = this.method_8114().hashCode();
        result = 31 * result + this.method_8112().hashCode();
        result = 31 * result + (this.getRecipeBookTab() != null ? this.getRecipeBookTab().hashCode() : 0);
        result = 31 * result + this.inputItems.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.container.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getCookTime();
        return result;
    }

    public static class Serializer
    implements class_1865<CookingPotRecipe> {
        public CookingPotRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String groupIn = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> inputItemsIn = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (inputItemsIn.size() > 6) {
                throw new JsonParseException("Too many ingredients for cooking recipe! The max is 6");
            }
            String tabKeyIn = class_3518.method_15253((JsonObject)json, (String)"recipe_book_tab", null);
            CookingPotRecipeBookTab tabIn = CookingPotRecipeBookTab.findByName(tabKeyIn);
            if (tabKeyIn != null && tabIn == null) {
                FarmersDelight.LOGGER.warn("Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + String.valueOf(EnumSet.allOf(CookingPotRecipeBookTab.class)));
            }
            class_1799 outputIn = CraftingHelper.getItemStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"), (boolean)true);
            class_1799 container = class_3518.method_15294((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"container"), (boolean)true) : class_1799.field_8037;
            float experienceIn = class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f);
            int cookTimeIn = class_3518.method_15282((JsonObject)json, (String)"cookingtime", (int)200);
            return new CookingPotRecipe(recipeId, groupIn, tabIn, inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public CookingPotRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String groupIn = buffer.method_19772();
            CookingPotRecipeBookTab tabIn = CookingPotRecipeBookTab.findByName(buffer.method_19772());
            int i = buffer.method_10816();
            class_2371 inputItemsIn = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 outputIn = buffer.method_10819();
            class_1799 container = buffer.method_10819();
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.method_10816();
            return new CookingPotRecipe(recipeId, groupIn, tabIn, (class_2371<class_1856>)inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        public void toNetwork(class_2540 buffer, CookingPotRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10814(recipe.tab != null ? recipe.tab.toString() : "");
            buffer.method_10804(recipe.inputItems.size());
            for (class_1856 ingredient : recipe.inputItems) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.output);
            buffer.method_10793(recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.method_10804(recipe.cookTime);
        }
    }
}

