/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.conczin.immersive_furniture.client.gui.FakeCamera;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2394;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_703;
import net.minecraft.class_757;
import net.minecraft.class_765;

public class PreviewParticleEngine {
    private static final List<class_3999> RENDER_ORDER = ImmutableList.of((Object)class_3999.field_17827, (Object)class_3999.field_17828, (Object)class_3999.field_17830, (Object)class_3999.field_17829, (Object)class_3999.field_17831);
    private final Map<class_3999, Queue<class_703>> particles = Maps.newIdentityHashMap();

    public void add(class_703 particle) {
        this.particles.computeIfAbsent(particle.method_18122(), particleRenderType -> EvictingQueue.create((int)16384)).add(particle);
    }

    public void addParticle(class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        class_703 particle = class_310.method_1551().field_1713.method_3056(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.add(particle);
        }
    }

    public void tick() {
        this.particles.forEach((particleRenderType, queue) -> this.tickParticleList((Collection<class_703>)queue));
    }

    private void tickParticleList(Collection<class_703> particles) {
        if (!particles.isEmpty()) {
            Iterator<class_703> iterator = particles.iterator();
            while (iterator.hasNext()) {
                class_703 particle = iterator.next();
                particle.method_3070();
                if (particle.method_3086()) continue;
                iterator.remove();
            }
        }
    }

    public void render(class_4587 poseStack, class_765 lightTexture, class_4184 camera, float partialTicks) {
        lightTexture.method_3316();
        RenderSystem.enableDepthTest();
        class_4587 viewStack = RenderSystem.getModelViewStack();
        viewStack.method_22903();
        viewStack.method_34425(poseStack.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();
        class_1060 textureManager = class_310.method_1551().method_1531();
        for (class_3999 particleRenderType : RENDER_ORDER) {
            Iterable iterable = this.particles.get(particleRenderType);
            if (iterable == null) continue;
            RenderSystem.setShader(class_757::method_34546);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            particleRenderType.method_18130(bufferBuilder, textureManager);
            for (class_703 particle : iterable) {
                particle.method_3074((class_4588)bufferBuilder, camera, partialTicks);
            }
            particleRenderType.method_18131(tesselator);
        }
        viewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTexture.method_3315();
    }

    public void renderParticles(class_332 graphics, float yaw, float pitch, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null) {
            return;
        }
        FakeCamera camera = new FakeCamera();
        camera.setup((class_1922)minecraft.field_1687, (class_1297)minecraft.field_1724, false, false, partialTicks, yaw, pitch);
        this.render(graphics.method_51448(), minecraft.field_1773.method_22974(), camera, partialTicks);
    }
}

