/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.CompositeBakedModel;
import net.conczin.immersive_furniture.client.model.CompositeBlockModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelFactory;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.utils.CachedSupplier;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;

public class FurnitureModelBaker {
    public static final class_2960 LOCATION = Common.locate("block/furniture");
    private static final ModelBakerImpl modelBaker = new ModelBakerImpl();
    private static final class_5819 random = class_5819.method_43047();

    private static CompositeBakedModel bakeModel(DynamicAtlas atlas, CompositeBlockModel model, int yRot, int state) {
        LinkedHashMap<class_1921, class_1087> bakedModels = new LinkedHashMap<class_1921, class_1087>();
        for (class_1921 type : model.models.get(state).keySet()) {
            bakedModels.put(type, FurnitureModelBaker.bakeModel(atlas, model, type, yRot, state));
        }
        return new CompositeBakedModel(bakedModels);
    }

    private static class_1087 bakeModel(DynamicAtlas atlas, CompositeBlockModel model, class_1921 type, int yRot, int state) {
        class_1087 bake = model.models.get(state).get(type).method_4753((class_7775)modelBaker, material -> atlas == DynamicAtlas.BAKED || !material.method_24147().method_12836().equals("immersive_furniture") ? material.method_24148() : atlas.sprite, (class_3665)class_1086.method_4699((int)0, (int)yRot), LOCATION);
        for (class_777 quad : bake.method_4707(null, null, random)) {
            int[] vertices = quad.method_3357();
            for (int i = 0; i < vertices.length; i += 8) {
                FurnitureData.Element element = model.getElement(quad.method_3359());
                vertices[i + 3] = element.color;
                vertices[i + 6] = element.emission << 20 | element.emission << 4;
            }
        }
        return bake;
    }

    public static CompositeBakedModel getAsyncModel(FurnitureData data, DynamicAtlas atlas, int state) {
        String hash = data.getHash();
        if (atlas.knownFurniture.containsKey(hash)) {
            return FurnitureModelBaker.getModel(data, hash, atlas, 0, state, false);
        }
        if (!atlas.asyncRequestedFurniture.contains(hash)) {
            atlas.asyncRequestedFurniture.add(hash);
            Common.EXECUTOR.execute(() -> {
                FurnitureModelBaker.getModel(data, hash, atlas, 0, state, false);
                atlas.asyncRequestedFurniture.remove(hash);
            });
        }
        return null;
    }

    public static CompositeBakedModel getModel(FurnitureData data, DynamicAtlas atlas) {
        return FurnitureModelBaker.getModel(data, data.getHash(), atlas, 0, 0, true);
    }

    public static CompositeBakedModel getModel(FurnitureData data, String hash, DynamicAtlas atlas, int yRot, int state, boolean force) {
        boolean exist;
        CachedBakedModelSet cachedBakedModelSet = atlas.knownFurniture.get(hash);
        boolean bl = exist = cachedBakedModelSet != null;
        if (!force && !exist && atlas.isFull()) {
            return null;
        }
        if (exist) {
            atlas.uploadIfDirty();
            return cachedBakedModelSet.get(yRot, state);
        }
        float previousUsage = atlas.getUsage();
        CompositeBlockModel model = FurnitureModelFactory.getModel(data, atlas);
        atlas.uploadIfDirty();
        CachedBakedModelSet modelSet = new CachedBakedModelSet(atlas, model);
        if (hash.equals(data.computeHash())) {
            atlas.knownFurniture.put(hash, modelSet);
        }
        if (force || !atlas.isFull() && atlas.getUsage() >= previousUsage) {
            return modelSet.get(yRot, state);
        }
        atlas.knownFurniture.remove(hash);
        return null;
    }

    static class ModelBakerImpl
    implements class_7775 {
        ModelBakerImpl() {
        }

        public class_1100 method_45872(class_2960 location) {
            return null;
        }

        public class_1087 method_45873(class_2960 location, class_3665 transform) {
            return null;
        }

        public class_1087 bake(class_2960 var1, class_3665 var2, Function<class_4730, class_1058> var3) {
            return null;
        }

        public Function<class_4730, class_1058> getModelTextureGetter() {
            return null;
        }
    }

    public static class CachedBakedModelSet {
        private static final Supplier<CompositeBakedModel> EMPTY = () -> new CompositeBakedModel(Map.of());
        public final Map<Integer, Supplier<CompositeBakedModel>> variations = new HashMap<Integer, Supplier<CompositeBakedModel>>();

        public CachedBakedModelSet(DynamicAtlas atlas, CompositeBlockModel model) {
            for (int rot = 0; rot < 360; rot += 90) {
                for (Integer state : model.models.keySet()) {
                    int finalRot = rot;
                    this.variations.put(rot + state, new CachedSupplier<CompositeBakedModel>(() -> FurnitureModelBaker.bakeModel(atlas, model, finalRot, state)));
                }
            }
        }

        public CompositeBakedModel get(int yRot, int state) {
            return this.variations.getOrDefault(yRot + state, this.variations.getOrDefault(yRot, EMPTY)).get();
        }
    }
}

