/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.renderer;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.entity.FurnitureBlockEntity;
import net.conczin.immersive_furniture.client.model.CompositeBakedModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.conczin.immersive_furniture.client.renderer.ModelBoundingBoxFetcher;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_8235;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class FurnitureBlockEntityRenderer<T extends FurnitureBlockEntity>
implements class_827<T> {
    private final class_918 itemRenderer;
    private static final class_5819 randomsource = class_5819.method_43047();

    public FurnitureBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
    }

    public void render(T blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        int state;
        ++Common.entityRendersTotal;
        FurnitureData data = ((FurnitureBlockEntity)((Object)blockEntity)).getData();
        if (data == null) {
            return;
        }
        class_2680 blockState = blockEntity.method_11010();
        int n = state = (Boolean)blockState.method_11654((class_2769)BaseFurnitureBlock.ACTIVE) != false ? 1 : 0;
        if (FurnitureBlockEntityRenderer.hasItems(blockEntity, data, state)) {
            poseStack.method_22903();
            FurnitureBlockEntityRenderer.rotate(blockState, poseStack);
            FurnitureBlockEntityRenderer.drawItems(this.itemRenderer, blockEntity.method_10997(), blockEntity, state, poseStack, buffer, packedLight, packedOverlay, data);
            poseStack.method_22909();
        }
        if (DynamicAtlas.BAKED.knownFurniture.containsKey(data.getHash())) {
            return;
        }
        ++Common.entityRenders;
        poseStack.method_22903();
        FurnitureBlockEntityRenderer.rotate(blockState, poseStack);
        FurnitureBlockEntityRenderer.renderFurniture(blockState, poseStack, buffer, packedLight, packedOverlay, data);
        poseStack.method_22909();
    }

    private static void rotate(class_2680 blockState, class_4587 poseStack) {
        if (blockState.method_26204() instanceof BaseFurnitureBlock) {
            float yaw = -((class_2350)blockState.method_11654((class_2769)BaseFurnitureBlock.FACING)).method_10153().method_10144();
            poseStack.method_46416(0.5f, 0.5f, 0.5f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yaw));
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        }
    }

    public static boolean hasItems(FurnitureBlockEntity blockEntity, FurnitureData data, int state) {
        int slot = 0;
        for (FurnitureData.Element element : data.elements) {
            class_1799 itemstack;
            if (element.type != FurnitureData.ElementType.SPRITE || !element.sprite.item || !element.isMasked(state)) continue;
            class_1799 class_17992 = itemstack = blockEntity == null ? class_1802.field_8279.method_7854() : blockEntity.method_5438(slot);
            if (!itemstack.method_7960()) {
                return true;
            }
            ++slot;
        }
        return false;
    }

    public static void drawItems(class_918 itemRenderer, class_1937 level, FurnitureBlockEntity blockEntity, int state, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, FurnitureData data) {
        int slot = 0;
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.SPRITE || !element.sprite.item || !element.isMasked(state)) continue;
            class_1799 itemStack = blockEntity == null ? (slot % 4 == 0 ? class_1802.field_8279.method_7854() : (slot % 4 == 1 ? class_1802.field_8732.method_7854() : (slot % 4 == 2 ? class_1802.field_8377.method_7854() : class_1802.field_8792.method_7854()))) : blockEntity.method_5438(slot);
            if (itemStack.method_7960()) continue;
            Vector3f center = element.getCenter();
            Quaternionf quaternion = ModelUtils.getElementRotation(element.getRotation());
            poseStack.method_22903();
            poseStack.method_22904((double)center.x / 16.0, (double)center.y / 16.0, (double)center.z / 16.0);
            poseStack.method_22907(quaternion);
            poseStack.method_22905(element.sprite.size, element.sprite.size, element.sprite.size);
            class_1087 bakedmodel = itemRenderer.method_4019(itemStack, level, null, slot);
            class_238 box = ModelBoundingBoxFetcher.INSTANCE.getModelBoundingBox(bakedmodel);
            if (element.sprite.align) {
                poseStack.method_22904(0.0, -0.5 - box.field_1322, 0.0);
            } else {
                poseStack.method_22904(0.0, 0.0, box.field_1321);
            }
            itemRenderer.method_23179(itemStack, class_811.field_4319, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
            poseStack.method_22909();
            ++slot;
        }
    }

    public static void renderFurniture(class_2680 state, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, FurnitureData data) {
        FurnitureBlockEntityRenderer.renderFurniture(state, poseStack, buffer, packedLight, packedOverlay, FurnitureModelBaker.getModel(data, DynamicAtlas.ENTITY), DynamicAtlas.ENTITY);
    }

    public static void renderFurniture(class_2680 state, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, CompositeBakedModel bakedModel, DynamicAtlas atlas) {
        for (int i = 0; i < 2; ++i) {
            class_2960 location = i == 0 ? atlas.getLocation() : class_1723.field_21668;
            for (Map.Entry<class_1921, class_1087> entry : bakedModel.getModels().entrySet()) {
                class_4588 consumer = entry.getKey() == class_1921.method_23581() || entry.getKey() == class_1921.method_23579() ? buffer.getBuffer(class_1921.method_23576((class_2960)location)) : (entry.getKey() == class_1921.method_23583() ? buffer.getBuffer(class_1921.method_23689((class_2960)location)) : buffer.getBuffer(class_1921.method_23572((class_2960)location)));
                FurnitureBlockEntityRenderer.renderModel(poseStack.method_23760(), consumer, state, entry.getValue(), packedLight, packedOverlay, i == 1);
            }
        }
    }

    private static void renderModel(class_4587.class_4665 pose, class_4588 consumer, class_2680 state, class_1087 model, int packedLight, int packedOverlay, boolean blocksAtlas) {
        for (class_2350 direction : class_8235.field_43226) {
            FurnitureBlockEntityRenderer.renderQuadList(pose, consumer, model.method_4707(state, direction, randomsource), packedLight, packedOverlay, blocksAtlas);
        }
        FurnitureBlockEntityRenderer.renderQuadList(pose, consumer, model.method_4707(state, null, randomsource), packedLight, packedOverlay, blocksAtlas);
    }

    private static void renderQuadList(class_4587.class_4665 pose, class_4588 consumer, List<class_777> quads, int packedLight, int packedOverlay, boolean blocksAtlas) {
        for (class_777 quad : quads) {
            class_2960 resourceLocation = quad.method_35788().method_45852();
            if (resourceLocation.method_12836().equals("minecraft") != blocksAtlas) continue;
            FurnitureBlockEntityRenderer.putBulkData(consumer, pose, quad, packedLight, packedOverlay);
        }
    }

    static void putBulkData(class_4588 consumer, class_4587.class_4665 pose, class_777 quad, int packedLight, int packedOverlay) {
        int[] vertices = quad.method_3357();
        class_2382 quadNormal = quad.method_3358().method_10163();
        Matrix4f matrix4f = pose.method_23761();
        Vector3f normal = pose.method_23762().transform(new Vector3f((float)quadNormal.method_10263(), (float)quadNormal.method_10264(), (float)quadNormal.method_10260()));
        int vertexCount = vertices.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(class_290.field_1590.method_1362());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int i = 0; i < vertexCount; ++i) {
                intbuffer.clear();
                intbuffer.put(vertices, i * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                Vector4f pos = matrix4f.transform(new Vector4f(x, y, z, 1.0f));
                float red = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                float green = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                float blue = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                float u = bytebuffer.getFloat(16);
                float v = bytebuffer.getFloat(20);
                int light = FurnitureBlockEntityRenderer.blend(packedLight, quad.method_3357()[i * 8 + 6]);
                consumer.method_23919(pos.x(), pos.y(), pos.z(), red, green, blue, 1.0f, u, v, packedOverlay, light, normal.x(), normal.y(), normal.z());
            }
        }
    }

    private static int blend(int worldLight, int vertexLight) {
        return Math.max(worldLight & 0xFFFF, vertexLight & 0xFFFF) | Math.max(worldLight >> 16 & 0xFFFF, vertexLight >> 16 & 0xFFFF) << 16;
    }
}

