/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.class_2350;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelUtils {
    public static Quaternionf getElementRotation(ElementRotation rotation) {
        Vector3f axis = switch (rotation.axis()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> new Vector3f(1.0f, 0.0f, 0.0f);
            case class_2350.class_2351.field_11052 -> new Vector3f(0.0f, 1.0f, 0.0f);
            case class_2350.class_2351.field_11051 -> new Vector3f(0.0f, 0.0f, 1.0f);
        };
        return new Quaternionf().rotationAxis(rotation.angle() * ((float)Math.PI / 180), (Vector3fc)axis);
    }

    public static void applyElementRotation(Vector3f pos, ElementRotation rotation) {
        if (rotation == null) {
            return;
        }
        Quaternionf quaternionf = ModelUtils.getElementRotation(rotation);
        pos.mul(0.0625f);
        pos.sub((Vector3fc)rotation.origin());
        quaternionf.transform(pos);
        pos.add((Vector3fc)rotation.origin());
        pos.mul(16.0f);
    }

    public static void applyInverseElementRotation(Vector3f pos, ElementRotation rotation) {
        Quaternionf quaternionf = ModelUtils.getElementRotation(rotation).conjugate();
        pos.sub((Vector3fc)rotation.origin());
        quaternionf.transform(pos);
        pos.add((Vector3fc)rotation.origin());
    }

    public static Vector3f[] getCorners(FurnitureData.Element element) {
        Vector3f[] corners = new Vector3f[]{new Vector3f(element.from.x(), element.from.y(), element.from.z()), new Vector3f(element.from.x(), element.from.y(), element.to.z()), new Vector3f(element.from.x(), element.to.y(), element.from.z()), new Vector3f(element.from.x(), element.to.y(), element.to.z()), new Vector3f(element.to.x(), element.from.y(), element.from.z()), new Vector3f(element.to.x(), element.from.y(), element.to.z()), new Vector3f(element.to.x(), element.to.y(), element.from.z()), new Vector3f(element.to.x(), element.to.y(), element.to.z())};
        ElementRotation rotation = element.getRotation();
        for (int i = 0; i < 8; ++i) {
            ModelUtils.applyElementRotation(corners[i], rotation);
        }
        return corners;
    }

    public static Vector3f rotate(Vector3f vec, class_2350.class_2351 axis, float rotation) {
        switch (axis) {
            case field_11048: {
                class_7833.field_40714.rotationDegrees(rotation).transform(vec);
                break;
            }
            case field_11052: {
                class_7833.field_40716.rotationDegrees(rotation).transform(vec);
                break;
            }
            case field_11051: {
                class_7833.field_40718.rotationDegrees(rotation).transform(vec);
            }
        }
        return vec;
    }
}

