/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.google.common.cache.Cache;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.compat.trainmap.TrainMapSyncPacket;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.TickBasedCache;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.pepperbell.simplenetworking.S2CPacket;
import net.createmod.catnip.data.Pair;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class TrainMapSync {
    public static final int lightPacketInterval = 5;
    public static final int fullPacketInterval = 10;
    public static int ticks;
    public static Cache<UUID, WeakReference<class_3222>> requestingPlayers;

    public static void requestReceived(class_3222 sender) {
        boolean sendImmediately = requestingPlayers.getIfPresent((Object)sender.method_5667()) == null;
        requestingPlayers.put((Object)sender.method_5667(), new WeakReference<class_3222>(sender));
        if (sendImmediately) {
            TrainMapSync.send(sender.field_13995, false);
        }
    }

    public static void serverTick(MinecraftServer server) {
        if (++ticks % 10 == 0) {
            TrainMapSync.send(server, false);
        } else if (ticks % 5 == 0) {
            TrainMapSync.send(server, true);
        }
    }

    public static void send(MinecraftServer minecraftServer, boolean light) {
        if (requestingPlayers.size() == 0L) {
            return;
        }
        TrainMapSyncPacket packet = new TrainMapSyncPacket(light);
        for (Train train : Create.RAILWAYS.trains.values()) {
            packet.add(train.id, TrainMapSync.createEntry(minecraftServer, train));
        }
        for (WeakReference weakReference : requestingPlayers.asMap().values()) {
            class_3222 player = (class_3222)weakReference.get();
            if (player == null) continue;
            AllPackets.getChannel().sendToClient((S2CPacket)packet, player);
        }
    }

    private static TrainMapSyncEntry createEntry(MinecraftServer minecraftServer, Train train) {
        GlobalStation currentStation;
        class_3222 owner;
        TrainMapSyncEntry entry = new TrainMapSyncEntry();
        boolean stopped = Math.abs(train.speed) < 0.05;
        entry.positions = new float[train.carriages.size() * 6];
        entry.dimensions = new ArrayList<class_5321<class_1937>>();
        List<Carriage> carriages = train.carriages;
        for (int i = 0; i < carriages.size(); ++i) {
            class_243 trailingPos;
            class_243 leadingPos;
            Carriage carriage = carriages.get(i);
            if (train.graph == null) {
                Pair<class_5321<class_1937>, Carriage.DimensionalCarriageEntity> dimCarriage = carriage.anyAvailableDimensionalCarriage();
                if (dimCarriage == null || carriage.presentInMultipleDimensions()) {
                    entry.dimensions.add(null);
                    continue;
                }
                leadingPos = (class_243)((Carriage.DimensionalCarriageEntity)dimCarriage.getSecond()).rotationAnchors.getFirst();
                trailingPos = (class_243)((Carriage.DimensionalCarriageEntity)dimCarriage.getSecond()).rotationAnchors.getSecond();
                if (leadingPos == null || trailingPos == null) {
                    entry.dimensions.add(null);
                    continue;
                }
                entry.dimensions.add((class_5321<class_1937>)((class_5321)dimCarriage.getFirst()));
            } else {
                TravellingPoint leading = carriage.getLeadingPoint();
                TravellingPoint trailing = carriage.getTrailingPoint();
                if (leading == null || trailing == null || leading.edge == null || trailing.edge == null) {
                    entry.dimensions.add(null);
                    continue;
                }
                class_5321<class_1937> leadingDim = leading.node1 == null || leading.edge == null || leading.edge.isInterDimensional() ? null : leading.node1.getLocation().getDimension();
                class_5321<class_1937> trailingDim = trailing.node1 == null || trailing.edge == null || trailing.edge.isInterDimensional() ? null : trailing.node1.getLocation().getDimension();
                class_5321<class_1937> carriageDim = leadingDim == null || leadingDim != trailingDim ? null : leadingDim;
                entry.dimensions.add(carriageDim);
                leadingPos = leading.getPosition(train.graph);
                trailingPos = trailing.getPosition(train.graph);
            }
            entry.positions[i * 6] = (float)leadingPos.method_10216();
            entry.positions[i * 6 + 1] = (float)leadingPos.method_10214();
            entry.positions[i * 6 + 2] = (float)leadingPos.method_10215();
            entry.positions[i * 6 + 3] = (float)trailingPos.method_10216();
            entry.positions[i * 6 + 4] = (float)trailingPos.method_10214();
            entry.positions[i * 6 + 5] = (float)trailingPos.method_10215();
        }
        entry.backwards = train.currentlyBackwards;
        if (train.owner != null && (owner = minecraftServer.method_3760().method_14602(train.owner)) != null) {
            entry.ownerName = owner.method_5477().getString();
        }
        if (train.derailed) {
            entry.state = TrainState.DERAILED;
            return entry;
        }
        ScheduleRuntime runtime = train.runtime;
        if (runtime.getSchedule() != null && stopped) {
            if (runtime.paused) {
                entry.state = TrainState.SCHEDULE_INTERRUPTED;
                return entry;
            }
            if (train.status.conductor) {
                entry.state = TrainState.CONDUCTOR_MISSING;
                return entry;
            }
            if (train.status.navigation) {
                entry.state = TrainState.NAVIGATION_FAILED;
                return entry;
            }
        }
        if ((runtime.getSchedule() == null || runtime.paused) && train.speed != 0.0) {
            entry.state = TrainState.RUNNING_MANUALLY;
        }
        if ((currentStation = train.getCurrentStation()) != null) {
            entry.targetStationName = currentStation.name;
            entry.targetStationDistance = 0;
        } else if (train.navigation.destination != null && !runtime.paused) {
            entry.targetStationName = train.navigation.destination.name;
            entry.targetStationDistance = Math.max(0, class_3532.method_15357((double)train.navigation.distanceToDestination));
        }
        if (stopped && train.navigation.waitingForSignal != null) {
            UUID signalId = (UUID)train.navigation.waitingForSignal.getFirst();
            boolean side = (Boolean)train.navigation.waitingForSignal.getSecond();
            SignalBoundary signal = train.graph.getPoint(EdgePointType.SIGNAL, signalId);
            if (signal != null) {
                boolean chainSignal = signal.types.get(side) == SignalBlock.SignalType.CROSS_SIGNAL;
                SignalState signalState = entry.signalState = chainSignal ? SignalState.CHAIN_SIGNAL : SignalState.BLOCK_SIGNAL;
                if (signal.isForcedRed(side)) {
                    entry.signalState = SignalState.WAITING_FOR_REDSTONE;
                } else {
                    SignalEdgeGroup group = Create.RAILWAYS.signalEdgeGroups.get(signal.groups.get(side));
                    if (group != null) {
                        for (Train other : group.trains) {
                            if (other == train) continue;
                            entry.waitingForTrain = other.id;
                            break;
                        }
                    }
                }
            }
        }
        if (train.fuelTicks > 0 && !stopped) {
            entry.fueled = true;
        }
        return entry;
    }

    static {
        requestingPlayers = new TickBasedCache<UUID, WeakReference<class_3222>>(20, false);
    }

    public static class TrainMapSyncEntry {
        public float[] prevPositions;
        public List<class_5321<class_1937>> prevDims;
        public float[] positions;
        public List<class_5321<class_1937>> dimensions;
        public TrainState state = TrainState.RUNNING;
        public SignalState signalState = SignalState.NOT_WAITING;
        public boolean fueled = false;
        public boolean backwards = false;
        public int targetStationDistance = 0;
        public String ownerName = "";
        public String targetStationName = "";
        public UUID waitingForTrain = null;

        public void gatherDimensions(DimensionPalette dimensionPalette) {
            for (class_5321<class_1937> resourceKey : this.dimensions) {
                if (resourceKey == null) continue;
                dimensionPalette.encode(resourceKey);
            }
        }

        public void send(class_2540 buffer, DimensionPalette dimensionPalette, boolean light) {
            buffer.method_10804(this.positions.length);
            for (float f : this.positions) {
                buffer.writeFloat(f);
            }
            buffer.method_10804(this.dimensions.size());
            Object object = this.dimensions.iterator();
            while (object.hasNext()) {
                class_5321 resourceKey = (class_5321)object.next();
                buffer.method_10804(resourceKey == null ? -1 : dimensionPalette.encode((class_5321<class_1937>)resourceKey));
            }
            buffer.method_10804(this.state.ordinal());
            buffer.method_10804(this.signalState.ordinal());
            buffer.writeBoolean(this.fueled);
            buffer.writeBoolean(this.backwards);
            buffer.method_10804(this.targetStationDistance);
            if (light) {
                return;
            }
            buffer.method_10814(this.ownerName);
            buffer.method_10814(this.targetStationName);
            buffer.writeBoolean(this.waitingForTrain != null);
            if (this.waitingForTrain != null) {
                buffer.method_10797(this.waitingForTrain);
            }
        }

        public void receive(class_2540 buffer, DimensionPalette dimensionPalette, boolean light) {
            this.positions = new float[buffer.method_10816()];
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = buffer.readFloat();
            }
            this.dimensions = new ArrayList<class_5321<class_1937>>();
            int dimensionsSize = buffer.method_10816();
            for (int i = 0; i < dimensionsSize; ++i) {
                int index = buffer.method_10816();
                this.dimensions.add(index == -1 ? null : dimensionPalette.decode(index));
            }
            this.state = TrainState.values()[buffer.method_10816()];
            this.signalState = SignalState.values()[buffer.method_10816()];
            this.fueled = buffer.readBoolean();
            this.backwards = buffer.readBoolean();
            this.targetStationDistance = buffer.method_10816();
            if (light) {
                return;
            }
            this.ownerName = buffer.method_19772();
            this.targetStationName = buffer.method_19772();
            this.waitingForTrain = null;
            if (buffer.readBoolean()) {
                this.waitingForTrain = buffer.method_10790();
            }
        }

        public void updateFrom(TrainMapSyncEntry other, boolean light) {
            this.prevPositions = this.positions;
            this.prevDims = this.dimensions;
            this.positions = other.positions;
            this.dimensions = other.dimensions;
            this.state = other.state;
            this.signalState = other.signalState;
            this.fueled = other.fueled;
            this.backwards = other.backwards;
            this.targetStationDistance = other.targetStationDistance;
            if (this.prevDims != null) {
                for (int i = 0; i < Math.min(this.prevDims.size(), this.dimensions.size()); ++i) {
                    if (this.prevDims.get(i) == this.dimensions.get(i)) continue;
                    for (int j = 0; j < 6; ++j) {
                        this.prevPositions[i * 6 + j] = this.positions[i * 6 + j];
                    }
                }
            }
            if (light) {
                return;
            }
            this.ownerName = other.ownerName;
            this.targetStationName = other.targetStationName;
            this.waitingForTrain = other.waitingForTrain;
        }

        public class_243 getPosition(int carriageIndex, boolean firstBogey, double time) {
            int startIndex = carriageIndex * 6 + (firstBogey ? 0 : 3);
            if (this.positions == null || this.positions.length <= startIndex + 2) {
                return class_243.field_1353;
            }
            class_243 position = new class_243((double)this.positions[startIndex], (double)this.positions[startIndex + 1], (double)this.positions[startIndex + 2]);
            if (this.prevPositions == null || this.prevPositions.length <= startIndex + 2) {
                return position;
            }
            class_243 prevPosition = new class_243((double)this.prevPositions[startIndex], (double)this.prevPositions[startIndex + 1], (double)this.prevPositions[startIndex + 2]);
            return prevPosition.method_35590(position, time);
        }
    }

    public static enum TrainState {
        RUNNING,
        RUNNING_MANUALLY,
        DERAILED,
        SCHEDULE_INTERRUPTED,
        CONDUCTOR_MISSING,
        NAVIGATION_FAILED;

    }

    public static enum SignalState {
        NOT_WAITING,
        WAITING_FOR_REDSTONE,
        BLOCK_SIGNAL,
        CHAIN_SIGNAL;

    }
}

