/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.wrench.NonVisualizationLevel;
import com.simibubi.create.content.contraptions.wrench.RadialWrenchHandler;
import com.simibubi.create.content.contraptions.wrench.RadialWrenchMenuSubmitPacket;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.fabric.VirtualRenderHelper;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import io.github.fabricators_of_create.porting_lib.util.KeyBindingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.pepperbell.simplenetworking.C2SPacket;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.joml.Matrix4f;

public class RadialWrenchMenu
extends AbstractSimiScreen {
    public static final Map<class_2769<?>, String> VALID_PROPERTIES = new HashMap();
    public static final Set<class_2960> BLOCK_BLACKLIST;
    private final class_2680 state;
    private final class_2338 pos;
    private final class_2586 blockEntity;
    private final class_1937 level;
    private final NonVisualizationLevel nonVisualizationLevel;
    private final List<Map.Entry<class_2769<?>, String>> propertiesForState;
    private final int innerRadius = 50;
    private final int outerRadius = 110;
    private int selectedPropertyIndex = 0;
    private List<class_2680> allStates = List.of();
    private String propertyLabel = "";
    private int ticksOpen;
    private int selectedStateIndex = 0;
    private final RenderElement iconScroll = RenderElement.of((ScreenElement)PonderGuiTextures.ICON_SCROLL);
    private final RenderElement iconUp = RenderElement.of((ScreenElement)AllIcons.I_PRIORITY_HIGH);
    private final RenderElement iconDown = RenderElement.of((ScreenElement)AllIcons.I_PRIORITY_LOW);

    public static void registerRotationProperty(class_2769<?> property, String label) {
        if (VALID_PROPERTIES.containsKey(property)) {
            return;
        }
        VALID_PROPERTIES.put(property, label);
    }

    public static void registerBlacklistedBlock(class_2960 location) {
        if (BLOCK_BLACKLIST.contains(location)) {
            return;
        }
        BLOCK_BLACKLIST.add(location);
    }

    public static Optional<RadialWrenchMenu> tryCreateFor(class_2680 state, class_2338 pos, class_1937 level) {
        if (BLOCK_BLACKLIST.contains(CatnipServices.REGISTRIES.getKeyOrThrow(state.method_26204()))) {
            return Optional.empty();
        }
        List<Map.Entry<class_2769<?>, String>> propertiesForState = VALID_PROPERTIES.entrySet().stream().filter(entry -> state.method_28498((class_2769)entry.getKey())).toList();
        if (propertiesForState.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RadialWrenchMenu(state, pos, level, propertiesForState));
    }

    private RadialWrenchMenu(class_2680 state, class_2338 pos, class_1937 level, List<Map.Entry<class_2769<?>, String>> properties) {
        this.state = state;
        this.pos = pos;
        this.level = level;
        this.nonVisualizationLevel = new NonVisualizationLevel(level);
        this.blockEntity = level.method_8321(pos);
        this.propertiesForState = properties;
        this.initForSelectedProperty();
    }

    private void initForSelectedProperty() {
        Map.Entry<class_2769<?>, String> entry = this.propertiesForState.get(this.selectedPropertyIndex);
        this.allStates = new ArrayList<class_2680>();
        this.cycleAllPropertyValues(this.state, entry.getKey(), this.allStates);
        this.propertyLabel = entry.getValue();
    }

    private void cycleAllPropertyValues(class_2680 state, class_2769<?> property, List<class_2680> states) {
        Optional first = property.method_11898().stream().findFirst();
        if (first.isEmpty()) {
            return;
        }
        int offset = 0;
        int safety = 100;
        while (safety-- > 0) {
            if (state.method_11654(property).equals(first.get())) {
                offset = 99 - safety;
                break;
            }
            state = (class_2680)state.method_28493(property);
        }
        safety = 100;
        while (safety-- > 0 && !states.contains(state)) {
            states.add(state);
            state = (class_2680)state.method_28493(property);
        }
        this.selectedStateIndex = (offset = class_3532.method_15340((int)offset, (int)0, (int)(states.size() - 1))) == 0 ? 0 : states.size() - offset;
    }

    public void method_25393() {
        ++this.ticksOpen;
        if (!this.level.method_8320(this.pos).method_27852(this.state.method_26204())) {
            class_310.method_1551().method_1507(null);
        }
        super.method_25393();
    }

    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416((float)x, (float)y, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int mouseOffsetX = mouseX - this.field_22789 / 2;
        int mouseOffsetY = mouseY - this.field_22790 / 2;
        if (class_3532.method_39241((double)mouseOffsetX, (double)mouseOffsetY) > 45.0) {
            double theta = class_3532.method_15349((double)mouseOffsetX, (double)mouseOffsetY);
            float sectorSize = 360.0f / (float)this.allStates.size();
            this.selectedStateIndex = (int)Math.floor((-AngleHelper.deg((double)class_3532.method_15349((double)mouseOffsetX, (double)mouseOffsetY)) + 180.0f + sectorSize / 2.0f) % 360.0f / sectorSize);
            this.renderDirectionIndicator(graphics, theta);
        }
        this.renderRadialSectors(graphics);
        UIRenderHelper.streak((class_332)graphics, (float)0.0f, (int)0, (int)0, (int)32, (int)65, (Color)Color.BLACK.setAlpha(0.8f));
        UIRenderHelper.streak((class_332)graphics, (float)180.0f, (int)0, (int)0, (int)32, (int)65, (Color)Color.BLACK.setAlpha(0.8f));
        if (this.selectedPropertyIndex > 0) {
            this.iconScroll.at(-14.0f, -46.0f).render(graphics);
            this.iconUp.at(-1.0f, -46.0f).render(graphics);
            graphics.method_25300(this.field_22793, this.propertiesForState.get(this.selectedPropertyIndex - 1).getValue(), 0, -30, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
        if (this.selectedPropertyIndex < this.propertiesForState.size() - 1) {
            this.iconScroll.at(-14.0f, 30.0f).render(graphics);
            this.iconDown.at(-1.0f, 30.0f).render(graphics);
            graphics.method_25300(this.field_22793, this.propertiesForState.get(this.selectedPropertyIndex + 1).getValue(), 0, 22, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
        graphics.method_25300(this.field_22793, "Currently", 0, -13, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        graphics.method_25300(this.field_22793, "Changing:", 0, -3, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        graphics.method_25300(this.field_22793, this.propertyLabel, 0, 7, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        ms.method_22909();
    }

    private void renderRadialSectors(class_332 graphics) {
        int sectors = this.allStates.size();
        if (sectors < 2) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        float sectorAngle = 360.0f / (float)sectors;
        int sectorWidth = 60;
        poseStack.method_22903();
        for (int i = 0; i < sectors; ++i) {
            Color innerColor = Color.WHITE.setAlpha(0.05f);
            Color outerColor = Color.WHITE.setAlpha(0.3f);
            class_2680 blockState = this.allStates.get(i);
            class_2769<?> property = this.propertiesForState.get(this.selectedPropertyIndex).getKey();
            poseStack.method_22903();
            if (i == this.selectedStateIndex) {
                innerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.2f), 0.5f);
                outerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.6f), 0.5f);
                UIRenderHelper.drawRadialSector((class_332)graphics, (float)112.0f, (float)113.0f, (float)(-(sectorAngle / 2.0f + 90.0f)), (float)sectorAngle, (Color)outerColor, (Color)outerColor);
            }
            UIRenderHelper.drawRadialSector((class_332)graphics, (float)50.0f, (float)110.0f, (float)(-(sectorAngle / 2.0f + 90.0f)), (float)sectorAngle, (Color)innerColor, (Color)outerColor);
            Color c = innerColor.copy().setAlpha(0.5f);
            UIRenderHelper.drawRadialSector((class_332)graphics, (float)47.0f, (float)48.0f, (float)(-(sectorAngle / 2.0f + 90.0f)), (float)sectorAngle, (Color)c, (Color)c);
            ((PoseTransformStack)TransformStack.of((class_4587)poseStack).translateY(-((float)sectorWidth / 2.0f + 50.0f))).rotateZDegrees((float)(-i) * sectorAngle);
            poseStack.method_46416(0.0f, 0.0f, 100.0f);
            try {
                class_1937 previousLevel = this.blockEntity.method_10997();
                this.blockEntity.method_31662((class_1937)this.nonVisualizationLevel);
                new EvilBlockElement(blockState, this.blockEntity).rotateBlock(player.method_36455(), player.method_36454() + 180.0f, 0.0).scale(24.0).at(-12.0f, 12.0f).render(graphics);
                this.blockEntity.method_31662(previousLevel);
            }
            catch (Exception e) {
                Create.LOGGER.warn("Failed to render blockstate in RadialWrenchMenu", (Throwable)e);
                this.allStates.remove(i);
                this.selectedStateIndex = 0;
                return;
            }
            poseStack.method_46416(0.0f, 0.0f, 50.0f);
            if (i == this.selectedStateIndex) {
                graphics.method_25300(this.field_22793, blockState.method_11654(property).toString(), 0, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
            }
            poseStack.method_22909();
            poseStack.method_22903();
            TransformStack.of((class_4587)poseStack).rotateZDegrees(sectorAngle / 2.0f);
            poseStack.method_46416(0.0f, -70.0f, 10.0f);
            UIRenderHelper.angledGradient((class_332)graphics, (float)-90.0f, (int)0, (int)0, (float)0.5f, (float)(sectorWidth - 10), (Color)Color.WHITE.setAlpha(0.5f), (Color)Color.WHITE.setAlpha(0.15f));
            UIRenderHelper.angledGradient((class_332)graphics, (float)90.0f, (int)0, (int)0, (float)0.5f, (float)25.0f, (Color)Color.WHITE.setAlpha(0.5f), (Color)Color.WHITE.setAlpha(0.15f));
            poseStack.method_22909();
            TransformStack.of((class_4587)poseStack).rotateZDegrees(sectorAngle);
        }
        poseStack.method_22909();
    }

    private void renderDirectionIndicator(class_332 graphics, double theta) {
        class_4587 poseStack = graphics.method_51448();
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        poseStack.method_22903();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)poseStack).rotateZ((float)(-theta))).translateY(53.0f)).translateZ(15.0f);
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f mat = poseStack.method_23760().method_23761();
        bufferbuilder.method_22918(mat, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, 0.75f).method_1344();
        bufferbuilder.method_22918(mat, 5.0f, -5.0f, 0.0f).method_22915(r, g, b, 0.4f).method_1344();
        bufferbuilder.method_22918(mat, 3.0f, -4.5f, 0.0f).method_22915(r, g, b, 0.4f).method_1344();
        bufferbuilder.method_22918(mat, 0.0f, -4.2f, 0.0f).method_22915(r, g, b, 0.4f).method_1344();
        bufferbuilder.method_22918(mat, -3.0f, -4.5f, 0.0f).method_22915(r, g, b, 0.4f).method_1344();
        bufferbuilder.method_22918(mat, -5.0f, -5.0f, 0.0f).method_22915(r, g, b, 0.4f).method_1344();
        tesselator.method_1350();
        poseStack.method_22909();
    }

    private void submitChange() {
        class_2680 selectedState = this.allStates.get(this.selectedStateIndex);
        if (selectedState != this.state) {
            AllPackets.getChannel().sendToServer((C2SPacket)new RadialWrenchMenuSubmitPacket(this.pos, selectedState));
        }
        this.method_25419();
    }

    public void method_25420(class_332 graphics) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f));
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, color.getRGB(), color.getRGB());
    }

    public boolean method_16803(int code, int scanCode, int modifiers) {
        class_3675.class_306 mouseKey = class_3675.method_15985((int)code, (int)scanCode);
        if (KeyBindingHelper.isActiveAndMatches((class_304)AllKeys.ROTATE_MENU.getKeybind(), (class_3675.class_306)mouseKey)) {
            this.submitChange();
            return true;
        }
        return super.method_16803(code, scanCode, modifiers);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.submitChange();
            return true;
        }
        if (pButton == 1) {
            this.method_25419();
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.propertiesForState.size() < 2) {
            return super.method_25401(pMouseX, pMouseY, pDelta);
        }
        int indexDelta = (int)Math.round(Math.signum(-pDelta));
        int newIndex = this.selectedPropertyIndex + indexDelta;
        if (newIndex < 0) {
            return false;
        }
        if (newIndex >= this.propertiesForState.size()) {
            return false;
        }
        this.selectedPropertyIndex = newIndex;
        this.initForSelectedProperty();
        return true;
    }

    public void method_25432() {
        RadialWrenchHandler.COOLDOWN = 2;
        super.method_25432();
    }

    static {
        RadialWrenchMenu.registerRotationProperty(RotatedPillarKineticBlock.AXIS, "Axis");
        RadialWrenchMenu.registerRotationProperty(DirectionalKineticBlock.FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, "Axis");
        RadialWrenchMenu.registerRotationProperty(HorizontalKineticBlock.HORIZONTAL_FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(class_2377.field_11129, "Facing");
        RadialWrenchMenu.registerRotationProperty(DirectedDirectionalBlock.TARGET, "Target");
        RadialWrenchMenu.registerRotationProperty(SequencedGearshiftBlock.VERTICAL, "Vertical");
        BLOCK_BLACKLIST = new HashSet<class_2960>();
        RadialWrenchMenu.registerBlacklistedBlock(AllBlocks.LARGE_WATER_WHEEL.getId());
        RadialWrenchMenu.registerBlacklistedBlock(AllBlocks.WATER_WHEEL_STRUCTURAL.getId());
    }

    public static class EvilBlockElement
    extends GuiGameElement.GuiBlockEntityRenderBuilder {
        private final class_2586 realBlockEntity;

        public EvilBlockElement(class_2680 state, class_2586 be) {
            super(state, null);
            this.realBlockEntity = be;
        }

        protected void renderModel(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 ms) {
            VirtualRenderHelper.withForcedVirtualState(false, () -> super.renderModel(blockRenderer, buffer, ms));
            this.renderBlockEntity(buffer, ms);
        }

        private void renderBlockEntity(class_4597.class_4598 buffer, class_4587 ms) {
            class_827 renderer = class_310.method_1551().method_31975().method_3550(this.realBlockEntity);
            if (renderer == null) {
                return;
            }
            class_2680 stateBefore = this.realBlockEntity.method_11010();
            this.realBlockEntity.method_31664(this.blockState);
            renderer.method_3569(this.realBlockEntity, 0.0f, ms, (class_4597)buffer, 0xF000F0, class_4608.field_21444);
            this.realBlockEntity.method_31664(stateBefore);
        }
    }
}

