/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import com.simibubi.create.content.equipment.toolbox.ToolboxMenu;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.simibubi.create.foundation.utility.ResetableLazy;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class ToolboxBlockEntity
extends SmartBlockEntity
implements class_3908,
class_1275,
SidedStorageBlockEntity {
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat drawers = LerpedFloat.linear().startWithValue(0.0);
    UUID uniqueId;
    ToolboxInventory inventory;
    ResetableLazy<class_1767> colorProvider;
    Map<Integer, WeakHashMap<class_1657, Integer>> connectedPlayers = new HashMap<Integer, WeakHashMap<class_1657, Integer>>();
    private class_2561 customName;
    private AnimatedContainerBehaviour<ToolboxMenu> openTracker;

    public ToolboxBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory = new ToolboxInventory(this);
        this.colorProvider = ResetableLazy.of(() -> {
            class_2680 blockState = this.method_11010();
            if (blockState != null && blockState.method_26204() instanceof ToolboxBlock) {
                return ((ToolboxBlock)blockState.method_26204()).getColor();
            }
            return class_1767.field_7957;
        });
        this.setLazyTickRate(10);
    }

    public class_1767 getColor() {
        return this.colorProvider.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<ToolboxMenu>(this, ToolboxMenu.class);
        behaviours.add(this.openTracker);
    }

    @Override
    public void initialize() {
        super.initialize();
        ToolboxHandler.onLoad(this);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        ToolboxHandler.onUnload(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            this.tickAudio();
        }
        if (!this.field_11863.field_9236) {
            this.tickPlayers();
        }
        this.lid.chase(this.openTracker.openCount > 0 ? 1.0 : 0.0, (double)0.2f, LerpedFloat.Chaser.LINEAR);
        this.drawers.chase(this.openTracker.openCount > 0 ? 1.0 : 0.0, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.lid.tickChaser();
        this.drawers.tickChaser();
    }

    private void tickPlayers() {
        boolean update = false;
        Iterator<Map.Entry<Integer, WeakHashMap<class_1657, Integer>>> toolboxSlots = this.connectedPlayers.entrySet().iterator();
        while (toolboxSlots.hasNext()) {
            Map.Entry<Integer, WeakHashMap<class_1657, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<class_1657, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();
            class_1799 referenceItem = this.inventory.filters.get(slot);
            boolean clear = referenceItem.method_7960();
            Iterator<Map.Entry<class_1657, Integer>> playerEntries = set.entrySet().iterator();
            while (playerEntries.hasNext()) {
                Transaction t;
                int targetAmount;
                Map.Entry<class_1657, Integer> playerEntry = playerEntries.next();
                class_1657 player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                if (!clear && !ToolboxHandler.withinRange(player, this)) continue;
                class_1661 playerInv = player.method_31548();
                class_1799 playerStack = playerInv.method_5438(hotbarSlot);
                if (clear || !playerStack.method_7960() && !ToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    player.getCustomData().method_10562("CreateToolboxData").method_10551(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (!(player instanceof class_3222)) continue;
                    ToolboxHandler.syncData(player);
                    continue;
                }
                int count = playerStack.method_7947();
                if (count < (targetAmount = (referenceItem.method_7914() + 1) / 2)) {
                    class_1799 extracted;
                    Transaction t2;
                    int amountToReplenish = targetAmount - count;
                    if (this.isOpenInContainer(player)) {
                        t2 = TransferUtil.getTransaction();
                        try {
                            extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, (TransactionContext)t2);
                            if (!extracted.method_7960()) {
                                ToolboxHandler.unequip(player, hotbarSlot, false);
                                ToolboxHandler.syncData(player);
                                continue;
                            }
                        }
                        finally {
                            if (t2 == null) continue;
                            t2.close();
                            continue;
                        }
                    }
                    t2 = TransferUtil.getTransaction();
                    try {
                        extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, (TransactionContext)t2);
                        if (!extracted.method_7960()) {
                            update = true;
                            class_1799 template = playerStack.method_7960() ? extracted : playerStack;
                            playerInv.method_5447(hotbarSlot, ItemHandlerHelper.copyStackWithSize((class_1799)template, (int)(count + extracted.method_7947())));
                            t2.commit();
                        }
                    }
                    finally {
                        if (t2 != null) {
                            t2.close();
                        }
                    }
                }
                if (count <= targetAmount) continue;
                int amountToDeposit = count - targetAmount;
                class_1799 toDistribute = ItemHandlerHelper.copyStackWithSize((class_1799)playerStack, (int)amountToDeposit);
                if (this.isOpenInContainer(player)) {
                    t = TransferUtil.getTransaction();
                    try {
                        int deposited = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, (TransactionContext)t).method_7947();
                        if (deposited > 0) {
                            ToolboxHandler.unequip(player, hotbarSlot, true);
                            ToolboxHandler.syncData(player);
                            continue;
                        }
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                        continue;
                    }
                }
                t = TransferUtil.getTransaction();
                try {
                    int deposited = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, (TransactionContext)t).method_7947();
                    if (deposited <= 0) continue;
                    update = true;
                    playerInv.method_5447(hotbarSlot, ItemHandlerHelper.copyStackWithSize((class_1799)playerStack, (int)(count - deposited)));
                    t.commit();
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            if (!clear) continue;
            toolboxSlots.remove();
        }
        if (update) {
            this.sendData();
        }
    }

    private boolean isOpenInContainer(class_1657 player) {
        return player.field_7512 instanceof ToolboxMenu && ((ToolboxMenu)player.field_7512).contentHolder == this;
    }

    public void unequipTracked() {
        if (this.field_11863.field_9236) {
            return;
        }
        HashSet<class_3222> affected = new HashSet<class_3222>();
        for (Map.Entry<Integer, WeakHashMap<class_1657, Integer>> toolboxSlotEntry : this.connectedPlayers.entrySet()) {
            WeakHashMap<class_1657, Integer> set = toolboxSlotEntry.getValue();
            for (Map.Entry<class_1657, Integer> playerEntry : set.entrySet()) {
                class_1657 player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                ToolboxHandler.unequip(player, hotbarSlot, false);
                if (!(player instanceof class_3222)) continue;
                affected.add((class_3222)player);
            }
        }
        for (class_3222 player : affected) {
            ToolboxHandler.syncData((class_1657)player);
        }
        this.connectedPlayers.clear();
    }

    public void unequip(int slot, class_1657 player, int hotbarSlot, boolean keepItems) {
        if (!this.connectedPlayers.containsKey(slot)) {
            return;
        }
        this.connectedPlayers.get(slot).remove(player);
        if (keepItems) {
            return;
        }
        PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1657)player);
        SingleSlotStorage storage = playerInv.getSlot(hotbarSlot);
        if (storage.isResourceBlank()) {
            return;
        }
        ItemVariant resource = (ItemVariant)storage.getResource();
        int amount = (int)storage.getAmount();
        class_1799 toInsert = ToolboxInventory.cleanItemNBT(resource.toStack(amount));
        try (Transaction t = TransferUtil.getTransaction();){
            class_1799 remainder = this.inventory.distributeToCompartment(toInsert, slot, (TransactionContext)t);
            int inserted = amount - remainder.method_7947();
            storage.extract((Object)resource, (long)inserted, (TransactionContext)t);
            t.commit();
        }
    }

    private void tickAudio() {
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        if (this.lid.settled()) {
            if (this.openTracker.openCount > 0 && this.lid.getChaseTarget() == 0.0f) {
                this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14567, class_3419.field_15245, 0.25f, this.field_11863.field_9229.method_43057() * 0.1f + 1.2f, true);
                this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14982, class_3419.field_15245, 0.1f, this.field_11863.field_9229.method_43057() * 0.1f + 1.1f, true);
            }
            if (this.openTracker.openCount == 0 && this.lid.getChaseTarget() == 1.0f) {
                this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14823, class_3419.field_15245, 0.1f, this.field_11863.field_9229.method_43057() * 0.1f + 1.1f, true);
            }
        } else if (this.openTracker.openCount == 0 && this.lid.getChaseTarget() == 0.0f && this.lid.getValue(0.0f) > 0.0625f && this.lid.getValue(1.0f) < 0.0625f) {
            this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14819, class_3419.field_15245, 0.25f, this.field_11863.field_9229.method_43057() * 0.1f + 1.2f, true);
        }
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.inventory;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        super.read(compound, clientPacket);
        if (compound.method_10573("UniqueId", 11)) {
            this.uniqueId = compound.method_25926("UniqueId");
        }
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        if (this.uniqueId == null) {
            this.uniqueId = UUID.randomUUID();
        }
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_25927("UniqueId", this.uniqueId);
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        super.write(compound, clientPacket);
    }

    public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
        return ToolboxMenu.create(id, inv, this);
    }

    @Override
    public void lazyTick() {
        ToolboxHandler.onLoad(this);
        super.lazyTick();
    }

    public void connectPlayer(int slot, class_1657 player, int hotbarSlot) {
        if (this.field_11863.field_9236) {
            return;
        }
        WeakHashMap map = this.connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = (Integer)map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot) {
                return;
            }
            ToolboxHandler.unequip(player, previous, false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(class_2487 compound) {
        this.inventory.deserializeNBT(compound);
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean isFullyInitialized() {
        return this.uniqueId != null;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public class_2561 method_5476() {
        return this.customName != null ? this.customName : ((ToolboxBlock)AllBlocks.TOOLBOXES.get(this.getColor()).get()).method_9518();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    public class_2561 method_5477() {
        return this.customName;
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.colorProvider.reset();
    }
}

