/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.recipe.trie;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.recipe.trie.RecipeTrie;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;

public class RecipeTrieFinder {
    private static final Cache<Object, RecipeTrie<?>> CACHED_TRIES = CacheBuilder.newBuilder().build();

    public static RecipeTrie<?> get(@NotNull Object cacheKey, class_1937 world, Predicate<class_1860<?>> conditions) throws ExecutionException {
        return (RecipeTrie)CACHED_TRIES.get(cacheKey, () -> {
            List<class_1860<?>> list = RecipeFinder.get(cacheKey, world, conditions);
            RecipeTrie.Builder builder = RecipeTrie.builder();
            for (class_1860<?> recipe : list) {
                builder.insert(recipe);
            }
            return builder.build();
        });
    }

    public static enum Listener implements class_4013,
    IdentifiableResourceReloadListener
    {
        INSTANCE;

        public static final class_2960 ID;

        public class_2960 getFabricId() {
            return ID;
        }

        public void method_14491(class_3300 resourceManager) {
            CACHED_TRIES.invalidateAll();
        }

        static {
            ID = Create.asResource("recipe_trie_finder");
        }
    }
}

