/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.screen;

import com.google.common.collect.Sets;
import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.client.scissor.ScissorBoxStack;
import com.teamresourceful.resourcefullib.client.screens.CursorScreen;
import com.teamresourceful.resourcefullib.client.utils.CursorUtils;
import com.teamresourceful.resourcefullib.client.utils.ScreenUtils;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.config.RadioConfig;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundSetStationPacket;
import earth.terrarium.adastra.common.utils.radio.StationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioList
extends SelectionList<RadioEntry> {
    private static final class_2960 TEXTURE = new class_2960("ad_astra", "textures/radio/ui.png");
    private List<StationInfo> stations = new ArrayList<StationInfo>();
    private String playing = null;

    public RadioList(int x, int y, @Nullable class_2338 pos) {
        super(x, y, 91, 41, 12, entry -> {
            if (entry != null) {
                StationInfo info = entry.info;
                if (info == null) {
                    NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundSetStationPacket("", pos));
                } else if (!Objects.equals(RadioHandler.getPlaying(), info.url())) {
                    NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundSetStationPacket(info.url(), pos));
                }
            }
        }, true);
    }

    public void update(List<StationInfo> stations, String url) {
        this.stations = stations;
        this.playing = url;
        this.update();
    }

    private void update() {
        RadioEntry entry;
        RadioEntry selected = null;
        ArrayList<RadioEntry> entries = new ArrayList<RadioEntry>();
        HashSet favoriteUrls = Sets.newHashSet((Object[])RadioConfig.favorites);
        ArrayList<StationInfo> favorites = new ArrayList<StationInfo>();
        ArrayList<StationInfo> others = new ArrayList<StationInfo>();
        for (StationInfo station : this.stations) {
            if (favoriteUrls.contains(station.url())) {
                favorites.add(station);
                continue;
            }
            others.add(station);
        }
        favorites.sort(Comparator.comparing(StationInfo::title));
        others.sort(Comparator.comparing(StationInfo::title));
        entries.add(new RadioEntry(null));
        for (StationInfo favorite : favorites) {
            entry = new RadioEntry(favorite);
            if (favorite.url().equals(this.playing)) {
                selected = entry;
            }
            entry.favorite = true;
            entries.add(entry);
        }
        for (StationInfo other : others) {
            entry = new RadioEntry(other);
            if (other.url().equals(this.playing)) {
                selected = entry;
            }
            entries.add(entry);
        }
        this.updateEntries(entries);
        if (selected != null) {
            this.setSelected(selected);
        }
    }

    public class RadioEntry
    extends ListEntry {
        @Nullable
        private final StationInfo info;
        private boolean favorite = false;

        public RadioEntry(StationInfo info) {
            this.info = info;
        }

        protected void render(@NotNull class_332 graphics, @NotNull ScissorBoxStack stack, int id, int left, int top, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick, boolean selected) {
            int v = selected ? 66 : (hovered ? 42 : 54);
            graphics.method_25290(TEXTURE, left + 1, top, 253.0f, (float)v, 89, 12, 512, 256);
            int textStart = left + 3;
            if ((this.favorite || hovered) && this.info != null) {
                String text = this.favorite ? "\u2605" : "\u2606";
                textStart = graphics.method_25303(class_310.method_1551().field_1772, text, textStart, top + 3, this.favorite ? 0xFFAA00 : 0xFFFFFF) + 2;
            }
            graphics.method_27535(class_310.method_1551().field_1772, this.getName(), textStart, top + 3, 0xFFFFFF);
            if (hovered) {
                if (this.info != null) {
                    ScreenUtils.setTooltip((class_2561)class_2561.method_43470((String)this.info.name()));
                }
                CursorUtils.setCursor((boolean)true, (CursorScreen.Cursor)CursorScreen.Cursor.POINTER);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int width = class_310.method_1551().field_1772.method_1727(this.favorite ? "\u2605" : "\u2606");
            if (this.info != null && mouseX > 0.0 && mouseX < (double)(width + 3) && mouseY > 0.0 && mouseY < 12.0) {
                ArrayList<String> favorites = new ArrayList<String>(Arrays.asList(RadioConfig.favorites));
                if (this.favorite) {
                    favorites.remove(this.info.url());
                } else {
                    favorites.add(this.info.url());
                }
                RadioConfig.favorites = favorites.toArray(new String[0]);
                AdAstra.CONFIGURATOR.saveConfig(AdAstraConfigClient.class);
                RadioList.this.update();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        private class_2561 getName() {
            return this.info == null ? class_2561.method_43471((String)"text.ad_astra.radio.none") : class_2561.method_43470((String)this.info.title());
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return false;
        }
    }
}

